<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Sugestão de Faturamento</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.13.1">
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.13.1">
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2511.13.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.13.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.13.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.13.1" />
    <!-- <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.13.1"> -->
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.13.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.13.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.13.1">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2511.13.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.13.1">
    <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2511.13.1">
    <style>
        .border-Field {
            border: 1px solid var(--font-color) !important;
            padding: 0 1.0em 0 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            border-radius: 3px;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        #tabelaPedidos_filter {
            visibility: hidden;
            margin: 0px;
            padding: 0px;
            height: 0px;
        }

        #tabelaItensPedido_filter {
            visibility: hidden;
            margin: 0px;
            padding: 0px;
            height: 0px;
        }

        .childrenTabelaPedido {
            max-height: 40vh;
            overflow-y: auto;
        }

        .childrenTabelaItensPedido {
            max-height: 40vh;
            overflow-y: auto;
        }

        #titlePedido {
            margin: 8px 0px 0px 10px;
        }

        #titleItensPedido {
            margin: 8px 0px 0px 10px;
        }

        .txtTotalizadores {
            font-size: 11px;
        }

        .chilldrenQtdes {
            width: 12% !important;
            height: 89% !important;
            margin-right: 1% !important;
            font-size: 13px;
        }

        .chilldrenQtdesPedidos {
            width: 40% !important;
            height: 89% !important;
            margin-right: 1% !important;
            font-size: 13px;
        }

        .chilldrenValoresPedidos {
            width: 46% !important;
            height: 89% !important;
            font-size: 13px;
        }

        .btnSuccess {
            background-color: #25d366 !important;
            border-color: #25d366 !important;
            color: #fff;
        }

        .btnSuccess:hover {
            background-color: #20ae59 !important;
            border-color: #20ae59 !important;
            color: #fff;
        }

        .spanVermelho {
            display: inline-block;
            width: 15px;
            height: 15px;
            background-color: var(--vermelho-grid) !important;
            margin-left: 10px;
            margin-top: 2px;
        }

        .spanVerde {
            display: inline-block;
            width: 15px;
            height: 15px;
            background-color: var(--textDesconto) !important;
            margin-left: 10px;
            margin-top: 2px;
        }

        .spanAzul {
            display: inline-block;
            width: 15px;
            height: 15px;
            background-color: var(--hover-color) !important;
            margin-left: 10px;
            margin-top: 2px;
        }

        .spanFont {
            display: inline-block;
            width: 15px;
            height: 15px;
            background-color: var(--font-color) !important;
            margin-left: 10px;
            margin-top: 2px;
        }

        .spanRoxo {
            display: inline-block;
            width: 15px;
            height: 15px;
            background-color: #7903fc !important;
            margin-left: 10px;
            margin-top: 2px;
        }

        .spanOlive {
            display: inline-block;
            width: 15px;
            height: 15px;
            background-color: #808000 !important;
            margin-left: 10px;
            margin-top: 2px;
        }

        .linhaVermelha {
            color: var(--vermelho-grid) !important;
        }

        .linhaVerde {
            color: var(--textDesconto) !important;
        }

        .linhaAzul {
            color: var(--hover-color) !important;
        }

        .linhaFont {
            color: var(--font-color) !important;
        }

        .linhaRoxa {
            color: #7903fc !important;
        }

        .linhaOlive {
            color: #808000 !important;
        }

        #legendaItens {
            font-size: 13px;
        }

        table {
            font-size: 12px;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Sugestão de Faturamento</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">

                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div>
                <div class="container-fluid">
                    <div class="row card">
                        <div class="col-sm-12 mt-3">
                            <div class="col-md-6 col-sm-12 col-12 pr-0 pl-2">
                                <button class="btn btn-success btn-sisp" id="btnFiltros"><i class="fas fa-search"></i> Filtros</button>
                                <button class="btn btn-primary btnSuccess btn-sisp" disabled id="btnAbreProcessar"><i class="fas fa-cogs"></i> Processar</button>
                                <button class="btn btn-primary btn-sisp" disabled id="btnReservar"><i class="fas fa-check"></i> Reservar</button>
                                <button class="btn btn-danger btn-sisp" id="btnExcluir" title="Abre o menu Exclusão de Reservas"><i class="fas fa-ban"></i> Excluir</button>
                                <button class="btn btn-secondary btn-sisp" id="btnImprimir"><i class="fas fa-print"></i> Imprimir</button>
                            </div>
                        </div>
                        <div class="col-sm-12 table-responsive card-body pb-1">
                            <div class="containerPedido">
                                <div id="childrenInfoDataTablePed" class="childrenInfoDataTablePed d-none">
                                    <div class="row">
                                        <button class="buttonExcel" title="Exportar" id="buttonExcel"><i class="fas fa-file-excel"></i></button>
                                        <button class="buttonColVis" title="Configurar colunas visíveis" id="buttonColVis"><i class="fas fa-cogs"></i></button>
                                        <h5 id="titlePedido">Dados Pedidos</h5>
                                    </div>
                                    <div class="row mt-2 pl-1" id="containerSelTodos">
                                        <div class="col-sm-12 icheck-primary d-inline">
                                            <input class="form-check-input" type="checkbox" id="checkSelecionarTodos">
                                            <label class="form-check-label" for="checkSelecionarTodos">Selecionar Todos</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="childrenTabelaPedido" id="childrenTabelaPedido">
                                    <table id="tabelaPedidos" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="containerTotalizadores d-none" id="containerTotalizadores">
                                <div class="row mt-2">

                                    <fieldset class="form border-Field mb-0 pb-0 chilldrenQtdes">
                                        <legend class="textoBorda mb-0 pb-0">Quantidades</legend>
                                        <div class="form-row">

                                            <div class="col-xl-6 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotPedidos">Pedidos:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotPedidos" name="txtTotPedidos" class="form-control" placeholder="Pedidos">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-6 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotClientes">Clientes:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotClientes" name="txtTotClientes" class="form-control" placeholder="Clientes">
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </fieldset>


                                    <fieldset class="form border-Field mb-0 pb-0 chilldrenQtdesPedidos">
                                        <legend class="textoBorda mb-0 pb-0">Quantidades Pedidos</legend>
                                        <div class="form-row">

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotPendente">Pendente:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotPendente" name="txtTotPendente" class="form-control" placeholder="Pendente">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotFaturado">Faturado:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotFaturado" name="txtTotFaturado" class="form-control" placeholder="Faturado">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotReservado">Reservado:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotReservado" name="txtTotReservado" class="form-control" placeholder="Reservado">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotExpedido">Expedido:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotExpedido" name="txtTotExpedido" class="form-control" placeholder="Expedido">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotAtendido">Atendido:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotAtendido" name="txtTotAtendido" class="form-control" placeholder="Atendido">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtTotSaldo">Saldo:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtTotSaldo" name="txtTotSaldo" class="form-control" placeholder="Saldo">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>


                                    <fieldset class="form border-Field mb-0 pb-0 chilldrenValoresPedidos">
                                        <legend class="textoBorda mb-0 pb-0">Valores Pedidos</legend>
                                        <div class="form-row">

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorTotPendente">Pendente:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtValorTotPendente" name="txtValorTotPendente" class="form-control" placeholder="Pendente">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorTotFaturado">Faturado:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtValorTotFaturado" name="txtValorTotFaturado" class="form-control" placeholder="Faturado">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorTotReservado">Reservado:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtValorTotReservado" name="txtValorTotReservado" class="form-control" placeholder="Reservado">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorTotExpedido">Expedido:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtValorTotExpedido" name="txtValorTotExpedido" class="form-control" placeholder="Expedido">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorTotAtendido">Atendido:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtValorTotAtendido" name="txtValorTotAtendido" class="form-control" placeholder="Atendido">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-xl-2 col-12 form-group">
                                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorTotSaldo">Saldo:</label>
                                                <div class="relative">
                                                    <div class="input-group">
                                                        <input type="text" class="input-default focus form-control txtTotalizadores" disabled id="txtValorTotSaldo" name="txtValorTotSaldo" class="form-control" placeholder="Saldo">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 table-responsive card-body pt-1">
                            <div class="containerItensPedido">
                                <div id="childrenInfoDataTableItensPed" class="childrenInfoDataTableItensPed d-none">
                                    <div class="row">
                                        <div></div>
                                        <button class="buttonExcel" title="Exportar" id="buttonExcelItens"><i class="fas fa-file-excel"></i></button>
                                        <button class="buttonColVis" title="Configurar colunas visíveis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>
                                        <h5 id="titleItensPedido">Itens do Pedidos</h5>
                                        <div class="col-md-12 col-sm-12 col-12 p-0">
                                            <fieldset class="form border-Field p-0" id="legendaItens">
                                                <legend class="textoBorda pb-0 mb-0">Legenda Itens do Pedido</legend>
                                                <div class="form-row justify-content-start mt-1">
                                                    <div class="col-md-4 col-12">
                                                        <div class="row">
                                                            <div class="col-1 col-md-1 mr-1 p-0">
                                                                <span class="spanAzul"></span>
                                                            </div>
                                                            <div class="col-10 col-md-10 p-0">
                                                                <label class="labelCheck"> Qtde total reservada</label>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-1 col-md-1 mr-1 p-0">
                                                                <span class="spanVermelho"></span>
                                                            </div>
                                                            <div class="col-10 col-md-10 p-0">
                                                                <label class="labelCheck"> Não atendido</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-12">
                                                        <div class="row">
                                                            <div class="col-1 col-md-1 mr-1 p-0">
                                                                <span class="spanVerde"></span>
                                                            </div>
                                                            <div class="col-10 col-md-10 p-0">
                                                                <label class="labelCheck"> Atende a ser reservado</label>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-1 col-md-1 mr-1 p-0">
                                                                <span class="spanFont"></span>
                                                            </div>
                                                            <div class="col-10 col-md-10 p-0">
                                                                <label class="labelCheck"> Tem qtde disponivel mas não atende os parâmetros</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-12">
                                                        <div class="row">
                                                            <div class="col-1 col-md-1 mr-1 p-0">
                                                                <span class="spanRoxo"></span>
                                                            </div>
                                                            <div class="col-10 col-md-10 p-0">
                                                                <label class="labelCheck"> Tem qtde parcial desconsiderando os parâmetros</label>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-1 col-md-1 mr-1 p-0">
                                                                <span class="spanOlive"></span>
                                                            </div>
                                                            <div class="col-10 col-md-10 p-0">
                                                                <label class="labelCheck"> Qtde total expedida</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </fieldset>
                                        </div>
                                    </div>
                                </div>
                                <div class="childrenTabelaItensPedido" id="childrenTabelaItensPedido">
                                    <table id="tabelaItensPedido" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody">
                <div class="modal-header">
                    <h4 class="modal-title">Filtros</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <div class="col-lg-4">
                            <fieldset class="form border-Field mb-0 pb-0">
                                <legend class="textoBorda mb-0 pb-0">Financeiro</legend>
                                <div class="form-row">
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Financeiro" id="rgFinTodos">
                                        <label class="form-check-label pr-1" for="rgFinTodos">Todos</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" checked name="Financeiro" id="rgFinLiberado">
                                        <label class="form-check-label pr-1" for="rgFinLiberado">Liberado</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Financeiro" id="rgFinBloqueado">
                                        <label class="form-check-label pr-1" for="rgFinBloqueado">Bloqueado</label>
                                    </div>
                                </div>
                            </fieldset>
                        </div>

                        <div class="col-lg-4">
                            <fieldset class="form border-Field mb-0 pb-0">
                                <legend class="textoBorda mb-0 pb-0">Comercial</legend>
                                <div class="form-row">
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Comercial" id="rgComTodos">
                                        <label class="form-check-label pr-1" for="rgComTodos">Todos</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" checked name="Comercial" id="rgComLiberado">
                                        <label class="form-check-label pr-1" for="rgComLiberado">Liberado</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Comercial" id="rgComBloqueado">
                                        <label class="form-check-label pr-1" for="rgComBloqueado">Bloqueado</label>
                                    </div>
                                </div>
                            </fieldset>
                        </div>

                        <div class="col-lg-4">
                            <fieldset class="form border-Field mb-0 pb-0">
                                <legend class="textoBorda mb-0 pb-0">Tipo Pedido</legend>
                                <div class="form-row">
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" checked name="TipoPedido" id="rgTipoPedTodos">
                                        <label class="form-check-label pr-1" for="rgTipoPedTodos">Todos</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="TipoPedido" id="rgTipoPedPendente">
                                        <label class="form-check-label pr-1" for="rgTipoPedPendente">Pendente</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="TipoPedido" id="rgTipoPedParcial">
                                        <label class="form-check-label pr-1" for="rgTipoPedParcial">Parcial</label>
                                    </div>
                                </div>
                            </fieldset>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-lg-4 mt-3">
                            <fieldset class="form border-Field mb-0 pb-0">
                                <legend class="textoBorda mb-0 pb-0">Pedido</legend>
                                <div class="form-row">
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Pedido" id="rgPedidoTodos">
                                        <label class="form-check-label pr-1" for="rgPedidoTodos">Todos</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" checked name="Pedido" id="rgPedidoPai">
                                        <label class="form-check-label pr-1" for="rgPedidoPai">Pai</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Pedido" id="rgPedidoFilho">
                                        <label class="form-check-label pr-1" for="rgPedidoFilho">Filho</label>
                                    </div>
                                </div>
                            </fieldset>
                        </div>

                        <div class="col-lg-4 mt-3">
                        <fieldset class="form border-Field mb-0 pb-0">
                                <legend class="textoBorda mb-0 pb-0">Pedidos Reservados</legend>
                                <div class="form-row">
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Reservados" id="rgResTodos">
                                        <label class="form-check-label pr-1" for="rgResTodos">Todos</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" name="Reservados" id="rgResReservado">
                                        <label class="form-check-label pr-1" for="rgResReservado">Reservados</label>
                                    </div>
                                    <div class="form-group ml-2 icheck-primary">
                                        <input type="radio" class="" checked name="Reservados" id="rgResPendente">
                                        <label class="form-check-label pr-1" for="rgResPendente">Não Reservados</label>
                                    </div>
                                </div>
                            </fieldset>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtDtEmissaoDe">Emissão (de/até):</label>
                            <div class="input-group">
                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDtEmissaoDe" name="txtDtEmissaoDe">
                                <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoAte" name="txtDtEmissaoAte">
                            </div>
                        </div>


                    </div>
                    <div class="row">
                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtDtEntregaDe">Entrega (de/até):</label>
                            <div class="input-group">
                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDtEntregaDe" name="txtDtEntregaDe">
                                <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtDtEntregaAte" name="txtDtEntregaAte">
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtDtSaidaDe">Saida (de/até):</label>
                            <div class="input-group">
                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDtSaidaDe" name="txtDtSaidaDe">
                                <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtDtSaidaAte" name="txtDtSaidaAte">
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtDtFaturaDe">Fatura (de/até):</label>
                            <div class="input-group">
                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDtFaturaDe" name="txtDtFaturaDe">
                                <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtDtFaturaAte" name="txtDtFaturaAte">
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-lg-2 form-group">
                            <label for="">Empresa Pedido: </label>
                            <div class="relative">
                                <select name="" id="txtEmpresaPed" value="" class="input-default">

                                </select>
                            </div>
                        </div>

                        <div class="col-lg-2 form-group">
                            <label for="">Classificação do Cliente: </label>
                            <div class="relative">
                                <select name="" id="txtClassificacaoCli" value="" class="input-default">
                                    <option value="Todos" selected>Todos</option>
                                    <option value="A">A</option>
                                    <option value="B">B</option>
                                    <option value="C">C</option>
                                    <option value="D">D</option>
                                    <option value="E">E</option>
                                    <option value="F">F</option>
                                    <option value="G">G</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraCliente" data-placement="top" checked><label for="cbConsideraCliente" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os clientes selecionados na pesquisa, se desmarcado, desconsidera os clientes selecionados na pesquisa e filtra por todos os outros clientes."></label>
                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="cbConsideraCliente">Cliente: </label>
                            </div>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaCliente" name="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraPedido" data-placement="top" checked><label for="cbConsideraPedido" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os pedidos selecionados na pesquisa, se desmarcado, desconsidera os pedidos selecionados na pesquisa e filtra por todos os outros pedidos."></label>
                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="cbConsideraPedido">Pedido: </label>
                            </div>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtPedido" name="txtPedido" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnPedido" name="btnPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaPedido" name="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-lg-4 form-group">
                            <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraProduto" data-placement="top" checked><label for="cbConsideraProduto" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os itens selecionados na pesquisa, se desmarcado, desconsidera os itens selecionados na pesquisa e filtra por todos os outros itens."></label>
                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="cbConsideraProduto">Itens do Pedido: </label>
                            </div>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaProduto" name="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtGrupoPA">Grupo de Produto: </label>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtGrupoPA" name="txtGrupoPA" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnGrupoPA" name="btnGrupoPA" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaGrupoPA" name="btnLimpaGrupoPA" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtRepresentante" name="txtRepresentante" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaRepresentante" name="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtStatusPed">Status do Pedido: </label>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtStatusPed" name="txtStatusPed" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnStatusPed" name="btnStatusPed" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaStatusPed" name="btnLimpaStatusPed" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraColecao" data-placement="top" checked><label for="cbConsideraColecao" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas as coleções selecionadas na pesquisa, se desmarcado, desconsidera as coleções selecionadas na pesquisa e filtra por todas ss outras coleções."></label>
                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="cbConsideraColecao">Coleção do Pedido: </label>
                            </div>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaColecao" name="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtDeposito">Depósito: </label>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnDeposito" name="btnDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaDeposito" name="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-lg-4 form-group">
                            <div class="icheck-primary d-flex"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraTabuf" data-placement="top" checked><label for="cbConsideraTabuf" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os estados selecionados na pesquisa, se desmarcado, desconsidera os estados selecionados na pesquisa e filtra por todos os outros estados."></label>
                                <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="cbConsideraTabuf">Estado: </label>
                            </div>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtTabuf" name="txtTabuf" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnTabuf" name="btnTabuf" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaTabuf" name="btnLimpaTabuf" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtTabPreco">Tabela de Preço: </label>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtTabPreco" name="txtTabPreco" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnTabPreco" name="btnTabPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaTabPreco" name="btnLimpaTabPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtTipoPedido">Tipo do Pedido: </label>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtTipoPedido" name="txtTipoPedido" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnTipoPedido" name="btnTipoPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaTipoPedido" name="btnLimpaTipoPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-lg-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtGrupoCli">Grupo de Cliente: </label>
                            <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtGrupoCli" name="txtGrupoCli" multiple="multiple"></select>
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnGrupoCli" name="btnGrupoCli" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaGrupoCli" name="btnLimpaGrupoCli" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="row">
                        <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                        <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modal-processar" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content" id="modalBody">
                <div class="modal-header">
                    <h4 class="modal-title">Processar</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMinAtendValor">%Min. Atend. Valor:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="100" id="txtMinAtendValor" name="txtMinAtendValor" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMinAtendQtde">%Min. Atend. Qtde:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="100" id="txtMinAtendQtde" name="txtMinAtendQtde" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMaxAtendValor">%Max. Atend. Valor:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="0" id="txtMaxAtendValor" name="txtMaxAtendValor" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMaxAtendQtde">%Max. Atend. Qtde:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="0" id="txtMaxAtendQtde" name="txtMaxAtendQtde" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row mt-2">

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorMaxPed">Valor Max. p/ Ped:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="999999" id="txtValorMaxPed" name="txtValorMaxPed" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValorMinPed">Valor Min. p/ Ped:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="0" id="txtValorMinPed" name="txtValorMinPed" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtValMinDup">Valor Min. p/ Dup:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="0" id="txtValMinDup" name="txtValMinDup" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMaxAtend">Valor Max. Atend:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="0" id="txtMaxAtend" name="txtMaxAtend" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row mt-2">

                        <div class="col-lg-3">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtMinAtendItens">%Percentual:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" value="0" id="txtMinAtendItens" name="txtMinAtendItens" class="form-control" placeholder="Saldo">
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <div class="row">
                        <button class="btn btn-danger btn-sisp" id="btnFecharProcessar"><i class="fas fa-times"></i> Desistir</button>     
                        <button class="btn btn-primary btnSuccess btn-sisp" id="btnProcessar"><i class="fas fa-check"></i> Processar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modal-reservar" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content" id="modalBody">
                <div class="modal-header">
                    <h4 class="modal-title">Reservar</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <div class="col-lg-9 col-12 form-group">
                            <label style="padding-left: 0 !important;" data-error="wrong" data-success="right" for="txtStatus">Status:</label>
                            <div class="relative">
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtStatus" name="txtStatus" class="form-control" placeholder="Status">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnStatus" name="btnStatus" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaStatus" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 form-group">
                            <label data-error="wrong" data-success="right" for="txtDtBase">Data Base:</label>
                            <div class="input-group">
                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDtBase" name="txtDtBase">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 form-group">
                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtObs">Observação:</label>
                            <div class="input-group">
                                <textarea class="input-default focus form-control create" id="txtObs" name="txtObs" placeholder="Observação" rows="3" cols="50" style="resize: none;"></textarea>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <div class="row">
                        <button class="btn btn-danger btn-sisp" id="btnFecharReserva"><i class="fas fa-times"></i> Desistir</button>     
                        <button class="btn btn-primary btnSuccess btn-sisp" id="btnConfirmarReserva"><i class="fas fa-check"></i> Confirmar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.2511.13.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.13.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.13.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.13.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.13.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.2511.13.1"></script>
    <script src="dist/js/sisplan.js?versao=3.2511.13.1"></script>
    <script src="utils/funcoes.js?versao=3.2511.13.1"></script>
    <script src="utils/cookies.js?versao=3.2511.13.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.2511.13.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.2511.13.1"></script>
    <script src="dist/js/driver.min.js?versao=3.2511.13.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.2511.13.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.2511.13.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.13.1"></script>
    <script src="dist/js/dataTables.keyTable2.js?versao=3.2511.13.1"></script>
    <script type="text/javascript" src="config.js?versao=3.2511.13.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2511.13.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2511.13.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('SUGESTAOFATURAMENTO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/sugestaofaturamento/sugestaofaturamento.js?versao=3.2511.13.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>