$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
        });
        driver.defineSteps([{
            element: '#txtProduto',
            popover: {
                title: 'Campo Produto',
                description: 'Selecionar o produto.',
                position: 'bottom'
            }
        },
        {
            element: '#txtTag',
            popover: {
                title: 'Campo Tag',
                description: 'Selecionar a Tag.',
                position: 'bottom'
            }
        },
        {
            element: '#txtTabPreco',
            popover: {
                title: 'Campo Tabela Preço',
                description: 'Selecionar a Tabela de Preço.',
                position: 'bottom'
            }
        },
        {
            element: '#btnGerar',
            popover: {
                title: 'Botão Gerar',
                description: 'Clique aqui para gerar as tags com os dados e quantidades informadas.',
                position: 'top'
            }
        },
        {
            element: '#btnLimpar',
            popover: {
                title: 'Botão Limpar',
                description: 'Clique aqui para limpar os campos e dados já gerados.',
                position: 'top'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir as tags geradas.',
                position: 'top'
            }
        },
        {
            element: '#tabelaGrade_wrapper',
            popover: {
                title: 'Grade',
                description: 'Aqui está a grade do produto para informar as quantidades de tags a serem geradas.',
                position: 'top'
            }
        },
        {
            element: '#tabelaTag_wrapper',
            popover: {
                title: 'Grade',
                description: 'Aqui está as tags a serem impressas.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let tagUrl = parametros[parametros.length - 1];

    const parametrosSistema = await BuscaParametrosSistema();
    const utilizaBarraLog = parametrosSistema[0].VALOR == 1;
    let controleImpressao = 'DE';

    if (utilizaBarraLog) {
        $('#btnAbreModalReimprimirTag').removeClass('d-none')
    }
    criaDataTablePadrao('#tabelaGrade', false, false, false, false, true, true, '400px');
    criaDataTablePadrao('#tabelaTag', false, false, false, false, true, true, '400px');

    //MODAL DE REIMPRESSÃO
    criaDataTablePadrao('#tabelaReimprimeTag', false, false, false, false, true, true);
    $('#txtTagReimp').autocompleta(1, `JSON={ "tabela":"CADTAG", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#btnTagReimp').pesquisa_serverside(['#txtTagReimp', '', '#txtColunas'],
        ['CODIGO', 'DESCRICAO', 'COLUNAS'],
        ['DESCRICAO', 'DESCRICAO', 'COLUNAS'],
        `{"tabela":"CADTAG", "camposSelect":[ "CODIGO", "DESCRICAO", "COLUNAS"], "where": ["1 = 1"]}`,
        'Pesquisa Tag'
    );
    $("#btnLimpaTagReimp").on("click", function () {
        $("#txtTagReimp").val("");
    });


    $('#btn-Produto').pesquisa_serverside(['#txtProduto'],
        ['CODIGO', 'DESCRICAO', 'CODIGO2'],
        ['DESCRICAO', 'DESCRICAO', 'CODIGO2'],
        `{"tabela":"PRODUTO",
         "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], 
         "where": ["1 = 1"]}`,
        'Pesquisa Produto',
        bloqueiaCampoNumOF
    );
    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null, "orderBy": ["codigo asc"]}`);
    $('#txtTag').autocompleta(1, `JSON={ "tabela":"CADTAG", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
    $('#txtCodCreEntrada').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtNumOF').autocompleta(1, `JSON={ "tabela":"OF1", "camposSelect":[ "CODIGO CHAVE", "PRODUTO DESCRICAO"], "where": null}`);
    $('#txtNumPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENBTIDADE.NOME DESCRICAO"], "leftjoin": [ {"tabela": "ENTIDADE", "condicao": "PEDIDO.CODCLI = ENTIDADE.CODCLI"} ], "where": null}`);
    $('#txtVariasOFs').pesquisa_variosServerside(1, `{ "tabela":"OF1", "camposSelect":[ "NUMERO", "CODIGO"], "where": [" 1 = 2"]}`, 'NUMERO', 'CODIGO');

    $('#btn-Tag').pesquisa_serverside(['#txtTag', '', '#txtColunas'],
        ['CODIGO', 'DESCRICAO', 'COLUNAS'],
        ['DESCRICAO', 'DESCRICAO', 'COLUNAS'],
        `{"tabela":"CADTAG", "camposSelect":[ "CODIGO", "DESCRICAO", "COLUNAS"], "where": ["1 = 1"]}`,
        'Pesquisa Tag'
    );

    $('#btn-TabPreco').pesquisa_serverside(['#txtTabPreco'],
        ['REGIAO', 'DESCRICAO'],
        ['DESCRICAO', 'DESCRICAO'],
        `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"], "where": ["1 = 1"]}`, 'Pesquisa Tabela Preço');

    $('#btnCodCre').pesquisa_serverside(['#txtCodCreEntrada'],
        ['CODCLI', 'NOME'],
        ['NOME', 'NOME'],
        `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["1 = 1"]}`, 'Pesquisa Fornecedor'
    );

    function bloqueiaCampoProduto() {
        if ($('#txtNumOF').val() != '') {
            $('#txtProduto').prop('disabled', true)
            $('#btn-Produto').prop('disabled', true)
            $('#btn-limpar-Produto').prop('disabled', true)
            $('#txtNumPedido').prop('disabled', true)
            $('#btnNumPedido').prop('disabled', true)
            $('#btnLimpaNumPedido').prop('disabled', true)
        }
        if ($('#txtNumPedido').val() != '') {
            $('#txtProduto').prop('disabled', true)
            $('#btn-Produto').prop('disabled', true)
            $('#btn-limpar-Produto').prop('disabled', true)
            $('#txtNumOF').prop('disabled', true)
            $('#btnNumOF').prop('disabled', true)
            $('#btnLimparNumOF').prop('disabled', true)
        }
        $('#txtProduto').trigger('blur')
    }

    function bloqueiaCampoNumOF() {
        if ($('#txtProduto').val() != '') {
            $('#txtNumOF').prop('disabled', true)
            $('#btnNumOF').prop('disabled', true)
            $('#btnLimparNumOF').prop('disabled', true)
            $('#txtNumPedido').prop('disabled', true)
            $('#btnNumPedido').prop('disabled', true)
            $('#btnLimpaNumPedido').prop('disabled', true)
        }
    }

    $('#btnNumOF').pesquisa_serverside(['#txtNumOF', '#txtProduto'],
        ['OF1.NUMERO', 'OF1.CODIGO'],
        ['OF1.CODIGO', 'PRODUTO.DESCRICAO'],
        `{"tabela":"OF1",  "camposSelect":["OF1.NUMERO", "OF1.CODIGO", "PRODUTO.DESCRICAO"], "leftjoin": [ {"tabela": "PRODUTO", "condicao": "OF1.CODIGO = PRODUTO.CODIGO"} ]}`,
        'Pesquisa OF',
        bloqueiaCampoProduto);

    $('#btnNumPedido').pesquisa_serverside(['#txtNumPedido'],
        ['PEDIDO.NUMERO'],
        ['ENTIDADE.NOME'],
        `{"tabela":"PEDIDO",  "camposSelect":["PEDIDO.NUMERO", "PEDIDO.CODCLI", "ENTIDADE.NOME"], "leftjoin": [ {"tabela": "ENTIDADE", "condicao": "PEDIDO.CODCLI = ENTIDADE.CODCLI"} ]}`,
        'Pesquisa Pedido',
        bloqueiaCampoProduto);

    $('#btnVariasOFs').pesquisa_serversideSel('#txtVariasOFs', `{"tabela":"OF1",  "camposSelect":["OF1.NUMERO", "OF1.CODIGO", "PRODUTO.DESCRICAO"], "leftjoin": [ {"tabela": "PRODUTO", "condicao": "OF1.CODIGO = PRODUTO.CODIGO"} ]}`, 'Pesquisa OF');

    $('#btnLimparVariasOFs').on('click', function () {
        $('#txtVariasOFs').empty().trigger('change')
    })

    $("#btn-limpar-Produto").on("click", function () {
        $("#txtProduto").val("");
        $('#txtNumOF').val("");
        $('#txtNumOF').prop('disabled', false)
        $('#btnNumOF').prop('disabled', false)
        $('#btnLimparNumOF').prop('disabled', false)
    });

    $("#btn-limpar-Tag").on("click", function () {
        $("#txtTag").val("");
    });

    $("#btn-limpar-TabPreco").on("click", function () {
        $("#txtTabPreco").val("");
    });

    $("#btnACodCre").on("click", function () {
        $("#txtCodCreEntrada").val("");
    });

    $("#btnLimparNumOF").on("click", function () {
        $("#txtNumOF").val("");
        $('#txtProduto').val('');
        $('#txtProduto').prop('disabled', false)
        $('#btn-Produto').prop('disabled', false)
        $('#btn-limpar-Produto').prop('disabled', false)
    });
    $("#btnLimpaNumPedido").on("click", function () {
        $('#txtNumPedido').val('');
        $('#txtProduto').prop('disabled', false)
        $('#btn-Produto').prop('disabled', false)
        $('#btn-limpar-Produto').prop('disabled', false)
        $('#txtNumOF').prop('disabled', false)
        $('#btnNumOF').prop('disabled', false)
        $('#btnLimparNumOF').prop('disabled', false)
    });

    $("#btnGerar").on("click", async function () {
        if ($('#txtNumPedido').val() == '') {
            controleImpressao = 'DE';
            await gerarTag();
        } else {
            $('#txtNumPedido').trigger('blur');
        };
    });

    $('#btnLimparReimp').on("click", function () {
        limpaTabelaReimp();
        $('#txtTagReimp').val('');
        $('#txtColunaInicial').val('0');
        $('#txtTagReimp').prop('disabled', false);
        $('#btnTagReimp').prop('disabled', false);
        $('#btnLimparTagReimp').prop('disabled', false);
        $('#txtBarraLog').val('');
    });

    $("#btnLimpar").on("click", function () {
        limpaTabela();
        $('#txtProduto').val('');
        $('#txtTag').val('');
        $('#txtTabPreco').val('');
        $('#txtColunaInicial').val('0');
        $('#txtTag').prop('disabled', false);
        $('#btn-Tag').prop('disabled', false);
        $('#btn-limpar-Tag').prop('disabled', false);
        $('#txtNumOF').prop('disabled', false);
        $('#btnNumOF').prop('disabled', false);
        $('#btnLimparNumOF').prop('disabled', false);
        $('#txtVariasOFs').empty().trigger('change');
        $('#txtNumPedido').val('');
        $('#btnNumPedido').prop('disabled', false);
        $('#btnLimpaNumPedido').prop('disabled', false);

        limpaValor('#txtFornecedor');
        limpaValor('#txtDocumento');
        $('#txtEntradaNF').val('');
        $('#txtSerie').val('');
    });

    if (tagUrl != "create") {
        let jsonTag = jQuery.parseJSON(descriptografaUrl(parametros[parametros.length - 1]));
        insereValor("#txtNumOF", jsonTag.NUMERO, { tabela: 'OF1', campoBusca: 'CODIGO', campoWhere: 'NUMERO', valorWhere: jsonTag.NUMERO })
        insereValor('#txtProduto', jsonTag.CODIGO, jsonTag.DESCRICAO)
        codTag = (await buscaValor('CADTAG', 'CODIGO', 'PADRAO', 'S')).CODIGO
        colunas = (await buscaValor('CADTAG', 'COLUNAS', 'CODIGO', codTag)).COLUNAS
        insereValor('#txtColunas', colunas, codTag)
        insereValor("#txtTag", codTag, { tabela: 'CADTAG', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codTag })
        $('#txtNumOF').trigger('blur')
        $('#txtProduto').attr('disabled', true)
        $('#divTabGrade').removeClass('d-none');
        if ($('#txtProduto').val() != '') {
            if (pegaValor('#txtNumOF') != '') {
                explodeGradeProduto(pegaChave('#txtProduto'), pegaChave('#txtNumOF'));
            } else {
                explodeGradeProduto(pegaChave('#txtProduto'));
            }
        }
    }

    $("#txtProduto").blur(async function () {
        $('#divTabGrade').removeClass('d-none');
        if ($(this).val() != '') {
            if (pegaValor('#txtNumOF') != '') {
                explodeGradeProduto(pegaChave(this), pegaChave('#txtNumOF'));
            } else {
                explodeGradeProduto(pegaChave(this));
            }
        }
    });

    $('#txtNumPedido').blur(async function () {
        $('#divTabGrade').removeClass('d-none');
        if ($(this).val() != '') {
            const numPedido = pegaChave(this);
            controleImpressao = 'PED';
            const pesquisaParam = {
                tabela: 'PED_ITEN',
                camposSelect: ['DISTINCT PED_ITEN.CODIGO', 'PED_ITEN.COR', 'CADCOR.DESCRICAO AS DESC_COR', 'PED_ITEN.TAM', 'PRODUTO.FAIXA', 'FAIXA_ITEN.POSICAO', '(PED_ITEN.QTDE + PED_ITEN.QTDE_F) AS QTDE'],
                innerJoin: [
                    { "tabela": "PRODUTO", "condicao": "PED_ITEN.CODIGO = PRODUTO.CODIGO" },
                    { "tabela": "FAIXA_ITEN", "condicao": "PRODUTO.FAIXA = FAIXA_ITEN.FAIXA AND PED_ITEN.TAM = FAIXA_ITEN.TAMANHO" },
                    { "tabela": "CADCOR", "condicao": "CADCOR.COR = PED_ITEN.COR" }
                ],
                where: [`PED_ITEN.NUMERO = '${numPedido}'`],
                orderBy: ['PED_ITEN.CODIGO', 'FAIXA_ITEN.POSICAO', 'PED_ITEN.COR', 'PED_ITEN.TAM']
            }
            const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));
            await gerarTag(jsonStr, numPedido);
        };
    });

    $('#txtTag').focusout(async function () {
        await retornaColunas(pegaChave(this));
        if ($('#txtNumPedido').val() != '') {
            bloqueiaCampoProduto();
        };
    });

    $('#txtTagReimp').focusout(async function () {
        insereValor('#txtColunas', 0);
        if (pegaChave(this) != '') {
            const pesquisaParam = {
                tabela: 'CADTAG',
                camposSelect: ['COLUNAS'],
                where: [`CADTAG.CODIGO = '${pegaChave(this)}'`],
            }
            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
            insereValor('#txtColunas', jsonStr[0].COLUNAS);
        }
        if ($('#txtTagReimp').val() != '') {
            $('#txtTagReimp').prop('disabled', true);
            $('#btnTagReimp').prop('disabled', true);
            $('#btnLimparTagReimp').prop('disabled', true);
        }
    });

    async function retornaColunas(tag) {
        insereValor('#txtColunas', 0);
        if (tag != '') {
            const pesquisaParam = {
                tabela: 'CADTAG',
                camposSelect: ['COLUNAS'],
                where: [`CADTAG.CODIGO = '${tag}'`],
            }
            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
            insereValor('#txtColunas', jsonStr[0].COLUNAS);
        }
        if ($('#txtTag').val() != '') {
            $('#txtTag').prop('disabled', true);
            $('#btn-Tag').prop('disabled', true);
            $('#btn-limpar-Tag').prop('disabled', true);
        }
    };

    function limpaTabela() {
        $("#tabelaGrade tr").remove();
        $("#tabelaTag tr").remove();
        if ($('#tabelaTag').DataTable().rows().count() > 0) {
            $('#tabelaTag').empty();
            criaDataTablePadrao('#tabelaTag', false, false, false, false, true, true, '400px');
            $("#tabelaTag").DataTable().columns.adjust().draw(false);
        };
    };

    function limpaTabelaReimp() {
        $("#tabelaReimprimeTag tr").remove();
        if ($('#tabelaReimprimeTag').DataTable().rows().count() > 0) {
            $('#tabelaReimprimeTag').empty();
            criaDataTablePadrao('#tabelaReimprimeTag', false, false, false, false, true, true);
            $("#tabelaReimprimeTag").DataTable().columns.adjust().draw(false);
        };
    };

    async function explodeGradeProduto(codigo, numOf = null) {
        $.LoadingOverlay('show');
        try {
            let tam;
            let qtde;
            if ($.fn.DataTable.isDataTable('#tabelaGrade')) {
                $('#tabelaGrade').DataTable().destroy();
                $('#tabelaGrade').empty();
            };

            const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}`, null);
            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.RESULT[0].mensagem);
            }

            let jsonStrQtdeCorTam = []
            if (numOf != null) {
                const pesquisaParam = {
                    tabela: 'OF_ITEN',
                    camposSelect: ['COR', 'TAM', 'QTDE'],
                    where: [`NUMERO = '${numOf}'`],
                }
                jsonStrQtdeCorTam = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
            }

            for (let i = 0; i < parseInt(jsonStr.length); i++) {
                const colunas = Object.keys(jsonStr[i]);
                const tamanhos = [];
                colunas.forEach((coluna) => {
                    if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
                        tamanhos.push(coluna);
                    }
                });

                tamanhos.sort();

                const jsonObject = jsonStr.map(obj => {
                    const newObject = { ...obj };
                    delete newObject.CODIGO;
                    delete newObject.POSICAO;
                    Object.keys(obj).forEach(key => {
                        tam = RetornaIdTamFormatado(key);
                        if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(tam)) {
                            qtde = jsonStrQtdeCorTam.filter(f => { return f.COR == newObject.COR && f.TAM == tam.split('HIFEN')[1] }).length > 0 ? jsonStrQtdeCorTam.filter(f => { return f.COR == newObject.COR && f.TAM == tam.split('HIFEN')[1] })[0].QTDE : 0
                            newObject[tam] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR.replace('.', '_PONTO_') + tam}" value="${jsonStr[i][tam]}">`;
                            newObject[tam.split('HIFEN')[1]] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR.replace('.', '_PONTO_') + tam}" value="${qtde}">`;
                            delete newObject[tam];
                        }
                    });
                    return { ...newObject };
                });

                if (i == 0) {
                    const titulosFixos = ['COR', 'DESC_COR'];
                    const titulosGeral = [...titulosFixos, ...tamanhos];
                    const titulos = titulosGeral.map(titulo => {
                        const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
                        const objeto = { title: coluna, data: RetornaIdTamFormatado(coluna) };
                        return objeto;
                    });
                    criaDataTablePadrao('#tabelaGrade', false, false, false, false, true, true, '250px', jsonObject, titulos);
                }
            }

        } finally {
            $.LoadingOverlay('hide');

            $('.camposGrade').on('blur', function () {
                preencheComZero();
            });

            $('.camposGrade').maskMoney({
                decimal: ".",
                thousands: "",
                precision: 0,
            });
            preencheComZero();
        }
    };

    $("#btnReimprimir").on("click", async function () {
        try {
            $.LoadingOverlay("show");
            try {
                let grade = await retornaBarraLogExistente();
                let tag = $("#tabelaReimprimeTag").DataTable().rows().data().toArray();

                const url = `/sisplan/impressao/v1/imprimirreltag?`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('WTag');
                const arquivo = await GeraRelatorio(`${url}`, "POST", 600000, false, 'WTag', `JSON=${JSON.stringify(grade)}&JSONTAG=${JSON.stringify(tag)}`);

                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function retornaBarraLogExistente() {
        let grade = []
        const pesquisa = {
            tabela: 'BARRA_LOG',
            camposSelect: ['BARRA_LOG.NUM_OF', 'BARRA_LOG.CODIGO', 'BARRA_LOG.COR', 'CADCOR.DESCRICAO DESC_COR', 'BARRA_LOG.TAMANHO', 'BARRA_LOG.QUANT'],
            leftJoin: [{
                tabela: 'CADCOR',
                condicao: 'BARRA_LOG.COR = CADCOR.COR'
            }],
            where: [`BARRA_LOG.BARRA = '${$('#txtBarraLog').val()}'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

        const retorno = {
            BARRA: $('#txtBarraLog').val(),
            NUM_OF: jsonStr[0].NUM_OF,
            CODIGO: jsonStr[0].CODIGO,
            COR: jsonStr[0].COR,
            DESC_COR: jsonStr[0].DESC_COR,
            TAM: jsonStr[0].TAMANHO,
            QTDE: jsonStr[0].QUANT,
            TABPRECO: '',
            COLUNAS: 1,
            TAG: pegaChave('#txtTagReimp'),
            COLINI: 1,
        };
        grade.push(retorno)
        return grade
    }

    $('#btnAbreModalReimprimirTag').on('click', async function () {
        $('#modalReimprimeTag').modal('show');
    })

    $('#btnConsultarReimpressao').on('click', async function () {
        if (!$('#txtBarraLog').val()) {
            throw msgAlerta('Necessário informar uma barra para realizar a consulta')
        }
        if (!$('#txtTagReimp').val()) {
            throw msgAlerta('Necessário informar uma tag para realizar a consulta da barra')
        }
        $.LoadingOverlay('show')
        try {
            let dataSet = [];
            let dataSetCols = [];
            let barraLog = await retornaBarraLogExistente()
            const params = `REIMPRESSAO=${true}&TAG=${pegaChave('#txtTagReimp')}&JSON=${JSON.stringify(barraLog)}&TIPO_IMPRESSAO=${controleImpressao}`;
            const response = await requisicao("POST", `/sisplan/impressao/v1/consulta_tag?`, "", params, null);
            const jsonStr = await response.json();
            if (response.status != 200) {
                throw msgAlerta(jsonStr.mensagem);
            }
            dataSet = jsonStr;
            let keys = Object.keys(dataSet[0]);
            for (let k in keys) {
                dataSetCols.push({
                    title: keys[k],
                    data: keys[k],
                });
            }

            insereValor('#txtColunaInicial', jsonStr[0].COLINI);

            $("#tabelaReimprimeTag").DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: false,
                lengthChange: false,
                scrollX: true,
                scrollY: "300px",
                scrollCollapse: true,
                paging: false,
                Filter: false,
                Info: true,
                Order: false,
                autoWidth: true,
                columns: dataSetCols,
                data: dataSet,
            });
        } catch (error) {
            console.log(error);
            msgAlerta('Não foi possível consultar a barra inserida, verifique!')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function saidaCamposEntradaNF() {
        if ($('#txtEntradaNF').val() != '' || $('#txtSerie').val() != '' || pegaChave('#txtFornecedor') != '') {
            $('#btnBuscarPorEntradaNf').prop('disabled', false);
        } else {
            $('#btnBuscarPorEntradaNf').prop('disabled', true);
        }
    }

    function saidaCamposMov() {
        if ($('#txtDocumento').val() != '') {
            $('#btnBuscarPorMovimentacao').prop('disabled', false);
        } else {
            $('#btnBuscarPorMovimentacao').prop('disabled', true);
        }
    }

    $('#txtEntradaNF').on('blur', function () {
        saidaCamposEntradaNF()
    })
    $('#txtSerie').on('blur', function () {
        saidaCamposEntradaNF()
    })

    async function ExisteBarra(Barra = 'BARRA28', codigo = '', cor = '', tam = '') {
        try {
            const pesquisaParam = {
                tabela: 'PA_ITEN',
                camposSelect: [Barra],
                where: [
                    `CODIGO = '${codigo}'`,
                    `COR = '${cor}'`,
                    `TAM = '${tam}'`,
                    `TIPO = '1'`
                ],
            };

            const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

            if (jsonStr && jsonStr.length > 0) {
                for (let item of jsonStr) {
                    const valor = (item[Barra] || '').trim();
                    if (valor !== '') {
                        return true;
                    }
                }
            }

            return false;

        } catch (err) {
            console.error('Erro ao verificar barra:', err);
            return false;
        }
    }

    async function GeraEAN28(codigo = '', cor = '', tamanho = '') {
        try {
            $.LoadingOverlay('show');

            const url = '/sisplan/barra/v1/gerabarra?';
            const ProdutoBarra = {
                TIPOBARRA: 2,
                BARRAS: [
                    {
                        CODIGO: codigo,
                        COR: cor,
                        TAMANHO: tamanho,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRA28',
                    }
                ],
            };

            const response = await requisicao(
                'POST',
                url,
                '',
                `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`,
                30000
            );

            if (!response) {
                throw new Error('Não foi possível gerar as barras.');
            }

            // const jsonStr = await response.json();

            // if (response.status !== 200) {
            //     const msg = jsonStr?.mensagem || 'Erro ao gerar código de barras.';
            //     msgAlerta(msg);
            //     throw new Error(msg);
            // }

            // const barraGerada =
            //     jsonStr?.BARRAS?.[0]?.BARRA ||
            //     jsonStr?.BARRA ||
            //     null;

            // return barraGerada;

        } catch (error) {
            console.error('Erro ao gerar EAN28:', error);
            throw error;
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function geraBarras(grade = []) {
        for (let item of grade) {
            const vCod = item.CODIGO || $('#txtProduto').val();
            const vCor = item.COR;
            const vTam = item.TAM;
            const qtde = parseInt(item.QTDE || 0);

            if (qtde > 0) {
                const existe = await ExisteBarra('BARRA28', vCod, vCor, vTam);
                if (!existe) {
                    await new Promise((resolve) => {
                        msgAlerta(
                            `O Produto: ${vCod}, Cor: ${vCor}, Tamanho: ${vTam} não possui código de barra28. Deseja gerar agora?`,
                            async () => {
                                try {
                                    await GeraEAN28(vCod, vCor, vTam);
                                    resolve(true);
                                } catch (e) {
                                    msgAlerta(`Erro ao gerar código de barras: ${e.message || e}`);
                                    resolve(false);
                                }
                            },
                            () => {
                                resolve(false);
                            }
                        );
                    });
                }
            }
        }
    }


    async function gerarTag(arrayPedIten = [], numeroPedido = '') {
        $.LoadingOverlay('show');

        try {
            $('#divTabGrade').removeClass('d-none');

            if (numeroPedido == '') {
                if ($('#txtProduto').val() == '') {
                    msgAlerta('Produto não informado, impossível continuar!');
                    return;
                };
            };

            if ($('#txtTag').val() == '') {
                msgAlerta('Tag não informada, impossível continuar!');
                return;
            };

            if (!pegaChave('#txtColunas') > '0') {
                msgAlerta('Quantidade de colunas não informada no cadastro de tag, impossível continuar!');
                return;
            };

            let grade = [];
            let tag = [];
            let dataSet = [];
            let dataSetCols = [];

            grade = retornaGrade(false, arrayPedIten, numeroPedido);

            if (!grade.length > 0) {
                msgAlerta('Nenhuma quantidade informada na grade do produto, impossível continuar!');
                return;
            }

            await geraBarras(grade);

            tag = $("#tabelaTag").DataTable().rows().data().toArray();

            const url = `/sisplan/impressao/v1/consulta_tag?`;
            const params = `TAG=${pegaChave('#txtTag')}&JSON=${JSON.stringify(grade)}&JSONTAG=${JSON.stringify(tag)}&TIPO_IMPRESSAO=${controleImpressao}`;
            const response = await requisicao("POST", url, "", params, 770000);
            const jsonStr = await response.json();
            if (response.status != 200) {
                throw msgAlerta(jsonStr.mensagem);
            }
            dataSet = jsonStr;
            let keys = Object.keys(dataSet[0]);
            for (let k in keys) {
                dataSetCols.push({
                    title: keys[k],
                    data: keys[k],
                });
            }

            insereValor('#txtColunaInicial', jsonStr[0].COLINI);

            $("#tabelaTag").DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: false,
                lengthChange: false,
                scrollX: true,
                scrollY: "300px",
                scrollCollapse: true,
                paging: false,
                Filter: false,
                Info: true,
                Order: false,
                autoWidth: true,
                columns: dataSetCols,
                data: dataSet,
            });
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function preencheComZero() {
        setTimeout(() => {
            $('.camposGrade').map((index) => {
                if ($($('.camposGrade')[index]).val() == '') {
                    $($('.camposGrade')[index]).val('0');
                }
            });
        }, 100);
    };

    function retornaGrade(impressao = false, arrayPedido = [], numPedido = '') {
        let grade = [];
        if (controleImpressao == 'DE') {
            const listaDados = $('#tabelaGrade').DataTable().data().toArray();
            listaDados.forEach(dado => {
                const objeto = Object.entries(dado);
                let coluna;
                const colunas = objeto.map(prop => prop[0]);

                for (let i = 0; i < colunas.length; i++) {
                    if ((!['COR', 'DESC_COR'].includes(colunas[i])) && (colunas[i].indexOf('/') == -1)) {
                        coluna = RetornaIdTamFormatado(colunas[i], true);
                        const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
                        const idFormatado = idSemFormatacao.split("value=")[0];
                        const retorno = {
                            NUM_OF: pegaChave('#txtNumOF'),
                            CODIGO: pegaChave('#txtProduto'),
                            COR: dado.COR,
                            DESC_COR: dado.DESC_COR,
                            TAM: coluna,
                            QTDE: $(`#${idFormatado}`).val(),
                            TABPRECO: pegaChave('#txtTabPreco'),
                            COLUNAS: pegaChave('#txtColunas'),
                            TAG: pegaChave('#txtTag'),
                            COLINI: pegaChave('#txtColunaInicial'),
                        };

                        if (impressao || retorno.QTDE > 0) {
                            grade.push(retorno);
                        }
                    }
                }
            });
        } else if (['NF', 'MOV'].includes(controleImpressao)) {
            grade.push({
                CODIGO: '',
                COR: '',
                DESC_COR: '',
                TAM: '',
                QTDE: 0,
                TABPRECO: pegaChave('#txtTabPreco'),
                COLUNAS: pegaChave('#txtColunas'),
                TAG: pegaChave('#txtTag'),
                COLINI: pegaChave('#txtColunaInicial'),
            })
        } else if (controleImpressao == 'PED') {
            if (arrayPedido.length > 0) {
                for (item in arrayPedido) {
                    grade.push({
                        NUM_OF: numPedido,
                        CODIGO: arrayPedido[item].CODIGO,
                        COR: arrayPedido[item].COR,
                        DESC_COR: arrayPedido[item].DESC_COR,
                        TAM: arrayPedido[item].TAM,
                        QTDE: arrayPedido[item].QTDE,
                        TABPRECO: pegaChave('#txtTabPreco'),
                        COLUNAS: pegaChave('#txtColunas'),
                        TAG: pegaChave('#txtTag'),
                        COLINI: pegaChave('#txtColunaInicial'),
                    })
                }
            }
        };

        return grade;
    }

    retornaHintRelatorio('btnImprimir', 'WTag + Codigo da TAG')
    retornaHintRelatorio('btnReimprimir', 'WTag + Codigo da TAG')

    $("#btnImprimir").on("click", async function () {
        try {
            $.LoadingOverlay("show");
            try {

                // se tem pedido informado, gera grade conforme pedido
                const numPedido = pegaChave('#txtNumPedido');
                let grade = '';
                if (numPedido != '') {
                    controleImpressao = 'PED';
                    const pesquisaParam = {
                        tabela: 'PED_ITEN',
                        camposSelect: ['DISTINCT PED_ITEN.CODIGO', 'PED_ITEN.COR', 'CADCOR.DESCRICAO AS DESC_COR', 'PED_ITEN.TAM', 'PRODUTO.FAIXA', 'FAIXA_ITEN.POSICAO', '(PED_ITEN.QTDE + PED_ITEN.QTDE_F) AS QTDE'],
                        innerJoin: [
                            { "tabela": "PRODUTO", "condicao": "PED_ITEN.CODIGO = PRODUTO.CODIGO" },
                            { "tabela": "FAIXA_ITEN", "condicao": "PRODUTO.FAIXA = FAIXA_ITEN.FAIXA AND PED_ITEN.TAM = FAIXA_ITEN.TAMANHO" },
                            { "tabela": "CADCOR", "condicao": "CADCOR.COR = PED_ITEN.COR" }
                        ],
                        where: [`PED_ITEN.NUMERO = '${numPedido}'`],
                        orderBy: ['PED_ITEN.CODIGO', 'FAIXA_ITEN.POSICAO', 'PED_ITEN.COR', 'PED_ITEN.TAM']
                    };
                    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));
                    grade = retornaGrade(false, jsonStr, numPedido);
                } else {
                    grade = retornaGrade(true);
                }

                let tag = $("#tabelaTag").DataTable().rows().data().toArray();

                const url = `/sisplan/impressao/v1/imprimirreltag?`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelTag');
                const arquivo = await GeraRelatorio(`${url}`, "POST", 600000, false, 'RelTag', `JSON=${JSON.stringify(grade)}&JSONTAG=${JSON.stringify(tag)}`);

                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnBuscar').on('click', function () {
        if ($('#txtTag').val() == '') {
            msgErro('É necessário informar uma etiqueta para continuar.');
            return;
        }

        if ($('#txtTabPreco').val() == '') {
            msgErro('É necessário informar uma tabela de preço para continuar.')
            return;
        }

        $.LoadingOverlay('show');
        $('#modalBuscar').modal('show');
        $.LoadingOverlay('hide');
    });

    $('#btnConsultarModal').on('click', function () {
        activeTab = $('#nav-tab .nav-link.active')?.attr('id')
        if (!activeTab) return

        switch (activeTab) {
            case 'tabNotaEntrada':
                buscarNfEntrada()
                break
            case 'tabMovimentacao':
                const filtros = retornarFiltrosMovimentacao()
                if (!filtros) return
                if (validarFiltrosMovimentacao(filtros))
                    retornarMovimentacao(filtros)
                break
            default:
                break
        }
    })

    $('#btnBuscarPorMovimentacao').on('click', async function () {
        if ($('#txtTag').val() == '') {
            msgErro('É necessário informar uma etiqueta para continuar.');
            return;
        }

        if ($('#txtTabPreco').val() == '') {
            msgErro('É necessário informar uma tabela de preço para continuar.')
            return;
        }

        const filtros = retornarFiltrosMovimentacao()
        if (!filtros) return
        if (validarFiltrosMovimentacao(filtros))
            retornarMovimentacao(filtros)
    })

    $('#btnBuscarPorEntradaNf').on('click', async function () {
        if ($('#txtTag').val() == '') {
            msgErro('É necessário informar uma etiqueta para continuar.');
            return;
        }

        if ($('#txtTabPreco').val() == '') {
            msgErro('É necessário informar uma tabela de preço para continuar.')
            return;
        }

        await buscarNfEntrada()
    })

    async function buscarNfEntrada() {
        controleImpressao = 'NF';
        try {
            $.LoadingOverlay('show')
            const filtros = retornaFiltrosNF();
            if (filtros.numero == '') {
                msgErro('É necessário informar uma nota.');
                return;
            }

            if (filtros.serie == '') {
                msgErro('É necessário informar uma série.');
                return;
            }

            if (filtros.codcre == '') {
                msgErro('É necessário informar um fornecedor.')
                return;
            }

            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"NF_ENTRA_ITEN",
                        "camposSelect":["NUMERO"],                       
                        "where": ["NF_ENTRA_ITEN.NUMERO = '${filtros.numero}'", "NF_ENTRA_ITEN.SERIE = '${filtros.serie}'", "NF_ENTRA_ITEN.CODCRE = '${filtros.codcre}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro('Nota fiscal de entrada não existe ou não possui itens lançados.')
                return;
            }

            if (jsonStr.length == 0) {
                msgErro('Nota fiscal sem itens, favor verificar.')
                return;
            }

            await buscarItensNfEntrada(filtros);

        } catch (e) {
            console.log(e);
        } finally {
            $.LoadingOverlay('hide')
            $('#modalBuscar').modal('hide')
        }
    }

    async function buscarItensNfEntrada(filtros) {
        $('#divTabGrade').addClass('d-none');
        const response = await requisicao("POST", "/sisplan/impressao/v1/consulta_tag?",
            `NUMERO=${filtros.numero}&SERIE=${filtros.serie}&CODCRE=${filtros.codcre}&TAG=${filtros.tag}&NOMECRE=${filtros.nomecre}&TABPRECO=${filtros.tabpreco}&COLUNAS=${filtros.cols}&COLINI=${filtros.colini}&COMP_ETIQUETA=${filtros.comp_etiqueta}&TIPO_IMPRESSAO=${filtros.tipo_impressao}`,
            null,
            600000);

        if (!response) {
            return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        if (jsonStr.length == 0) {
            msgErro('Nenhum registro encontrado.');
            if ($.fn.DataTable.isDataTable('#tabelaTag')) {
                $('#tabelaTag').DataTable().destroy();
                $('#tabelaTag').empty();
            };
            return;
        }

        let dataSetCols = [];

        let keys = Object.keys(jsonStr[0]);
        for (let k in keys) {
            dataSetCols.push({
                title: keys[k],
                data: keys[k],
            });
        }

        $("#tabelaTag").DataTable({
            destroy: true,
            select: true,
            keys: true,
            searching: false,
            lengthChange: false,
            scrollX: true,
            scrollY: "300px",
            scrollCollapse: true,
            paging: false,
            Filter: false,
            Info: true,
            Order: false,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
        });
    };

    const numOfCadOf = localStorage.getItem('numoftag') ?? ''
    const produtoCadOf = localStorage.getItem('codprodtag') ?? ''
    if (numOfCadOf != '' && produtoCadOf != '') {
        await preencheDadosOrdemProducao(numOfCadOf, produtoCadOf)
    }

    async function preencheDadosOrdemProducao(numOf, produto) {
        $.LoadingOverlay('show')
        try {
            const pesquisaParam = {
                tabela: 'PRODUTO',
                camposSelect: ['DESCRICAO'],
                where: [`CODIGO = '${produto}'`],
            }
            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            insereValor('#txtProduto', produto, jsonStr[0].DESCRICAO);
            insereValor('#txtNumOF', numOf, produto);
            bloqueiaCampoProduto()
            localStorage.removeItem('numoftag')
            localStorage.removeItem('codprodtag')
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function retornaFiltrosNF() {
        let filtros = {
            numero: $('#txtEntradaNF').val(),
            serie: $('#txtSerie').val(),
            codcre: pegaChave('#txtFornecedor'),
            nomecre: pegaDescricao('#txtFornecedor'),
            tag: pegaChave('#txtTag'),
            tabpreco: pegaChave('#txtTabPreco'),
            comp_etiqueta: $('#cbCompEtiqueta').prop('checked') ? 'S' : 'N',
            cols: pegaChave('#txtColunas'),
            colini: pegaChave('#txtColunaInicial') == '' ? '1' : pegaChave('#txtColunaInicial'),
            tipo_impressao: controleImpressao
        }

        return filtros;
    }

    $('#txtVariasOFs').on('change', function () {
        if ($(this).val().length <= 0) {
            $('#btnProcessar').attr('disabled', true)
        } else {
            $('#btnProcessar').attr('disabled', false)
        }
    })

    $('#btnProcessar').on('click', async function () {
        if (pegaChave('#txtTag') == '') {
            msgAlerta('Tag não informada, impossível continuar!');
            return
        }
        $.LoadingOverlay('show')
        try {
            const ofs = $('#txtVariasOFs').val()
            const ofsFormatadas = await formataListas(ofs.toString())
            controleImpressao = 'DE';

            const pesquisa = {
                camposSelect: ["OF1.NUMERO", "OF1.CODIGO", "PRODUTO.DESCRICAO"],
                tabela: "OF1",
                where: [`OF1.NUMERO in (${ofsFormatadas})`],
                leftjoin: [{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = OF1.CODIGO' }],
            };

            const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

            for (let i = 0; i < ofs.length; i++) {
                $('#txtNumOF').val('')
                $('#txtProduto').val('')

                const codigo = jsonStr.filter(item => item.NUMERO == ofs[i])[0].CODIGO;
                const descricao = jsonStr.filter(item => item.NUMERO == ofs[i])[0].DESCRICAO;

                insereValor('#txtNumOF', ofs[i], codigo);

                insereValor('#txtProduto', codigo, descricao);

                await explodeGradeProduto(codigo, ofs[i])

                await gerarTag();
            }

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#selectEntradaSaida').on('change', function () {
        const where = [`OPERACAO = '${this.value}'`]
        $('#txtDocumento').val('')
        componenteFiltro('movimentacaoProduto', false, false, 'Documento', where, true, saidaCamposMov)
    })

    componenteFiltro('movimentacaoProduto', false, false, 'Documento', [`OPERACAO = 'E'`], true, saidaCamposMov)
    componenteFiltro('fornecedor', false, false, '', [], false, saidaCamposEntradaNF)

    const retornarFiltrosMovimentacao = () => ({
        documento: pegaChave('#txtDocumento'),
        operacao: $('#selectEntradaSaida').val(),
        etiqueta: pegaChave('#txtTag'),
        tabelaPreco: pegaChave('#txtTabPreco'),
        colunas: pegaChave('#txtColunas'),
        colunaInicial: pegaChave('#txtColunaInicial') ?? '1',
        composicaoEtiqueta: false,
    })

    const validarFiltrosMovimentacao = (filtros) => {
        if (!filtros.documento) {
            msgErro('Nenhum documento informado, impossível continuar.')
            return
        }
        if (!filtros.operacao) {
            msgErro('Operação não informada, impossível continuar.')
            return
        }
        return true
    }

    const retornarMovimentacao = (filtros) => {
        $.LoadingOverlay('show')
        controleImpressao = 'MOV'
        requisicao('POST', `/sisplan/impressao/v1/consulta_tag?`, `TIPO_IMPRESSAO=${controleImpressao}`, JSON.stringify(filtros), 3600000).then(async (response) => {
            $('#divTabGrade').addClass('d-none')
            if (!response) {
                return
            }

            const data = await response.json()
            if (response.status != 200) {
                throw data.mensagem
            }

            if (!data.length) {
                msgErro('Nenhum registro encontrado.')
                if ($.fn.DataTable.isDataTable('#tabelaTag')) {
                    $('#tabelaTag').DataTable().destroy()
                    $('#tabelaTag').empty()
                }
                return
            }

            const columns = []

            const keys = Object.keys(data[0])
            for (let k in keys) {
                columns.push({
                    title: keys[k],
                    data: keys[k],
                })
            }

            $("#tabelaTag").DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: false,
                lengthChange: false,
                scrollX: true,
                scrollY: "300px",
                scrollCollapse: true,
                paging: false,
                Filter: false,
                Info: true,
                Order: false,
                autoWidth: true,
                columns,
                data,
            })
        }).catch((error) => {
            msgErro(error || 'Ocorreu um erro ao buscar os dados.')
            console.error(error)
        }).finally(() => {
            $.LoadingOverlay('hide')
            $('#modalBuscar').modal('hide')
        })
    }
})