$(document).ready(async function () {

  const orcamento = $(window.location.href.split('/')).get(-1);
  const parametrosComercial = await BuscaParametrosPedido();
  const usaFatorConv = parametrosComercial[12].VALOR == '3'
  let itensAlteracao = []
  const desabilitaMarkup = parametrosComercial[20].VALOR == '1'
  const permiteAlterarCons = parametrosComercial[21].VALOR != '1'
  const permiteAlterarPreco = parametrosComercial[9].VALOR == '1'

  if (desabilitaMarkup) {
    $('.divTabelaGrade').removeClass('col-lg-9 col-sm-9').addClass('col-lg-12 col-sm-12')
    $('#divIndices').addClass('d-none')
  }

  const colunasItens = [
    { title: 'Ordem', data: 'ORDEM' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Compl. Prod', data: 'COMPL_PROD' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc. Cor', data: 'DESCCOR' },
    { title: 'Tam', data: 'TAM' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Desconto', data: 'DESCONTO' },
    { title: 'Acréscimo', data: 'ACRESCIMO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Custom', data: 'CUSTOMIZACAO' },
    { title: 'ObsProd', data: 'OBS2' },
    { title: 'ObsProducao', data: 'OBS3' },
    { title: 'ObsEspec', data: 'OBSERVACAO' },
    { title: 'Faixa', data: 'FAIXA' },
    { title: 'Prototipo', data: 'PROTOTIPO' },
    { title: 'Markup', data: 'MARKUP' },
    { title: 'PRECO_ORIG', data: 'PRECO_ORIG' },
    { title: 'LINHA', data: 'LINHA' },
    { title: 'GRUPO', data: 'GRUPO' },
    { title: 'ETIQUETA', data: 'ETIQUETA' },
  ];

  const colunasCaracteristicas = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Existe', data: 'EXISTE' },
    { title: 'Id', data: 'ID' },
    { title: 'Cons. Tecido.', data: 'CONS_TECIDO' },
    { title: 'Cod. Apl.', data: 'COD_APL' },
  ];

  const colunasComposicao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc Cor', data: 'DESC_COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
    { title: 'Nome Fornecedor', data: 'NOME_FORNECEDOR' },
    { title: 'Cód. Subcaracterística', data: 'COD_OPCIONAL' },
    { title: 'Desc. Subcaracterística', data: 'DESC_OPCIONAL' },
    { title: 'Ações', data: 'ACOES' },
  ];

  const colunasFt = [
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Ordem', data: 'ORDEM' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
  ];

  const colunasGrade = [
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: '% Acresc.', data: 'PERC_ACRESC' },
    { title: 'Val Acresc.', data: 'VAL_ACRESC' },
    { title: '% Desc.', data: 'PERC_DESC' },
    { title: 'Val Desc.', data: 'VAL_DESC' },
    { title: 'Preço Líq.', data: 'PRECO_LIQ' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'PRECO_ORIG', data: 'PRECO_ORIG' },
  ];

  const colunasIndices = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Índice', data: 'INDICE' },
  ];

  const colunasAplicacoes = [
    { title: 'Característica', data: 'CARACTERISTICA' },
    { title: 'Subcaracterística', data: 'SUBCARACTERISTICA' },
    { title: 'ID', data: 'ID' },
    { title: 'Cod. Apl.', data: 'COD_APL' },
  ];

  const colunasTecidosUtilizados = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Fundo', data: 'FUNDO' },
    { title: 'Visor', data: 'VISOR' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
    { title: 'Id', data: 'ID' },
    { title: 'Cod. Apl', data: 'COD_APL' },
  ];

  let colunasConsumos

  if (usaFatorConv) {
    colunasConsumos = [
      { title: 'Código', data: 'CODIGO' },
      { title: 'Descrição', data: 'DESCRICAO' },
      { title: 'Caracteristica', data: 'COD_OPCIONAL' },
      { title: 'Desc. Caracteristica', data: 'DESC_CARACTERISTICA' },
      { title: 'Qtde', data: 'QTDE' },
      { title: 'Custo', data: 'CUSTO' },
      { title: 'Fator Conv.', data: 'DIVISOR' },
      { title: 'Valor', data: 'VALOR' },
      { title: 'Setor', data: 'SETOR' },
      { title: 'Desc Setor', data: 'DESC_SETOR' },
      { title: 'Cor', data: 'COR' },
      { title: 'Desc Cor', data: 'DESC_COR' },
      { title: 'Ações', data: 'ACOES' },
      { title: 'Tipo', data: 'TIPO' },
    ];
  } else {
    colunasConsumos = [
      { title: 'Código', data: 'CODIGO' },
      { title: 'Descrição', data: 'DESCRICAO' },
      { title: 'Caracteristica', data: 'COD_OPCIONAL' },
      { title: 'Desc. Caracteristica', data: 'DESC_CARACTERISTICA' },
      { title: 'Qtde', data: 'QTDE' },
      { title: 'Custo', data: 'CUSTO' },
      { title: 'Valor', data: 'VALOR' },
      { title: 'Setor', data: 'SETOR' },
      { title: 'Desc Setor', data: 'DESC_SETOR' },
      { title: 'Cor', data: 'COR' },
      { title: 'Desc Cor', data: 'DESC_COR' },
      { title: 'Ações', data: 'ACOES' },
      { title: 'Tipo', data: 'TIPO' },
    ];
  }

  const colunasSerigrafiaTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
  ];

  const colunasSerigrafia = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasBordadoProgramacao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Margem', data: 'MARGEM' }
  ];

  const colunasBordado = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Programação', data: 'PROGRAMACAO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Prog', data: 'QTDE_PROG' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSublimacao = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotapeTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotape = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Tam CM²', data: 'TAM_CM2' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasDuplicatas = [
    { title: 'Parcela', data: 'PARCELA' },
    { title: 'Vencimento', data: 'VENCIMENTO' },
    { title: 'Valor', data: 'VALOR' },
  ];

  const colunasItensCaracteristica = [
    { title: 'ID_CARACT', data: 'ID_CARACT' },
    { title: 'ID_CARACT_CAD', data: 'ID_CARACT_CAD' },
    { title: 'COD_PROT', data: 'COD_PROT' },
  ];

  const colunasItensSerigrafia = [
    { title: 'CODIGO', data: 'CODIGO' },
    { title: 'TIPO_ITEM', data: 'TIPO_ITEM' },
    { title: 'TIPO', data: 'TIPO' },
    { title: 'TAMANHO', data: 'TAMANHO' },
    { title: 'LOCAL', data: 'LOCAL' },
    { title: 'QTDE_CORES', data: 'QTDE_CORES' },
    { title: 'TOTAL', data: 'TOTAL' },
    { title: 'ALTURA', data: 'ALTURA' },
    { title: 'LARGURA', data: 'LARGURA' },
    { title: 'NOME', data: 'NOME' },
    { title: 'PRECO', data: 'PRECO' },
  ];

  const colunasItensBordado = [
    { title: 'CODIGO', data: 'CODIGO' },
    { title: 'TIPO_ITEM', data: 'TIPO_ITEM' },
    { title: 'PROGRAMACAO', data: 'PROGRAMACAO' },
    { title: 'TAMANHO', data: 'TAMANHO' },
    { title: 'LOCAL', data: 'LOCAL' },
    { title: 'QTDE_PROG', data: 'QTDE_PROG' },
    { title: 'TOTAL', data: 'TOTAL' },
    { title: 'ALTURA', data: 'ALTURA' },
    { title: 'LARGURA', data: 'LARGURA' },
    { title: 'NOME', data: 'NOME' },
    { title: 'PRECO', data: 'PRECO' },
  ];

  const colunasItensSublimacao = [
    { title: 'ITEM', data: 'ITEM' },
    { title: 'TIPO_ITEM', data: 'TIPO_ITEM' },
    { title: 'CODIGO', data: 'CODIGO' },
    { title: 'DESCRICAO', data: 'DESCRICAO' },
    { title: 'PRECO', data: 'PRECO' },
  ];

  const colunasItensTermotape = [
    { title: 'ITEM', data: 'ITEM' },
    { title: 'TIPO_ITEM', data: 'TIPO_ITEM' },
    { title: 'CODIGO', data: 'CODIGO' },
    { title: 'DESCRICAO', data: 'DESCRICAO' },
    { title: 'TAM_CM2', data: 'TAM_CM2' },
    { title: 'TOTAL', data: 'TOTAL' },
    { title: 'PRECO', data: 'PRECO' },
  ];

  let colunasItensConsumos
  if (usaFatorConv) {
    colunasItensConsumos = [
      { title: 'CODIGO', data: 'CODIGO' },
      { title: 'INSUMO', data: 'INSUMO' },
      { title: 'DESCRICAO', data: 'DESCRICAO' },
      { title: 'QTDE', data: 'QTDE' },
      { title: 'CUSTO', data: 'CUSTO' },
      { title: 'DIVISOR', data: 'DIVISOR' },
      { title: 'VALOR', data: 'VALOR' },
      { title: 'SETOR', data: 'SETOR' },
      { title: 'DESC_SETOR', data: 'DESC_SETOR' },
      { title: 'COR', data: 'COR' },
      { title: 'DESC_COR', data: 'DESC_COR' },
      { title: 'Caracteristica', data: 'COD_OPCIONAL' },
      { title: 'Desc. Caracteristica', data: 'DESC_CARACTERISTICA' },
      { title: 'Tipo', data: 'TIPO' },
    ];
  } else {
    colunasItensConsumos = [
      { title: 'CODIGO', data: 'CODIGO' },
      { title: 'INSUMO', data: 'INSUMO' },
      { title: 'DESCRICAO', data: 'DESCRICAO' },
      { title: 'QTDE', data: 'QTDE' },
      { title: 'CUSTO', data: 'CUSTO' },
      { title: 'VALOR', data: 'VALOR' },
      { title: 'SETOR', data: 'SETOR' },
      { title: 'DESC_SETOR', data: 'DESC_SETOR' },
      { title: 'COR', data: 'COR' },
      { title: 'DESC_COR', data: 'DESC_COR' },
      { title: 'Caracteristica', data: 'COD_OPCIONAL' },
      { title: 'Desc. Caracteristica', data: 'DESC_CARACTERISTICA' },
      { title: 'Tipo', data: 'TIPO' },
    ];
  }

  const colunasItensDTF = [
    { title: 'CODIGO', data: 'CODIGO' },
    { title: 'TIPO_ITEM', data: 'TIPO_ITEM' },
    { title: 'PROGRAMACAO', data: 'PROGRAMACAO' },
    { title: 'TAMANHO', data: 'TAMANHO' },
    { title: 'LOCAL', data: 'LOCAL' },
    { title: 'QTDE_PROG', data: 'QTDE_PROG' },
    { title: 'TOTAL', data: 'TOTAL' },
    { title: 'ALTURA', data: 'ALTURA' },
    { title: 'LARGURA', data: 'LARGURA' },
    { title: 'NOME', data: 'NOME' },
    { title: 'PRECO', data: 'PRECO' },
  ];

  const colunasDTFProgramacao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasDTFTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasDTFLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Margem', data: 'MARGEM' }
  ];

  const colunasDTF = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Programação', data: 'PROGRAMACAO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Prog', data: 'QTDE_PROG' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  let idCaracteristica = '';

  await verificaPermissoes('ORCAMENTO');
  await adicionaEmpresas();
  await setarDataAtual('dtDigitacao');
  await setarDataAtual('dtEmissao');
  adicionaDias()
  await carregaValoresPadroes();

  addPesquisaAutocompleta();
  criaMascaraCampos();
  await addBotoesAvancarVoltar();
  addValidacaoCamposObrigatorios();

  const retornaBotaoOpcoes = (data) => {
    return '<div> ' +
      '       <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '         ' + data + ' ' +
      '       </button> ' +
      '     <div class="dropdown-menu"> ' +
      '       <button type="button" class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '       <button type="button" class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      '       <button type="button" class="dropdown-item" title="Anexos" id="btnAnexos">Gestão de Documentos</button>     ' +
      '     </div>' +
      '    </div>';
  };

  criaDataTablePadrao('#tabelaDuplicatas', false, false, false, false, true, false, '193px', undefined, colunasDuplicatas, [], [1], [], [2]);
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', undefined, colunasItens, [13, 14, 15, 16, 17, 18, 19, 20, 21, 22], [], [], [], { targets: [0], funcao: (data) => retornaBotaoOpcoes(data) });
  criaDataTablePadrao('#tabelaCaracteristicas', false, false, false, false, true, false, '300px', undefined, colunasCaracteristicas, [4, 5, 6, 7]);
  criaDataTablePadrao('#tabelaComposicao', false, false, false, false, true, false, '300px', undefined, colunasComposicao);
  criaDataTablePadrao('#tabelaFt', false, false, false, false, true, false, '300px', undefined, colunasFt);
  criaDataTablePadrao('#tabelaGrade', false, false, false, false, true, true, '300px', undefined, colunasGrade, [9], [], [], [7, 8], {}, 2, null, null, null, [1, 2, 3, 4, 5, 6], [], false, false, []);
  criaDataTablePadrao('#tabelaIndices', false, false, false, false, true, true, '300px', undefined, colunasIndices);
  criaDataTablePadrao('#tabelaAplicacoes', false, false, false, false, true, false, '300px', undefined, colunasAplicacoes, [2, 3]);
  criaDataTablePadrao('#tabelaTecidosUtilizados', false, false, false, false, true, false, '300px', undefined, colunasTecidosUtilizados, [8, 9, 10, 11], [], [], [], {}, 2, null, null, null, [], [], true);
  if (usaFatorConv) {
    criaDataTablePadrao('#tabelaConsumos', false, false, false, false, true, false, '300px', undefined, colunasConsumos, [13], [], [], [7], {}, 4, null, null, null, [], [4, 5, 6, 7]);
  } else {
    criaDataTablePadrao('#tabelaConsumos', false, false, false, false, true, false, '300px', undefined, colunasConsumos, [12], [], [], [6], {}, 4, null, null, null, [], [4, 5, 6]);
  }
  criaDataTablePadrao('#tabelaSerigrafia', false, false, false, false, true, true, '400px', undefined, colunasSerigrafia);
  criaDataTablePadrao('#tabelaSerigrafiaTipo', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTipo, [0, 1, 3]);
  criaDataTablePadrao('#tabelaSerigrafiaLocal', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaLocal, [0, 2]);
  criaDataTablePadrao('#tabelaSerigrafiaTamanho', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTamanho, [0]);
  criaDataTablePadrao('#tabelaBordado', false, false, false, false, true, true, '400px', undefined, colunasBordado);
  criaDataTablePadrao('#tabelaBordadoProgramacao', false, false, false, false, true, false, '200px', undefined, colunasBordadoProgramacao, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoTamanho', false, false, false, false, true, false, '200px', undefined, colunasBordadoTamanho, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoLocal', false, false, false, false, true, false, '200px', undefined, colunasBordadoLocal, [0, 2, 3]);
  criaDataTablePadrao('#tabelaSublimacao', false, false, false, false, true, false, '400px', undefined, colunasSublimacao);
  criaDataTablePadrao('#tabelaTermotapeTipo', false, false, false, false, true, false, '200px', undefined, colunasTermotapeTipo, [2]);
  criaDataTablePadrao('#tabelaTermotape', false, false, false, false, true, false, '400px', undefined, colunasTermotape, [0]);
  criaDataTablePadrao('#tabelaDTF', false, false, false, false, true, true, '400px', undefined, colunasDTF);
  criaDataTablePadrao('#tabelaDTFProgramacao', false, false, false, false, true, false, '200px', undefined, colunasDTFProgramacao, [0, 2]);
  criaDataTablePadrao('#tabelaDTFTamanho', false, false, false, false, true, false, '200px', undefined, colunasDTFTamanho, [0, 2]);
  criaDataTablePadrao('#tabelaDTFLocal', false, false, false, false, true, false, '200px', undefined, colunasDTFLocal, [0, 2, 3]);
  // TABELAS INVISIVEIS
  criaDataTablePadrao('#tabelaItensCaracteristica', false, false, false, false, true, false, '300px', undefined, colunasItensCaracteristica);
  criaDataTablePadrao('#tabelaItensSerigrafia', false, false, false, false, true, false, '300px', undefined, colunasItensSerigrafia);
  criaDataTablePadrao('#tabelaItensBordado', false, false, false, false, true, false, '300px', undefined, colunasItensBordado);
  criaDataTablePadrao('#tabelaItensDTF', false, false, false, false, true, false, '300px', undefined, colunasItensDTF);
  criaDataTablePadrao('#tabelaItensSublimacao', false, false, false, false, true, false, '300px', undefined, colunasItensSublimacao);
  criaDataTablePadrao('#tabelaItensTermotape', false, false, false, false, true, false, '300px', undefined, colunasItensTermotape);
  criaDataTablePadrao('#tabelaItensConsumos', false, false, false, false, true, false, '300px', undefined, colunasItensConsumos);
  // TABELAS INVISIVEIS

  await carregaCustomSerigrafiaTipo(0);
  await carregaCustomSerigrafiaLocal(0);
  await carregaCustomSerigrafiaTam(0);

  await carregaCustomBordadoProg(0);
  await carregaCustomBordadoTam(0);
  await carregaCustomBordadoLocal(0);

  await carregaCustomDTFProg(0);
  await carregaCustomDTFTam(0);
  await carregaCustomDTFLocal(0);

  await carregaCustomSublimacao();
  await carregaCustomTermotape(0);

  await validaEdicao();

  $("#tabelaItens").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data.CODIGO, $('#txtNumero').val() + ' ' + data.ORDEM, 'ORCAMENTOPROT');
  });

  let alterandoComposicao = false;
  let indexComposicao = -1;
  let alterandoConsumo = false;
  let indexConsumo = -1;
  const usaPrecoCorTam = await CopiaParametro("VENDA", 5) == 1

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  $('#txtLinha, #txtGrupo, #txtEtiqueta').on('blur', async function () {
    const linha = pegaChave('#txtLinha');
    const grupo = pegaChave('#txtGrupo');
    const etiqueta = pegaChave('#txtEtiqueta');

    if ((linha != '') || (grupo != '') || (etiqueta != '')) {
      bloqueiaCamposInclusao(false, true)
    } else if ((linha == '') && (grupo == '') && (etiqueta == '')) {
      bloqueiaCamposInclusao(false, false)
    }

    if ((linha == '') || (grupo == '') || (etiqueta == '')) {
      $('#txtComplDescProd').prop('disabled', true)
      return;
    }

    $('#txtComplDescProd').prop('disabled', false)

    await buscaCaracteristica(linha, grupo, etiqueta);
    await carregaCustomSublimacao();
  });

  $('#btn-limpa-Etiqueta, #btn-limpa-Grupo, #btn-limpa-Linha').on('click', async function () {
    limpaTabelas()
    $('#txtComplDescProd').prop('disabled', true)

    const linha = pegaChave('#txtLinha');
    const grupo = pegaChave('#txtGrupo');
    const etiqueta = pegaChave('#txtEtiqueta');

    if ((linha == '') && (grupo == '') && (etiqueta == '')) {
      bloqueiaCamposInclusao(false, false)
    }
  });

  $('#btnAddSerigrafia').on('click', async function () {
    await carregaCustomSerigrafiaTipo($('#tabelaSerigrafiaTipo').DataTable().row('.selected').index());
    await carregaCustomSerigrafiaLocal($('#tabelaSerigrafiaLocal').DataTable().row('.selected').index());
    await carregaCustomSerigrafiaTam($('#tabelaSerigrafiaTamanho').DataTable().row('.selected').index());
    addSerigrafia();
  });

  $('#btnRemoveSerigrafia').on('click', function () {
    removeSerigrafia();
  });

  $('#btnAddBordado').on('click', async function () {
    await carregaCustomBordadoProg($('#tabelaBordadoProgramacao').DataTable().row('.selected').index());
    await carregaCustomBordadoTam($('#tabelaBordadoTamanho').DataTable().row('.selected').index());
    await carregaCustomBordadoLocal($('#tabelaBordadoLocal').DataTable().row('.selected').index());
    addBordado();
  });

  $('#btnRemoveBordado').on('click', function () {
    removeBordado();
  });

  $('#btnAddDTF').on('click', async function () {
    await carregaCustomDTFProg($('#tabelaDTFProgramacao').DataTable().row('.selected').index());
    await carregaCustomDTFTam($('#tabelaDTFTamanho').DataTable().row('.selected').index());
    await carregaCustomDTFLocal($('#tabelaDTFLocal').DataTable().row('.selected').index());
    addDTF();
  });

  $('#btnRemoveDTF').on('click', function () {
    removeDTF();
  });

  $('#btnAddTermotape').on('click', async function () {
    await carregaCustomTermotape($('#tabelaTermotapeTipo').DataTable().row('.selected').index());
    addTermotape();
  });

  $('#btnRemoveTermotape').on('click', function () {
    removeTermotape();
  });

  $('#btnAddComposicao').on('click', function () {
    $('#modalComposicao').modal('show');
  });

  $('#btnAddItem').on('click', function () {
    $('#modalItem').modal('show');
    bloqueiaCamposEdicao(false)
  });

  $('#btnConfirmarComposicao').on('click', function () {
    adicionaComposicao();
  });

  $('#tabelaComposicao').on('click', '#btn-excluir-composicao', async function () {
    await msgAguardaConfirmacao('Você realmente deseja excluir esse registro?', async () => {
      $.LoadingOverlay('show')
      try {
        $('#tabelaComposicao').DataTable().row($(this).parents('tr')).remove().draw(false);
      } finally {
        $.LoadingOverlay('hide')
      }
    })
  });

  $('#tabelaComposicao').on('click', '#btn-editar-composicao', async function () {
    $.LoadingOverlay('show')
    try {
      let item = $('#tabelaComposicao').DataTable().row($(this).parents('tr')).data()
      indexComposicao = $('#tabelaComposicao').DataTable().row($(this).parents('tr')).index()
      $('#modalComposicao').modal('show')
      insereValor('#txtFornecedor', item.FORNECEDOR, item.NOME_FORNECEDOR)
      insereValor('#txtMaterial', item.CODIGO, item.DESCRICAO)
      insereValor('#txtCorItem', item.COR, item.DESC_COR)
      insereValor('#txtOpcionalItem', item.COD_OPCIONAL, item.DESC_OPCIONAL)
      alterandoComposicao = true;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $("#modalItem").on('shown.bs.modal', async function () {
    ajustaTabelasModalItem();
    if ($('#dtEntrega').val() != '') {
      $('#dtEntregaItem').val($('#dtEntrega').val());
    }

    $('#tabCaracteristicas').trigger('click')
  });

  $('#tabCaracteristicas, #tabComposicao, #tabAplicacoes, #tabConsumos, #tabGrade, #tabObs, #tabFt, #tabSerigrafia, #tabBordado, #tabSublimacao, #tabTermotape, #tabDTF').on('click', async function () {
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
    if ($(this)[0].id == 'tabAplicacoes' && $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data().toArray().length <= 0) {
      let existeCorVazia = false;
      for (let i = 0; i < $('#tabelaComposicao').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaComposicao').DataTable().data().toArray()[0]

        if (item.COR == '') {
          existeCorVazia = true
          break
        }
      }

      if (existeCorVazia) {
        msgAlerta('Existem composições sem cor informada, impossível continuar!')
        setTimeout(() => { $('#tabComposicao').trigger('click') }, 200);
      } else {
        carregaAplicacoes();
      }
    }
    if ((($(this)[0].id == 'tabGrade') && (pegaValor('#txtFaixa') != '')) || ((pegaValor('#txtCodigo') != ''))) {
      if ((pegaValor('#txtLinha') != '') && (pegaValor('#txtGrupo') != '') && (pegaValor('#txtEtiqueta') != '') && (itensAlteracao.length <= 0)) {
        await explodeFaixa(pegaChave('#txtFaixa'));
      } else {
        let tabela = pegaChave('#txtTabPreco')
        if (tabela == '') {
          const pesquisaParam = {
            tabela: 'REGIAO',
            camposSelect: ['REGIAO'],
            where: [`PADRAO = 'S'`],
          }

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

          tabela = jsonStr[0].REGIAO
        }
        await explodeFaixaExpress(pegaChave('#txtFaixa'), tabela, pegaChave('#txtCodigo'));
      }
      atualizaTotaisGrade()

      if (desabilitaMarkup) {
        $('.divTabelaGrade').removeClass('col-lg-9 col-sm-9').addClass('col-lg-12 col-sm-12')
        $('#divIndices').addClass('d-none')
      }

      $('#txtMarkup').trigger('blur')
    }
  });

  $('#txtFaixa').on('blur', async function () {
    if (!$('#txtFaixa').val()) {
      return
    }
    if (!$('#txtCodigo').val()) {
      throw msgAlerta('É necessário inserir um código para explodir a grade.')
    }
    $.LoadingOverlay('show')
    try {
      if ((pegaValor('#txtLinha') != '') && (pegaValor('#txtGrupo') != '') && (pegaValor('#txtEtiqueta') != '')) {
        await explodeFaixa(pegaChave('#txtFaixa'));
      } else {
        let tabela = pegaChave('#txtTabPreco')
        if (tabela == '') {
          const pesquisaParam = {
            tabela: 'REGIAO',
            camposSelect: ['REGIAO'],
            where: [`PADRAO = 'S'`],
          }

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

          tabela = jsonStr[0].REGIAO
        }
        await explodeFaixaExpress(pegaChave('#txtFaixa'), tabela, pegaChave('#txtCodigo'));
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#tabCustomizacoes').on('click', function () {
    setTimeout(async () => {
      $('#tabSerigrafia').trigger('click')
    }, 200);
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
  });

  $('#tabBordado').on('click', function () {
    setTimeout(async () => {
      await carregaCustomBordadoProg(0);
      await carregaCustomBordadoTam(0);
      await carregaCustomBordadoLocal(0);
    }, 200);
  });

  $('#tabSerigrafia').on('click', function () {
    setTimeout(async () => {
      await carregaCustomSerigrafiaTipo(0);
      await carregaCustomSerigrafiaLocal(0);
      await carregaCustomSerigrafiaTam(0);
    }, 200);
  });

  $('#tabTermotape').on('click', function () {
    setTimeout(async () => {
      await carregaCustomTermotape(0);
    }, 200);
  });

  $('#tabDTF').on('click', function () {
    setTimeout(async () => {
      await carregaCustomDTFProg(0);
      await carregaCustomDTFTam(0);
      await carregaCustomDTFLocal(0);
    }, 200);
  });

  $('#txtCliente').on('blur', async function () {
    await buscaRepresentanteCliente();
    await buscaContatoCliente();
    await buscaTabelaCliente();
  });

  $('#txtRepresentante').on('blur', async function () {
    await buscaComissaoRepresentante();
  });

  $('#txtAgencia').on('blur', async function () {
    await buscaComissaoAgencia();
  });

  $('#rdSumDiasCorridos, #rdSumDiasUteis').on('change', function () {
    const dias = pegaValor('#txtDias');

    if (dias == '') {
      return;
    }

    if ($('#rdSumDiasCorridos').is(':checked')) {
      consideraDiasCorridos(dias)
    }

    if ($('#rdSumDiasUteis').is(':checked')) {
      consideraDiasUteis(dias)
    }
  })

  function consideraDiasCorridos(dias) {
    setarDataAtual('dtEntrega', false, parseFloat(dias));
    setarDataAtual('dtSaida', false, parseFloat(dias));
  }

  function consideraDiasUteis(dias) {
    var dataInicial = new Date();

    var data = new Date(dataInicial);

    var contadorDias = 0;
    while (contadorDias < dias) {
      data.setDate(data.getDate() + 1);
      if (data.getDay() !== 0 && data.getDay() !== 6) {
        contadorDias++;
      }
    }

    var ano = data.getFullYear();
    var mes = ("0" + (data.getMonth() + 1)).slice(-2);
    var dia = ("0" + data.getDate()).slice(-2);
    var dataFinalFormatada = ano + "-" + mes + "-" + dia;

    $("#dtEntrega").val(dataFinalFormatada);
    $("#dtSaida").val(dataFinalFormatada);
  }

  $('#tabelaCaracteristicas').on('click', 'td', async function () {
    $.LoadingOverlay('show')
    try {
      selecionarLinhaTabela('#tabelaCaracteristicas', 'checkCaracteristica', this);
      let data = $('#tabelaCaracteristicas').DataTable().row($(this).parents('tr')).data()
      let checkbox = $(this).parents('tr').find('.checkCaracteristica');
      if (checkbox.is(':checked')) {
        if (itensAlteracao.length <= 0) {
          await carregaConsumosCaracteristicas(data.COD_APL, data.CODIGO)
          await validaCaracteristicaUnica(data.COD_APL, $('#tabelaCaracteristicas').DataTable().row($(this).parents('tr')).index())
        }
      } else {
        const consumos = $('#tabelaConsumos').DataTable().data().toArray().filter(f => { return f.COD_OPCIONAL != data.CODIGO })
        $('#tabelaConsumos').DataTable().clear();
        consumos.forEach(item => {
          $('#tabelaConsumos').DataTable().row.add(item);
        })

        $('#tabelaConsumos').DataTable().draw(false);
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#tabelaTecidosUtilizados').on('click', 'td', async function () {
    $.LoadingOverlay('show')
    try {
      let item = $('#tabelaTecidosUtilizados').DataTable().row($(this).parents('tr')).data()
      let checkbox = $(this).parents('tr').find('.checkAplicacoes');
      if (checkbox.is(':checked')) {
        for (let j = 0; j < $('#tabelaAplicacoes').DataTable().data().toArray().length; j++) {
          const aplicacao = $('#tabelaAplicacoes').DataTable().data().toArray()[j]
          for (let i = 0; i < $('#tabelaComposicao').DataTable().data().toArray().length; i++) {
            const composicao = $('#tabelaComposicao').DataTable().data().toArray()[i]

            if (item.CODIGO == composicao.CODIGO) {
              item.COR = composicao.COR
              item.ID = aplicacao.ID
              item.COD_APL = aplicacao.COD_APL
            }
          }
        }
        $('#tabelaTecidosUtilizados').DataTable().row($(this).parents('tr')).data(item).draw(false);
        selecionarLinhaTabela('#tabelaTecidosUtilizados', 'checkAplicacoes', this);
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#tabelaBordadoProgramacao').on('click', 'tr', async function () {
    $('#tabelaBordadoProgramacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoTamanho').on('click', 'tr', async function () {
    $('#tabelaBordadoTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoLocal').on('click', 'tr', async function () {
    $('#tabelaBordadoLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTipo').on('click', 'tr', async function () {
    $('#tabelaSerigrafiaTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await carregaCustomSerigrafiaTam();
  });

  $('#tabelaSerigrafiaLocal').on('click', 'tr', function () {
    $('#tabelaSerigrafiaLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTamanho').on('click', 'tr', function () {
    $('#tabelaSerigrafiaTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafia').on('click', 'tr', function () {
    $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordado').on('click', 'tr', function () {
    $('#tabelaBordado > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSublimacao').on('click', 'tr', function () {
    $('#tabelaSublimacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaTermotapeTipo').on('click', 'tr', function () {
    $('#tabelaTermotapeTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaTermotape').on('click', 'tr', function () {
    $('#tabelaTermotape > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaDTFProgramacao').on('click', 'tr', async function () {
    $('#tabelaDTFProgramacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaDTFTamanho').on('click', 'tr', async function () {
    $('#tabelaDTFTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaDTFLocal').on('click', 'tr', async function () {
    $('#tabelaDTFLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaDTF').on('click', 'tr', function () {
    $('#tabelaDTF > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#txtCodigo').on('blur', async function () {

    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtCodigo');
      if (codigo == '') {
        return;
      }

      bloqueiaCamposInclusao(true, true)

      $('#txtCor').unbind('autocompleta');
      $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"] }`);
      $('#btn-Cor').off();
      $('#btn-Cor').unbind();
      $('#btn-Cor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"]}`, 'Pesquisa Cor', 'CADCOR');
      await preencheFaixa()

      if (itensAlteracao.length <= 0) {
        $('#txtCor').val('')

        const pesquisaCor = {
          tabela: "PA_ITEN",
          camposSelect: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          leftJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }],
          groupBy: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          where: [`PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'`],
        }
        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

        if (jsonStrCor && jsonStrCor.length == 1) {
          insereValor('#txtCor', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
          $('#txtCor').trigger('blur')
        }
      }


    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }

  });

  $('#txtCor').on('focusout', async function () {
    const codigo = pegaChave('#txtCodigo');
    const cor = pegaChave('#txtCor');

    if ((codigo == '') || (cor == '')) {
      return;
    }

    await carregaConsumosExpress(codigo, cor)
  });

  function bloqueiaCamposInclusao(express, bloqueia) {
    if (express && $('#txtEtiqueta').val() == '' && $('#txtGrupo').val() == '' && $('#txtLinha').val() == '') {
      $('#txtEtiqueta').val('')
      $('#txtGrupo').val('')
      $('#txtLinha').val('')

      $('.camposNormal').prop('disabled', bloqueia)
    } else {
      $('#txtCodigo').prop('disabled', bloqueia)
      $('#btn-Codigo').prop('disabled', bloqueia)
      $('#btn-limpa-Codigo').prop('disabled', bloqueia)
    }

  }

  async function validaEdicao() {
    if (orcamento == 'create') {
      insereValor('#txtNumero', await RetornaProximo('OS', 'OS', 'NUMERO', 5));
      const codrep = (await buscaValor('ACESSO_USUARIOS', 'CODREP', 'CODIGO', getCookie('cod_usuario'))).CODREP
      if (codrep) insereValor('#txtRepresentante', codrep, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: codrep })
      return;
    } else {
      await buscarOrcamento(orcamento)
    }
  }

  async function buscaRepresentanteCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      return;
    }

    if (pegaChave('#txtRepresentante') != '') {
      await buscaComissaoRepresentante();
      return;
    }

    const pesquisaParam = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.CODREP', 'REPRESEN.NOME'],
      leftJoin: [{ tabela: 'REPRESEN', condicao: `ENTIDADE.CODREP = REPRESEN.CODREP` }],
      where: [`ENTIDADE.CODCLI = '${codcli}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].CODREP != '') {
      insereValor('#txtRepresentante', jsonStr[0].CODREP, jsonStr[0].NOME);
      await buscaComissaoRepresentante();
    }
  }

  async function buscaContatoCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["ID CHAVE, NOME DESCRICAO"], "where": ["NOME <> '' AND CODCLI = '${codcli}'"] }`, [], [], []);
      $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["ID"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "ID", "NOME" ], "where": ["NOME <> '' AND CODCLI = '${codcli}'"]}`, "Pesquisa Solicitante",);
      $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });
      return;
    }

    $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["ID CHAVE, NOME DESCRICAO"], "where": ["NOME <> '' AND CODCLI = '${codcli}'"] }`, [], [], []);
    $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["ID"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "ID", "NOME" ], "where": ["NOME <> '' AND CODCLI = '${codcli}'"]}`, "Pesquisa Solicitante",);
    $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });

    const pesquisaParam = {
      tabela: 'CONTATO',
      camposSelect: ['ID', 'NOME'],
      where: [`CODCLI = '${codcli}' AND TIPO = 'Orçamento'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length > 0 && jsonStr[0].NOME != '') {
      insereValor('#txtSolicitante', jsonStr[0].ID, jsonStr[0].NOME);
    } else {
      limpaValor('#txtSolicitante');
    }
  }

  async function buscaComissaoRepresentante() {
    const codrep = pegaChave('#txtRepresentante');

    if (codrep == '') {
      $('#txtComissaoRec').prop('disabled', false);
      $('#txtComissaoFat').prop('disabled', false);
      $('#txtComissaoRec').val('0')
      $('#txtComissaoFat').val('0')
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['COMISSAO', 'COMISSAO2'],
      where: [`CODREP = '${codrep}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    $('#txtComissaoRec').prop('disabled', true);
    $('#txtComissaoFat').prop('disabled', true);
    $('#txtComissaoRec').val('0')
    $('#txtComissaoFat').val('0')

    if (jsonStr.length > 0) {
      if (jsonStr[0].COMISSAO != '') {
        insereValor('#txtComissaoFat', jsonStr[0].COMISSAO);
      }
      if (jsonStr[0].COMISSAO2 != '') {
        insereValor('#txtComissaoRec', jsonStr[0].COMISSAO2);
      }
    }
  }

  async function buscaComissaoAgencia() {
    const codrep = pegaChave('#txtAgencia');

    if (codrep == '') {
      $('#txtComissao').prop('disabled', false);
      $('#txtComissao').val('0')
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['COMISSAO'],
      where: [`CODREP = '${codrep}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    $('#txtComissao').prop('disabled', true);
    $('#txtComissao').val('0')

    if (jsonStr.length > 0) {
      if (jsonStr[0].COMISSAO != '') {
        insereValor('#txtComissao', jsonStr[0].COMISSAO);
      }
    }
  }

  async function carregaCustomSerigrafiaTam(indiceClick = 0) {
    $.LoadingOverlay('show');
    $('#tabelaSerigrafiaTamanho').DataTable().clear().draw(false);
    try {
      if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() == 0) {
        return;
      }

      const descTipo = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].DESCRICAO;
      const qtdeCores = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].QTDE_CORES;

      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['CUSTOMIZA.ID_TAMANHO', 'TAM.DESCRICAO'],
        leftJoin: [{ tabela: 'CUSTOMIZA', alias: 'TAM', condicao: `TAM.ID = CUSTOMIZA.ID_TAMANHO AND TAM.TIPO = 'SERIGTAM'` }],
        where: [`CUSTOMIZA.TIPO = 'SERIGTIPO' AND CUSTOMIZA.DESCRICAO = '${descTipo}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaTamanho').DataTable().row.add({
          CODIGO: item.ID_TAMANHO,
          DESCRICAO: item.DESCRICAO,
        }).draw(false);
      });

      if (qtdeCores > 0) {
        insereValor('#txtQtdeCores', qtdeCores);
      }

      if ($('#tabelaSerigrafiaTamanho').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaTamanho > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaCustomSerigrafiaLocal(indiceClick = 0) {
    $.LoadingOverlay('show');
    $('#tabelaSerigrafiaLocal').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM', 'ATIVO'],
        where: [`TIPO = 'SERIGLOCAL'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaLocal').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaSerigrafiaLocal').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaLocal > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide');
    }

  };

  async function carregaCustomSerigrafiaTipo(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaSerigrafiaTipo').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'QTDE_COR', 'COALESCE(VAL_TELA [SOMA] VAL_FOTO [SOMA] VAL_COR, 0) PRECO'],
        where: [`TIPO = 'SERIGTIPO'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaTipo').DataTable().row.add({
          CODIGO: item.ID,
          QTDE_CORES: item.QTDE_COR,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaTipo > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomBordadoProg(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaBordadoProgramacao').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
        where: [`TIPO = 'BORDPROG'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaBordadoProgramacao').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaBordadoProgramacao').DataTable().rows().count() > 0) {
        $($('#tabelaBordadoProgramacao > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomBordadoTam(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaBordadoTamanho').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
        where: [`TIPO = 'BORDTAM'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaBordadoTamanho').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaBordadoTamanho').DataTable().rows().count() > 0) {
        $($('#tabelaBordadoTamanho > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomBordadoLocal(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaBordadoLocal').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM'],
        where: [`TIPO = 'BORDLOCAL'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaBordadoLocal').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
          MARGEM: item.MARGEM,
        }).draw(false);
      });

      if ($('#tabelaBordadoLocal').DataTable().rows().count() > 0) {
        $($('#tabelaBordadoLocal > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomDTFProg(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaDTFProgramacao').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
        where: [`TIPO = 'DTFPROG'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaDTFProgramacao').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaDTFProgramacao').DataTable().rows().count() > 0) {
        $($('#tabelaDTFProgramacao > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomDTFTam(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaDTFTamanho').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
        where: [`TIPO = 'DTFTAM'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaDTFTamanho').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaDTFTamanho').DataTable().rows().count() > 0) {
        $($('#tabelaDTFTamanho > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomDTFLocal(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaDTFLocal').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM'],
        where: [`TIPO = 'DTFLOCAL'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaDTFLocal').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
          MARGEM: item.MARGEM,
        }).draw(false);
      });

      if ($('#tabelaDTFLocal').DataTable().rows().count() > 0) {
        $($('#tabelaDTFLocal > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };


  async function carregaCustomSublimacao() {
    $.LoadingOverlay('show')
    try {
      $('#tabelaSublimacao').DataTable().clear().draw(false);
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'VAL_UNIT', 'VAL_PROG'],
        where: [`TIPO = 'SUBLI'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (!jsonStr || jsonStr.length <= 0) return

      jsonStr.map((item, index) => {
        const valUni = parseFloat(item.VAL_UNIT) || 0
        const valProg = parseFloat(item.VAL_PROG) || 0

        const valor = valUni + valProg
        $('#tabelaSublimacao').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkSublimacao'),
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: retornaInputValor('txtPrecoSublimacao txtCamposSublimacao', index, false,
            valor,
            !permiteAlterarCons
          )
        }).draw(false);
      });

      if ($('#tabelaSublimacao').DataTable().rows().count() > 0) {
        $($('#tabelaSublimacao > tbody > tr')[0]).addClass('selected');
      }

      aplicaMascara()

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomTermotape(indiceClick = 0) {
    $('#tabelaTermotapeTipo').DataTable().clear().draw(false);
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'VAL_UNIT', 'VAL_PROG'],
      where: [`TIPO = 'TERMO'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      const valUni = parseFloat(item.VAL_UNIT) || 0
      const valProg = parseFloat(item.VAL_PROG) || 0

      const valor = valUni + valProg
      $('#tabelaTermotapeTipo').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: valor
      }).draw(false);
    });

    if ($('#tabelaTermotapeTipo').DataTable().rows().count() > 0) {
      $($('#tabelaTermotapeTipo > tbody > tr')[indiceClick]).addClass('selected');
    }
  };

  async function carregaComposicao() {
    $.LoadingOverlay('show');
    $('#tabelaComposicao').DataTable().clear().draw();
    try {
      const caracteristicas = $('#tabelaCaracteristicas').DataTable().rows(function (idx, data, node) {
        return $(node).find('input.checkCaracteristica').is(':checked');
      }).data().map(item => item.CODIGO).toArray();
      const caracteristicasFormatadas = await formataListas(caracteristicas.toString())
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacomposicao?', `ID=${idCaracteristica}&CARACTERISTICAS=${caracteristicasFormatadas}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      jsonStr.map(item => {
        $('#tabelaComposicao').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          FORNECEDOR: '',
          NOME_FORNECEDOR: '',
          COD_OPCIONAL: item.COD_OPCIONAL,
          DESC_OPCIONAL: item.DESC_OPCIONAL,
          ACOES: retornaBotaoExcluir('composicao'),
        }).draw(false);
      });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaConsumos() {
    $.LoadingOverlay('show');
    $('#tabelaConsumos').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumos?', `ID=${idCaracteristica}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      if (usaFatorConv) {
        jsonStr.map(item => {
          $('#tabelaConsumos').DataTable().row.add({
            CODIGO: item.COD_MAT,
            DESCRICAO: item.DESC_MAT,
            QTDE: item.QTDE,
            CUSTO: item.CUSTO,
            DIVISOR: item.DIVISOR,
            VALOR: item.VALOR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESC_SETOR,
            COR: item.COR,
            DESC_COR: item.DESC_COR,
            COD_OPCIONAL: '',
            DESC_CARACTERISTICA: '',
            ACOES: retornaBotaoExcluir('consumo'),
            TIPO: item.TIPO,
          }).draw(false);
        });
      } else {
        jsonStr.map(item => {
          $('#tabelaConsumos').DataTable().row.add({
            CODIGO: item.COD_MAT,
            DESCRICAO: item.DESC_MAT,
            QTDE: item.QTDE,
            CUSTO: item.CUSTO,
            VALOR: item.VALOR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESC_SETOR,
            COR: item.COR,
            DESC_COR: item.DESC_COR,
            COD_OPCIONAL: '',
            DESC_CARACTERISTICA: '',
            ACOES: retornaBotaoExcluir('consumo'),
            TIPO: item.TIPO,
          }).draw(false);
        });
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#tabelaConsumos').on('click', '#btn-excluir-consumo', async function () {
    await msgAguardaConfirmacao('Você realmente deseja excluir esse registro?', async () => {
      $.LoadingOverlay('show')
      try {
        $('#tabelaConsumos').DataTable().row($(this).parents('tr')).remove().draw(false);
      } finally {
        $.LoadingOverlay('hide')
      }
    })
  });

  $('#tabelaConsumos').on('click', '#btn-editar-consumo', async function () {
    $.LoadingOverlay('show')
    try {
      let item = $('#tabelaConsumos').DataTable().row($(this).parents('tr')).data()
      indexConsumo = $('#tabelaConsumos').DataTable().row($(this).parents('tr')).index()
      if (item.TIPO == 'M') {
        $('#rgMaterial').trigger('click')
        insereValor('#txtMaterialConsumo', item.CODIGO, item.DESCRICAO)
      } else {
        $('#rgProduto').trigger('click')
        insereValor('#txtProdutoConsumo', item.CODIGO, item.DESCRICAO)
      }
      insereValor('#txtCorConsumo', item.COR, item.DESC_COR)
      insereValor('#txtSetorConsumo', item.SETOR, item.DESC_SETOR)
      $('#modalConsumo').modal('show')
      $('#txtQtdeConsumo').val(item.QTDE)
      $('#txtCustoUniConsumo').val(item.CUSTO)
      $('#txtDivisorConsumo').val(usaFatorConv ? item.DIVISOR : 0)
      insereValor('#txtCodOpcional', item.COD_OPCIONAL, item.DESC_CARACTERISTICA)
      alterandoConsumo = true;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#modalConsumo').on('shown.bs.modal', async function () {
    $("#txtMaterialConsumo").autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`);
    $("#btnMaterialConsumo").pesquisa_serverside(["#txtMaterialConsumo"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Material");
    $("#btnAMaterialConsumo").on("click", function () { $("#txtMaterialConsumo").val(""); });

    $("#txtProdutoConsumo").autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`);
    $("#btnProdutoConsumo").pesquisa_serverside(["#txtProdutoConsumo"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Produto");
    $("#btnAProdutoConsumo").on("click", function () { $("#txtProdutoConsumo").val(""); });

    $("#txtCorConsumo").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": null }`, undefined, undefined, undefined, async () => await buscaPrecoMatCor());
    $("#btnCorConsumo").pesquisa_serverside(["#txtCorConsumo"], ["COR"], ["DESCRICAO"], `{"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}`, "Pesquisa Cor", async () => await buscaPrecoMatCor());
    $("#btnACorConsumo").on("click", function () { $("#txtCorConsumo").val(""); });

    $("#txtSetorConsumo").autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`);
    $("#btnSetorConsumo").pesquisa_serverside(["#txtSetorConsumo"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Setor");
    $("#btnASetorConsumo").on("click", function () { $("#txtSetorConsumo").val(""); });

    if ($('#txtMaterialConsumo').val() != '') {
      $('#txtMaterialConsumo').trigger('focusout')
    } else {
      $('#txtProdutoConsumo').trigger('focusout')
    }

    $('.inputConsumo').attr('disabled', alterandoConsumo && !permiteAlterarCons)
  })

  $('.rgTipoConsumo').on('click', function () {
    if ($(this).is('#rgProduto')) {
      limpaConsumos()
      $('#divMaterialConsumo').addClass('d-none');
      $('#divProdutoConsumo').removeClass('d-none');
      $('#txtProdutoConsumo').trigger('focusout');
    } else {
      limpaConsumos()
      $('#divMaterialConsumo').removeClass('d-none');
      $('#divProdutoConsumo').addClass('d-none');
      $('#txtMaterialConsumo').trigger('focusout');
    }
  })

  $('#txtMaterialConsumo').on('focusout', async function () {
    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtMaterialConsumo');
      if (codigo == '') {
        return;
      }

      $('#txtCorConsumo').off('autocompleta');
      $('#txtCorConsumo').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"] }`, undefined, undefined, undefined, async () => await buscaPrecoMatCor());
      $('#btnCorConsumo').off();
      $('#btnCorConsumo').pesquisa_array(['#txtCorConsumo'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"]}`, 'Pesquisa Cor', 'CADCOR', async () => await buscaPrecoMatCor());

      if (!alterandoConsumo) {
        $('#txtCorConsumo').val('')

        const pesquisaCor = {
          tabela: "MAT_ITEN",
          camposSelect: [
            "MAT_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          leftJoin: [{ tabela: "CADCOR", condicao: "MAT_ITEN.COR = CADCOR.COR" }],
          groupBy: [
            "MAT_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          where: [`MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S'`],
        }
        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

        if (jsonStrCor && jsonStrCor.length == 1) {
          insereValor('#txtCorConsumo', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
        }
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
      await buscaPrecoMatCor();
    }
  })

  $('#txtProdutoConsumo').on('focusout', async function () {
    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtProdutoConsumo');
      if (codigo == '') {
        return;
      }

      $('#txtCorConsumo').off('autocompleta');
      $('#txtCorConsumo').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND CADCOR.INATIVO = 'N'"] }`);
      $('#btnCorConsumo').off();
      $('#btnCorConsumo').pesquisa_array(['#txtCorConsumo'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND CADCOR.INATIVO = 'N'"]}`, 'Pesquisa Cor', 'CADCOR');

      if (!alterandoConsumo) {
        $('#txtCorConsumo').val('')

        const pesquisaCor = {
          tabela: "PA_ITEN",
          camposSelect: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          leftJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }],
          groupBy: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          where: [`PA_ITEN.CODIGO = '${codigo}'`],
        }
        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

        if (jsonStrCor && jsonStrCor.length == 1) {
          insereValor('#txtCorConsumo', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
        }
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConfirmarConsumo').on('click', function () {
    adicionaConsumo();
  });

  function adicionaConsumo() {
    const codigo = $('.rgTipoConsumo:checked').is('#rgProduto') ? pegaChave('#txtProdutoConsumo') : pegaChave('#txtMaterialConsumo');
    const descricao = $('.rgTipoConsumo:checked').is('#rgProduto') ? pegaDescricao('#txtProdutoConsumo') : pegaDescricao('#txtMaterialConsumo');
    const custo = parseFloat($('#txtCustoUniConsumo').val()) || 0
    if ((codigo == '') || (pegaValor('#txtCorConsumo') == '') ||
      parseFloat($('#txtQtdeConsumo').val()) <= 0) {
      msgAlerta('Necessário preencher todos os campos para adicionar consumo.');
      return;
    }
    const tipo = $('.rgTipoConsumo:checked').is('#rgProduto') ? 'P' : 'M';

    try {
      const divisor = parseFloat($('#txtDivisorConsumo').val()) || 0;
      let valor
      if (usaFatorConv && divisor > 0) {
        valor = (parseFloat($('#txtQtdeConsumo').val()) * (parseFloat(custo) / parseFloat(divisor))).toFixed(4)
      } else {
        valor = (parseFloat(custo) * parseFloat($('#txtQtdeConsumo').val())).toFixed(4);
      }

      let consumo

      if (usaFatorConv) {
        consumo = {
          CODIGO: codigo,
          DESCRICAO: descricao,
          QTDE: $('#txtQtdeConsumo').val(),
          CUSTO: custo,
          DIVISOR: divisor,
          VALOR: valor,
          COR: pegaChave('#txtCorConsumo'),
          DESC_COR: pegaDescricao('#txtCorConsumo'),
          SETOR: pegaChave('#txtSetorConsumo'),
          DESC_SETOR: pegaDescricao('#txtSetorConsumo'),
          COD_OPCIONAL: pegaChave('#txtCodOpcional'),
          DESC_CARACTERISTICA: pegaDescricao('#txtCodOpcional'),
          ACOES: retornaBotaoExcluir('consumo'),
          TIPO: tipo
        };
      } else {
        consumo = {
          CODIGO: codigo,
          DESCRICAO: descricao,
          QTDE: $('#txtQtdeConsumo').val(),
          CUSTO: custo,
          VALOR: valor,
          COR: pegaChave('#txtCorConsumo'),
          DESC_COR: pegaDescricao('#txtCorConsumo'),
          SETOR: pegaChave('#txtSetorConsumo'),
          DESC_SETOR: pegaDescricao('#txtSetorConsumo'),
          COD_OPCIONAL: pegaChave('#txtCodOpcional'),
          DESC_CARACTERISTICA: pegaDescricao('#txtCodOpcional'),
          ACOES: retornaBotaoExcluir('consumo'),
          TIPO: tipo
        };
      }

      if (alterandoConsumo && indexConsumo >= 0) {
        $('#tabelaConsumos').DataTable().row(indexConsumo).data(consumo).draw(false);
      } else {
        $('#tabelaConsumos').DataTable().row.add(consumo).draw(false);
      }
    } finally {
      $('#modalConsumo').modal('hide');
    }
  };

  $('#modalConsumo').on('hidden.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      limpaConsumos()
      alterandoConsumo = false;
      indexConsumo = -1;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function limpaConsumos() {
    $('#txtMaterialConsumo').val('');
    $('#txtProdutoConsumo').val('');
    $('#txtCorConsumo').val('');
    $('#txtSetorConsumo').val('');
    $('#txtQtdeConsumo').val(0);
    $('#txtCustoUniConsumo').val(0);
    $('#txtDivisorConsumo').val(0);
    $('#txtCodOpcional').val('');
  }

  $('#btnAddConsumo').on('click', function () {
    $('#modalConsumo').modal('show');
  });

  async function buscaPrecoMatCor() {
    const material = pegaChave('#txtMaterialConsumo');
    const cor = $('#txtCorConsumo').attr('data-chave');

    if (cor == '' || material == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'MAT_PRECO_COR',
      camposSelect: ['PRECO_COMPRA'],
      where: [`CODIGO = '${material}' AND COR = '${cor}'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      return;
    }

    $('#txtCustoUniConsumo').val(coalesce(jsonStr[0].PRECO_COMPRA));
  };

  async function buscaCaracteristica(sLinha, sGrupo, sEtiqueta, edicao = false) {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['CARACT.ID', 'CARACT.COD_FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA', 'CARACT.MARKUP'],
      where: [`CARACT.COD_ETQ = '${sEtiqueta}' AND CARACT.COD_GRUPO = '${sGrupo}' AND CARACT.COD_LINHA = '${sLinha}'`],
      leftJoin: [{ tabela: 'FAIXA', condicao: `FAIXA.CODIGO = CARACT.COD_FAIXA` }],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (!jsonStr || jsonStr.length == 0) {
      msgAlerta('Nenhuma característica encontrada para o grupo, etiqueta e linha informados. Favor verificar.');
      return;
    }

    idCaracteristica = jsonStr[0].ID;

    insereValor('#txtFaixa', jsonStr[0].COD_FAIXA, jsonStr[0].DESC_FAIXA);
    if (jsonStr[0].MARKUP != '') insereValor('#txtMarkup', jsonStr[0].MARKUP, { tabela: 'CAD_MARKUP', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: jsonStr[0].MARKUP });

    await carregaCaracteristicas();
    await carregaComposicao();
    if (!edicao) {
      await carregaConsumos();
    }
  };

  async function explodeFaixa(sFaixa) {
    if (pegaValor('#txtValTotal') > 0) {
      return;
    }

    $.LoadingOverlay('show');
    $('#tabelaGrade').DataTable().clear();
    try {
      const pesquisaParam = {
        tabela: 'FAIXA_ITEN',
        camposSelect: ['TAMANHO', 'POSICAO'],
        where: [`FAIXA = '${sFaixa}'`],
        orderBy: ['POSICAO'],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const precoVenda = await montaPrecoVenda();

      jsonStr.map((item, index) => {
        $('#tabelaGrade').DataTable().row.add({
          TAMANHO: item.TAMANHO,
          QTDE: retornaInputValor('txtQtdeGrade txtCamposGrade', index, true),
          PRECO: retornaInputValor('txtPrecoGrade txtCamposGrade', index, false, precoVenda),
          PERC_ACRESC: retornaInputValor('txtPercAcresGrade txtCamposGrade', index),
          VAL_ACRESC: retornaInputValor('txtValAcresGrade txtCamposGrade', index),
          PERC_DESC: retornaInputValor('txtPercDescGrade txtCamposGrade', index),
          VAL_DESC: retornaInputValor('txtValDescGrade txtCamposGrade', index),
          PRECO_LIQ: '0.00',
          TOTAL: '0.00',
          PRECO_ORIG: precoVenda,
        }).draw(false);
      });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });

      insereValor('#txtQtdeTotal', '0.00');
      insereValor('#txtValTotal', '0.00');

      aplicaMascara();

      $.LoadingOverlay('hide');
    }
  };

  async function carregaCaracteristicas() {
    $.LoadingOverlay('show');
    $('#tabelaCaracteristicas').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacaracteristicas?', `ID=${idCaracteristica}&CODIGO=${pegaChave('#txtCodigo')}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      jsonStr.map(item => {
        $('#tabelaCaracteristicas').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkCaracteristica'),
          CODIGO: item.OPCIONAL,
          DESCRICAO: item.DESC_OPCIONAL,
          VALOR: item.VALOR,
          EXISTE: item.EXISTE,
          ID: item.ID,
          CONS_TECIDO: item.CONS_TECIDO,
          COD_APL: item.COD_APL,
        }).draw(false);
      });

      $('#tabelaCaracteristicas').DataTable().rows().every(function () {
        let data = this.data()
        let index = this.index()


        if (data.EXISTE == 'S' && data.ID != null) {
          const linha = $(`#tabelaCaracteristicas tbody tr:eq(${index}) td`).first();
          linha.trigger('click');
        }
      })

      $('#tabelaCaracteristicas').DataTable().rows().every(function () {
        let data = this.data()

        if (data.ID == null) {
          $(this.node()).find('.form-check').remove()
          $(this.node()).addClass('disabledCaracteristica');
        }
      })
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function adicionaDias() {
    $('#txtDiasValidade').on('blur', function () {
      const dias = pegaValor('#txtDiasValidade');

      if (dias == '') {
        return;
      }

      setarDataAtual('dtValidade', false, parseFloat(dias));
    });

    $('#txtDias').on('blur', function () {
      const dias = pegaValor('#txtDias');

      if (dias == '') {
        return;
      }

      if ($('#rdSumDiasCorridos').is(':checked')) {
        consideraDiasCorridos(dias)
      }

      if ($('#rdSumDiasUteis').is(':checked')) {
        consideraDiasUteis(dias)
      }
    });
  }

  function removeSerigrafia() {
    $('#tabelaSerigrafia').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaSerigrafia').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafia > tbody > tr')[0]).addClass('selected');
    }
  };

  async function montaPrecoVenda(express = false) {
    let precoVenda = 0
    if (!express) {
      precoVenda = await retornaCustoFixo();
    }

    if (($('#txtCorGrade').val() == '') && ($('#tabelaComposicao').DataTable().data().toArray().length > 0)) {
      insereValor('#txtCorGrade', $('#tabelaComposicao').DataTable().data().toArray()[0].COR, $('#tabelaComposicao').DataTable().data().toArray()[0].DESC_COR)
    }

    for (let j = 0; j < $('#tabelaCaracteristicas').DataTable().rows('.selected').data().length; j++) {
      const item = $('#tabelaCaracteristicas').DataTable().rows('.selected').data()[j]

      precoVenda += item.VALOR;
      for (let i = 0; i < $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data().length; i++) {
        const aplicacao = $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data()[i]

        if (item.COD_APL == aplicacao.COD_APL && item.ID == aplicacao.ID) {
          const precoMat = await retornaPrecoMat(idCaracteristica, aplicacao.COD_APL, item.CODIGO, aplicacao.CODIGO, aplicacao.COR)
          precoVenda += parseFloat(precoMat)
        }
      }
    }

    $('#tabelaConsumos').DataTable().rows().data().map(item => {
      if (usaFatorConv && item.DIVISOR > 0) {
        precoVenda += (parseFloat(item.QTDE) * (parseFloat(item.CUSTO) / parseFloat(item.DIVISOR)));
      } else {
        precoVenda += (item.CUSTO * item.QTDE);
      }
    });

    precoVenda += retornaPrecoCustomizacoes()

    let precoMarkup = 0
    let precoIndFixo = 0

    if ($('#txtMarkup').val() != '') {
      precoMarkup = await retornaIndMarkup()
      precoIndFixo = await retornaPrecoIndFixo()
    }

    if (precoMarkup > 0) {
      precoVenda = precoVenda / (1 - (precoMarkup / 100))
    }

    precoVenda = precoVenda + precoIndFixo;

    return precoVenda.toFixed(2);
  };

  function retornaPrecoCustomizacoes() {
    let precoVenda = 0;
    $('#tabelaSerigrafia').DataTable().rows().data().map((item, index) => {
      let total = parseInt(item.TOTAL) || 0
      total = total <= 0 ? 1 : total;
      const preco = parseFloat($($('.txtPrecoSerig')[index]).val()) || 0
      precoVenda += (total * preco);
    })

    $('#tabelaBordado').DataTable().rows().data().map((item, index) => {
      let total = parseInt(item.TOTAL) || 0
      total = total <= 0 ? 1 : total;
      const preco = parseFloat($($('.txtPrecoBordado')[index]).val()) || 0
      precoVenda += (total * preco);
    })

    $('#tabelaDTF').DataTable().rows().data().map((item, index) => {
      let total = parseInt(item.TOTAL) || 0
      total = total <= 0 ? 1 : total;
      const preco = parseFloat($($('.txtPrecoDTF')[index]).val()) || 0
      precoVenda += (total * preco);
    })

    $('#tabelaSublimacao').DataTable().rows().every(function () {
      const row = $(this.node());
      const checkBox = row.find('.checkSublimacao');

      if (checkBox.is(':checked')) {
        const index = this.index();
        precoVenda += parseFloat($($('.txtPrecoSublimacao')[index]).val()) || 0;
      }
    });

    $('#tabelaTermotape').DataTable().rows().data().map((item, index) => {
      let total = parseInt(item.TOTAL) || 0
      total = total <= 0 ? 1 : total;
      const preco = parseFloat($($('.txtPrecoTermo')[index]).val()) || 0
      precoVenda += (total * preco);
    })

    return precoVenda
  }

  async function retornaIndMarkup() {
    if ($('#tabelaIndices').DataTable().data().toArray().filter(item => item.DESCRICAO != 'CUSTO_IND').length <= 0) {
      return 0
    }

    return $('#tabelaIndices').DataTable().data().toArray().reduce((acc, item) => {
      if (item.DESCRICAO != 'CUSTO_IND') {
        return acc + parseFloat(item.INDICE);
      }
      return acc;
    }, 0);
  }

  async function retornaPrecoIndFixo() {
    const pesquisaParam = {
      tabela: 'PRECO_INDICE',
      camposSelect: ['SUM(PRECO_INDICE.INDICE) INDICE'],
      where: [`MARKUP = '${pegaChave('#txtMarkup')}' AND CODIGO = '09' AND DESCRICAO = 'CUSTO_IND'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (!jsonStr) {
      return 0
    }

    return jsonStr[0].INDICE;
  }

  async function retornaPrecoMat(id, codApl, opcional, codigo, cor) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaprecomat?', `ID=${id}&COD_APL=${codApl}&OPCIONAL=${opcional}&CODIGO=${codigo}&COR=${cor}`);

      if (!response) {
        return;
      }

      const jsonPrecoMat = await response.json();

      if (response.status != 200) {
        throw new Error(jsonPrecoMat.mensagem);
      }

      if (jsonPrecoMat.length > 0) {
        let valor = (jsonPrecoMat[0].QTDE_TECIDO * jsonPrecoMat[0].PRECO)
        return valor.toFixed(2)
      } else {
        return 0;
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function retornaCustoFixo() {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['(VALOR_COST [SOMA] VALOR_LINHA [SOMA] MARGEM) CUSTO_FIXO'],
      where: [`ID = ${idCaracteristica}`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr[0].CUSTO_FIXO;
  };

  function addSerigrafia() {
    try {
      const table = $('#tabelaSerigrafia').DataTable();

      const index = table.rows().count();
      const newRow = {
        NOME: pegaValor('#txtNomeSerigrafia'),
        TIPO: $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaSerigrafiaTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_CORES: pegaValor('#txtQtdeCores'),
        TOTAL: pegaValor('#txtTotalPecasSerigrafia'),
        ALTURA: pegaValor('#txtAlturaSerigrafia'),
        LARGURA: pegaValor('#txtLarguraSerigrafia'),
        PRECO: retornaInputValor('txtPrecoSerig txtCamposSerig', index, false,
          $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().PRECO +
          $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().PRECO,
          !permiteAlterarCons
        )
      };

      table.row.add(newRow).draw(false);

      if (table.rows().count() > 0) {
        $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
        $($('#tabelaSerigrafia > tbody > tr')[table.rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeSerigrafia');
      limpaValor('#txtAlturaSerigrafia');
      limpaValor('#txtLarguraSerigrafia');
      limpaValor('#txtTotalPecasSerigrafia');
      aplicaMascara()
    }
  }

  function addTermotape() {
    try {
      const table = $('#tabelaTermotape').DataTable();

      const index = table.rows().count();
      const newRow = {
        CODIGO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().CODIGO,
        DESCRICAO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().DESCRICAO,
        TAM_CM2: pegaValor('#txtTamCm2'),
        TOTAL: pegaValor('#txtTotalPecasTermotape'),
        PRECO: retornaInputValor('txtPrecoTermo txtCamposTermo', index, false,
          $('#tabelaTermotapeTipo').DataTable().row('.selected').data().PRECO,
          !permiteAlterarCons
        ),
      }

      table.row.add(newRow).draw(false);

      if (table.rows().count() > 0) {
        $('#tabelaTermotape > tbody > tr').removeClass('selected');
        $($('#tabelaTermotape > tbody > tr')[$('#tabelaTermotape').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtTamCm2');
      limpaValor('#txtTotalPecasTermotape');
      aplicaMascara()
    }
  };

  function removeTermotape() {
    $('#tabelaTermotape').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaTermotape').DataTable().rows().count() > 0) {
      $($('#tabelaTermotape > tbody > tr')[0]).addClass('selected');
    }
  };

  function removeBordado() {
    $('#tabelaBordado').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaBordado').DataTable().rows().count() > 0) {
      $($('#tabelaBordado > tbody > tr')[0]).addClass('selected');
    }
  };


  function addBordado() {
    try {
      const table = $('#tabelaBordado').DataTable();

      const index = table.rows().count();
      const newRow = {
        NOME: pegaValor('#txtNomeBordado'),
        PROGRAMACAO: $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaBordadoTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaBordadoLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_PROG: pegaValor('#txtQtdeProg'),
        TOTAL: pegaValor('#txtTotalPecasBordado'),
        ALTURA: pegaValor('#txtAlturaBordado'),
        LARGURA: pegaValor('#txtLarguraBordado'),
        PRECO: retornaInputValor('txtPrecoBordado txtCamposBordado', index, false,
          $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoTamanho').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoLocal').DataTable().row('.selected').data().PRECO,
          !permiteAlterarCons
        )
      }

      table.row.add(newRow).draw(false);

      if (table.rows().count() > 0) {
        $('#tabelaBordado > tbody > tr').removeClass('selected');
        $($('#tabelaBordado > tbody > tr')[$('#tabelaBordado').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeBordado');
      limpaValor('#txtQtdeProg');
      limpaValor('#txtAlturaBordado');
      limpaValor('#txtLarguraBordado');
      limpaValor('#txtTotalPecasBordado');
      aplicaMascara()
    }
  };

  function removeDTF() {
    $('#tabelaDTF').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaDTF').DataTable().rows().count() > 0) {
      $($('#tabelaDTF > tbody > tr')[0]).addClass('selected');
    }
  };

  function addDTF() {
    try {
      const table = $('#tabelaDTF').DataTable();

      const index = table.rows().count();
      const newRow = {
        NOME: pegaValor('#txtNomeDTF'),
        PROGRAMACAO: $('#tabelaDTFProgramacao').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaDTFTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaDTFLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_PROG: pegaValor('#txtQtdeProgDTF'),
        TOTAL: pegaValor('#txtTotalPecasDTF'),
        ALTURA: pegaValor('#txtAlturaDTF'),
        LARGURA: pegaValor('#txtLarguraDTF'),
        PRECO: retornaInputValor('txtPrecoDTF txtCamposDTF', index, false,
          $('#tabelaDTFProgramacao').DataTable().row('.selected').data().PRECO + $('#tabelaDTFTamanho').DataTable().row('.selected').data().PRECO + $('#tabelaDTFLocal').DataTable().row('.selected').data().PRECO,
          !permiteAlterarCons
        )
      }

      table.row.add(newRow).draw(false);

      if (table.rows().count() > 0) {
        $('#tabelaDTF > tbody > tr').removeClass('selected');
        $($('#tabelaDTF > tbody > tr')[$('#tabelaDTF').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeDTF');
      limpaValor('#txtQtdeProgDTF');
      limpaValor('#txtAlturaDTF');
      limpaValor('#txtLarguraDTF');
      limpaValor('#txtTotalPecasDTF');
      aplicaMascara()
    }
  };

  function carregaAplicacoes() {
    $('#tabelaAplicacoes').DataTable().clear();
    $('#tabelaTecidosUtilizados').DataTable().clear();

    try {
      $('#tabelaCaracteristicas').DataTable().rows('.selected').data().map(item => {
        if (item.CONS_TECIDO != 'N') {
          $('#tabelaAplicacoes').DataTable().row.add({
            CARACTERISTICA: item.CODIGO,
            SUBCARACTERISTICA: item.DESCRICAO,
            COD_APL: item.COD_APL,
            ID: item.ID,
          }).draw(false);
        }
      });

      $('#tabelaComposicao').DataTable().rows().data().map(item => {
        $('#tabelaTecidosUtilizados').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkAplicacoes'),
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          ALTURA: retornaInputValor('txtAltura'),
          LARGURA: retornaInputValor('txtLargura'),
          FUNDO: retornaInputValor('txtFundo'),
          VISOR: retornaInputValor('txtVisor'),
          CONSUMO: retornaInputValor('txtConsumo'),
          COR: item.COR,
          FORNECEDOR: item.FORNECEDOR,
          ID: -1,
          COD_APL: -1,
        }).draw(false);
      });
    } finally {
      aplicaMascara();
    }
  };

  function botaoSelecionarGrid(sNomeCheck) {
    return '<div class="form-check" style="max-width: 20px">' +
      `<input type="checkbox" class="align-self-center ${sNomeCheck}" value"">` +
      '</div>';
  };

  function adicionaComposicao() {
    if ((pegaValor('#txtMaterial') == '') || (pegaValor('#txtCorItem') == '')) {
      msgAlerta('Necessário preencher todos os campos para adicionar composição.');
      return;
    }

    try {
      const composicao = {
        CODIGO: pegaChave('#txtMaterial'),
        DESCRICAO: pegaDescricao('#txtMaterial'),
        COR: pegaChave('#txtCorItem'),
        DESC_COR: pegaDescricao('#txtCorItem'),
        FORNECEDOR: pegaChave('#txtFornecedor'),
        NOME_FORNECEDOR: pegaDescricao('#txtFornecedor'),
        COD_OPCIONAL: pegaChave('#txtOpcionalItem'),
        DESC_OPCIONAL: pegaDescricao('#txtOpcionalItem'),
        ACOES: retornaBotaoExcluir('composicao'),
      };

      if (alterandoComposicao && indexComposicao >= 0) {
        $('#tabelaComposicao').DataTable().row(indexComposicao).data(composicao).draw(false);
      } else {
        $('#tabelaComposicao').DataTable().row.add(composicao).draw(false);
      }
    } finally {
      $('#modalComposicao').modal('hide');
    }
  };

  $('#modalComposicao').on('hidden.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      $('#txtMaterial').val('');
      $('#txtCorItem').val('');
      $('#txtFornecedor').val('');
      $('#txtOpcionalItem').val('');
      alterandoComposicao = false;
      indexComposicao = -1;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function retornaBotaoExcluir(classe) {
    return '<div class="divBtnOpcoes p-0"> ' +
      `     <button class="botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir-${classe}" ${classe == 'consumo' ? permiteAlterarCons ? '' : 'disabled style="opacity: 70%;"' : ''}><span class="fas fa-trash-alt" style="color:red"></span></button>  ` +
      `     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar-${classe}"><span class="fas fa-edit" style="color:blue"></span></button>     ` +
      '   </div>';
  }

  function retornaInputValor(sNomeInput, iIndex = 0, campoQtde = false, valor = 0, habilitado = true) {
    const validacao = parametrosComercial[9].VALOR == '1'
    return !campoQtde ?
      `<input type="text" 
              class="input-default focus form-control camposMascara text-right ${sNomeInput}" 
              ${(!validacao && sNomeInput.indexOf('txtPrecoGrade') != -1) || !habilitado ? 'disabled' : ''}
              data-campo="${sNomeInput}" 
              data-index="${iIndex}" 
              value="${valor}">`
      :
      `<input type="text" 
              class="input-default focus form-control camposMascaraQtde text-right ${sNomeInput}" 
              data-campo="${sNomeInput}" 
              data-index="${iIndex}" 
              value="${valor}"
              ${habilitado ? '' : 'disabled'}>`
  };

  function aplicaMascara() {
    $(".camposMascara").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".camposMascara").on('blur', function () {
      if (($(this).val() == '0.00') || ($(this).val() == '')) {
        $(this).val('0.00');
      }
    });

    $('.camposMascaraQtde').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    })

    $(".camposMascaraQtde").on('blur', function () {
      if (($(this).val() == '0') || ($(this).val() == '')) {
        $(this).val('0');
      }
    });

    $("#txtDias").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
    $("#txtDiasValidade").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function ajustaTabelasModalItem() {
    $('#tabelaCaracteristicas').DataTable().columns.adjust().draw(false);
    $('#tabelaComposicao').DataTable().columns.adjust().draw(false);
    $('#tabelaFt').DataTable().columns.adjust().draw(false);
    $('#tabelaGrade').DataTable().columns.adjust().draw(false);
    $('#tabelaIndices').DataTable().columns.adjust().draw(false);
    $('#tabelaAplicacoes').DataTable().columns.adjust().draw(false);
    $('#tabelaTecidosUtilizados').DataTable().columns.adjust().draw(false);
    $('#tabelaConsumos').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafia').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordado').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoProgramacao').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSublimacao').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotapeTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotape').DataTable().columns.adjust().draw(false);
    $('#tabelaDTF').DataTable().columns.adjust().draw(false);
    $('#tabelaDTFProgramacao').DataTable().columns.adjust().draw(false);
    $('#tabelaDTFTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaDTFLocal').DataTable().columns.adjust().draw(false);
  };

  $('#tabelaGrade').on('keyup', '.txtCamposGrade', function (e) {
    if (e.key == "Enter") {
      e.preventDefault();
      let campos = $('#tabelaGrade .txtCamposGrade');
      let index = campos.index(this);
      let proximo = campos.eq(index + 1);

      if (proximo.length) {
        proximo.trigger('focusin')
      }
    }
  });

  function calculaTotaisGrade(sCampo, iIndex) {
    const valor = parseFloat($($('.' + sCampo)[iIndex]).val());
    const qtde = parseInt($($('.txtQtdeGrade')[iIndex]).val());
    const preco = parseFloat($($('.txtPrecoGrade')[iIndex]).val());
    let perDesc = parseFloat($($('.txtPercDescGrade')[iIndex]).val());
    let desc = parseFloat($($('.txtValDescGrade')[iIndex]).val());
    let perAcresc = parseFloat($($('.txtPercAcresGrade')[iIndex]).val());
    let acres = parseFloat($($('.txtValAcresGrade')[iIndex]).val());

    switch (sCampo) {
      case 'txtQtdeGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        dados.TOTAL = (preco * valor).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        if (parseInt($($('.txtQtdeGrade')[iIndex]).val()) > 0) {
          if ((parametrosComercial[9].VALOR == '0') && !(itensAlteracao && itensAlteracao.length > 0)) {
            if ($('#txtMarkup').val() == '') {
              msgAlerta('Selecione um Markup!')
              $($('.txtQtdeGrade')[iIndex]).val('0')
              return;
            }
          }
        }

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        break;
      }
      case 'txtPrecoGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const precoOrig = parseFloat(dados.PRECO_ORIG || 0);
        const precoNovo = preco;
        const qtdeAtual = qtde;

        dados.TOTAL = (precoNovo * qtdeAtual).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        if (precoOrig > 0) {
          if (precoNovo < precoOrig) {
            const valorDesc = TruncaDecimaisNova(2, precoOrig - precoNovo);
            const percDesc = TruncaDecimaisNova(2, (valorDesc / precoOrig) * 100);

            desc = valorDesc
            perDesc = percDesc

            $($('.txtValDescGrade')[iIndex]).val(valorDesc.toFixed(2));
            $($('.txtPercDescGrade')[iIndex]).val(percDesc.toFixed(2));

            $($('.txtValAcresGrade')[iIndex]).val('0.00');
            $($('.txtPercAcresGrade')[iIndex]).val('0.00');
          } else if (precoNovo > precoOrig) {
            const valorAcres = TruncaDecimaisNova(2, precoNovo - precoOrig);
            const percAcres = TruncaDecimaisNova(2, (valorAcres / precoOrig) * 100);
            
            acres = valorAcres
            perAcresc = percAcres

            $($('.txtValAcresGrade')[iIndex]).val(valorAcres.toFixed(2));
            $($('.txtPercAcresGrade')[iIndex]).val(percAcres.toFixed(2));


            $($('.txtValDescGrade')[iIndex]).val('0.00');
            $($('.txtPercDescGrade')[iIndex]).val('0.00');
          } else {
            $($('.txtValDescGrade')[iIndex]).val('0.00');
            $($('.txtPercDescGrade')[iIndex]).val('0.00');
            $($('.txtValAcresGrade')[iIndex]).val('0.00');
            $($('.txtPercAcresGrade')[iIndex]).val('0.00');
          }
        }
        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        break;
      }
      case 'txtPercAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorAcres = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valorAcres).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValAcresGrade')[iIndex]).val(valorAcres.toFixed(2));
        acres = valorAcres
        break;
      }
      case 'txtValAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percAcres = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valor).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercAcresGrade')[iIndex]).val(percAcres.toFixed(2));
        perAcresc = percAcres
        break;
      }
      case 'txtPercDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorDesc = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valorDesc).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValDescGrade')[iIndex]).val(valorDesc.toFixed(2));
        desc = valorDesc
        break;
      }
      case 'txtValDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percDesc = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valor).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercDescGrade')[iIndex]).val(percDesc.toFixed(2));
        perDesc = percDesc
        break;
      }
    }

    $('.txtCamposGrade').off('blur');

    $('.txtCamposGrade').on('blur', function () {
      calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
    });

    aplicaMascara();

    $($('.' + sCampo)[iIndex]).val(valor.toFixed(2));
    $($('.txtQtdeGrade')[iIndex]).val(qtde.toFixed(0));
    $($('.txtPrecoGrade')[iIndex]).val(preco.toFixed(2));
    $($('.txtPercDescGrade')[iIndex]).val(isNaN(perDesc) || perDesc == Infinity ? '0.00' : perDesc.toFixed(2))
    $($('.txtValDescGrade')[iIndex]).val(isNaN(desc) || desc == Infinity ? '0.00' : desc.toFixed(2))
    $($('.txtPercAcresGrade')[iIndex]).val(isNaN(perAcresc) || perAcresc == Infinity ? '0.00' : perAcresc.toFixed(2))
    $($('.txtValAcresGrade')[iIndex]).val(isNaN(acres) || acres == Infinity ? '0.00' : acres.toFixed(2))

    atualizaTotaisGrade();
  };

  function atualizaTotaisGrade() {
    let qtdeTotal = 0;
    $('.txtQtdeGrade').each(index => { qtdeTotal += parseInt($($('.txtQtdeGrade')[index]).val()) });

    const valTotal = $("#tabelaGrade").DataTable().column(8, {}).data().sum();

    insereValor('#txtQtdeTotal', qtdeTotal.toFixed(2));
    insereValor('#txtValTotal', valTotal.toFixed(2));
  };

  $(".collapse").on("shown.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-right").removeClass("fa-angle-right").addClass("fa-angle-down");
  }).on("hidden.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-right");
  });

  $("#txtValorNota, #txtQuantidade").bind("DOMSubtreeModified", function () {
    setTimeout(() => { $(this).css("color", "red"); }, 200);
    setTimeout(() => { $(this).css("color", "inherit"); }, 2000);
  });

  $("#dropdown").trigger("change");

  function prencheArraysCustomizacao(arraySerigrafia, arrayBordado, arraySublimacao, arrayTermotape, arrayDTF) {
    const serigrafia = $('#tabelaItensSerigrafia').DataTable().data().toArray()

    if (serigrafia && serigrafia.length > 0) {
      for (let i = 0; i < serigrafia.length; i++) {
        const item = serigrafia[i];
        const obj = {
          TIPO_ITEM: item.TIPO_ITEM,
          CODIGO: item.CODIGO,
          TIPO: item.TIPO,
          TAMANHO: item.TAMANHO,
          LOCAL: item.LOCAL,
          QTDE_CORES: item.QTDE_CORES,
          TOTAL: item.TOTAL,
          ALTURA: item.ALTURA,
          LARGURA: item.LARGURA,
          NOME: item.NOME,
          PRECO: item.PRECO,
        }

        arraySerigrafia.push(obj)
      }
    }

    const bordado = $('#tabelaItensBordado').DataTable().data().toArray()

    if (bordado && bordado.length > 0) {
      for (let i = 0; i < bordado.length; i++) {
        const item = bordado[i];
        const obj = {
          TIPO_ITEM: item.TIPO_ITEM,
          CODIGO: item.CODIGO,
          PROGRAMACAO: item.PROGRAMACAO,
          TAMANHO: item.TAMANHO,
          LOCAL: item.LOCAL,
          QTDE_PROG: item.QTDE_PROG,
          TOTAL: item.TOTAL,
          ALTURA: item.ALTURA,
          LARGURA: item.LARGURA,
          NOME: item.NOME,
          PRECO: item.PRECO,
        }

        arrayBordado.push(obj)
      }
    }

    const sublimacao = $('#tabelaItensSublimacao').DataTable().data().toArray()

    if (sublimacao && sublimacao.length > 0) {
      for (let i = 0; i < sublimacao.length; i++) {
        const item = sublimacao[i];
        const obj = {
          TIPO_ITEM: item.TIPO_ITEM,
          ITEM: item.ITEM,
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }

        arraySublimacao.push(obj)
      }
    }

    const termotape = $('#tabelaItensTermotape').DataTable().data().toArray()

    if (termotape && termotape.length > 0) {
      for (let i = 0; i < termotape.length; i++) {
        const item = termotape[i];
        const obj = {
          TIPO_ITEM: item.TIPO_ITEM,
          ITEM: item.ITEM,
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          TAM_CM2: item.TAM_CM2,
          TOTAL: item.TOTAL,
          PRECO: item.PRECO,
        }

        arrayTermotape.push(obj)
      }
    }

    const DTF = $('#tabelaItensDTF').DataTable().data().toArray()

    if (DTF && DTF.length > 0) {
      for (let i = 0; i < DTF.length; i++) {
        const item = DTF[i];
        const obj = {
          TIPO_ITEM: item.TIPO_ITEM,
          CODIGO: item.CODIGO,
          PROGRAMACAO: item.PROGRAMACAO,
          TAMANHO: item.TAMANHO,
          LOCAL: item.LOCAL,
          QTDE_PROG: item.QTDE_PROG,
          TOTAL: item.TOTAL,
          ALTURA: item.ALTURA,
          LARGURA: item.LARGURA,
          NOME: item.NOME,
          PRECO: item.PRECO,
        }

        arrayDTF.push(obj)
      }
    }
  }

  function preencheArrayCaract(arrayCaracteristicas) {
    const caracteristica = $('#tabelaItensCaracteristica').DataTable().data().toArray()

    if (caracteristica && caracteristica.length > 0) {
      for (let i = 0; i < caracteristica.length; i++) {
        const item = caracteristica[i];
        const obj = {
          ID_CARACT: item.ID_CARACT,
          ID_CARACT_CAD: item.ID_CARACT_CAD,
          COD_PROT: item.COD_PROT,
        }

        if (!arrayCaracteristicas.some(item => JSON.stringify(item) == JSON.stringify(obj))) {
          arrayCaracteristicas.push(obj);
        }
      }
    }
  }


  function preencheArrayConsumos(arrayConsumos) {
    const consumos = $('#tabelaItensConsumos').DataTable().data().toArray()
    if (consumos && consumos.length > 0) {
      for (let i = 0; i < consumos.length; i++) {
        const item = consumos[i];
        const obj = {
          CODIGO: item.CODIGO,
          INSUMO: item.INSUMO,
          COR: item.COR,
          QTDE: item.QTDE,
          CUSTO: item.CUSTO,
          VALOR: item.VALOR,
          SETOR: item.SETOR,
          COD_OPCIONAL: item.COD_OPCIONAL,
          TIPO: item.TIPO
        }

        arrayConsumos.push(obj)
      }
    }
  }

  function validaDadosItens() {
    const servico = $($(".classeProduto")[0]).val();
    const qtde = $($(".classeQuantidade")[0]).val();
    const preco = $($(".classePreco")[0]).val();

    if ([servico, qtde, preco].includes('')) {
      msgAlerta('Serviço, quantidade ou preço não informados.\nFavor voltar a aba de itens e verificar.');
      return false;
    }
    return true;
  };

  $("#gravar").click(async function () {
    $(this).attr('disabled', true);

    if (!validaDadosItens()) {
      return;
    }

    $.LoadingOverlay("show");
    try {
      const arrayItens = [];
      const arrayFinanceiro = [];
      const arraySerigrafia = [];
      const arrayBordado = [];
      const arrayDTF = [];
      const arraySublimacao = [];
      const arrayTermotape = [];
      const arrayCaracteristicas = [];
      const arrayConsumos = []
      for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaItens').DataTable().data().toArray()[i]

        arrayItens.push({
          ORDEM_DIG: item.ORDEM,
          ORDEM: 1,
          CODIGO: item.PROTOTIPO != '' ? '' : item.CODIGO,
          PROTOTIPO: item.PROTOTIPO,
          DESCRICAO: item.DESCRICAO,
          QUALIDADE: '1',
          COR: item.COR,
          TAM: item.TAM,
          QTDE: item.QTDE,
          PRECO: item.PRECO,
          PRECO_LIQ: item.PRECO,
          VALOR_TOTAL: item.VALOR,
          TIPO_PROD: item.PROTOTIPO != '' ? 'N' : 'E',
          OBS2: item.OBS2,
          OBS3: item.OBS3,
          OBSERVACAO: item.OBSERVACAO,
          FAIXA: item.FAIXA,
          MARKUP1: item.MARKUP,
          PRECO_ORIG: item.PRECO_ORIG,
          COMPL_PROD: item.COMPL_PROD,
          TELA: 'ORCAMENTO',
          LINHA: item.LINHA,
          GRUPO: item.GRUPO,
          ETIQUETA: item.ETIQUETA,
          CUSTOMIZACAO: item.CUSTOMIZACAO,
          DESCONTO: item.DESCONTO,
          ACRESCIMO: item.ACRESCIMO
        });
      }

      for (let i = 0; i < $('#tabelaDuplicatas').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaDuplicatas').DataTable().data().toArray()[i]
        arrayFinanceiro.push({
          NUM_PARCELA: item.PARCELA,
          VENCTO: item.VENCIMENTO,
          VALOR_PARCELA: item.VALOR,
          QUANT_PARC: $('#txtNParcelas').val(),
          VALOR_TOTAL: parseFloat($('#txtValorFinanceiro').text().replace(/\./g, '').replace(',', '.')),
          PRZ_PRIM_PARC: $('#txtPrazoPrimeiraParc').val(),
          INTERV_PARC: $('#txtIntervaloParc').val(),
          PRZ_MEDIO: $('#txtPrazoMedioCalc').val(),
          VAL_ENT_PED: parseFloat($('#txtValorEntrada').val()),
          CONSIDERARSIMULACAO: $('#checkConsiderarSimulação').is(':checked') ? 'S' : 'N',
        });
      }

      if (arrayItens.length <= 0) {
        throw new Error('Nenhum item no orçamento!')
      }

      if (arrayFinanceiro.length <= 0) {
        throw new Error('Nenhuma parcela criada no orçamento!')
      }

      prencheArraysCustomizacao(arraySerigrafia, arrayBordado, arraySublimacao, arrayTermotape, arrayDTF);
      preencheArrayCaract(arrayCaracteristicas)
      preencheArrayConsumos(arrayConsumos)

      const classOs = {
        USUARIO: getCookie('usuario'),
        NUMERO: pegaValor('#txtNumero'),
        EMP_FAT: pegaValor('#selectEmpresa'),
        CLIENTE: pegaChave('#txtCliente'),
        PED_CLI: pegaValor('#txtPedcli'),
        DTDIGITA: pegaValor('#dtDigitacao'),
        CODREP: pegaChave('#txtRepresentante'),
        COM1: pegaValor('#txtComissaoFat'),
        COM2: pegaValor('#txtComissaoRec'),
        CODAGENCIA: pegaChave('#txtAgencia'),
        COM1_AGENCIA: pegaValor('#txtComissao'),
        PEDIDO: pegaChave('#txtPedido'),
        SOLICITANTE: pegaChave('#txtSolicitante'),
        TAB_PRE: pegaChave('#txtTabPreco'),
        BLOQ_COM: pegaValor('#selectStatusComercial'),
        DT_CADASTRO: $('#dtEmissao').val(),
        DT_VALIDADE: pegaValor('#dtValidade'),
        DIAS_ENTREGA: pegaValor('#txtDias'),
        DT_ENTREGA: $('#dtEntrega').val(),
        DT_SAIDA: $('#dtSaida').val(),
        OBSERVACAO: pegaValor('#txtObservacoes'),
        SITUACAO: $('#rdSituacaoAberto').is(':checked') ? 'A' : $('#rdSituacaoFechado').is(':checked') ? 'F' : $('#rdSituacaoEmAprov').is(':checked') ? 'E' : $('#rdSituacaoPerdido').is(':checked') ? 'P' : '',
        SOMA_DIAS_ENT: $('#rdSumDiasCorridos').is(':checked') ? 'C' : 'U',
        MOEDA: pegaChave('#txtMoeda'),
        HISTORICO: pegaChave('#txtHistorico'),
        SIT_DUP: pegaChave('#txtSituacao'),
        CLASSE_GER: pegaChave('#txtClasseGer'),
        TAB_TRANS: pegaChave('#txtTransportadora'),
        CIF: $('#rgTransportador').val(),
        NATUREZA: pegaChave('#txtNatureza'),
        ALIQUOTA: pegaValor('#txtAliquota'),
        FRETE: pegaValor('#txtValFrete'),
        PESO_BRUTO: pegaValor('#txtPesoBruto'),
        PESO_LIQ: pegaValor('#txtPesoLiquido'),
        VOLUMES: pegaValor('#txtVolumes'),
        END_ENT: pegaValor('#txtEndEntrega'),
        BAIRRO_ENT: pegaValor('#txtBairroEntrega'),
        NOME_CIDADE: pegaValor('#txtCidadeEntrega'),
        COD_UF: pegaValor('#txtEstadoEntrega'),
        NUM_ENT: pegaValor('#txtNumeroEntrega'),
        CEP: pegaValor('#txtCepEntrega'),
        MARKUP: pegaChave('#txtMarkup'),
        PGTO: pegaChave('#txtCondicao'),
        PRZ_MEDIO: pegaValor('#txtPrazoMedioCalc'),
        PER_DESC: parseFloat(pegaValor('#txtDesconto')),
        DESC_UNIFICADO: campoDesconto(parseFloat($('#txtDesconto1').val()), parseFloat($('#txtDesconto2').val()), parseFloat($('#txtDesconto3').val()), parseFloat($('#txtDesconto4').val()), parseFloat($('#txtDesconto5').val())),
        TELA: 'ORCAMENTO',
        ITENS: arrayItens,
        OS_SIMULA: arrayFinanceiro,
        SERIGRAFIA: arraySerigrafia,
        BORDADO: arrayBordado,
        SUBLIMACAO: arraySublimacao,
        TERMOTAPE: arrayTermotape,
        DTF: arrayDTF,
        CARACTERISTICAS: arrayCaracteristicas,
        CONSUMOS: arrayConsumos,
        EMP_ID: getCookie('emp_id'),
      };

      const response = await requisicao('POST', '/sisplan/os/v1/ordemservico?', '', `JSON=${encodeURIComponent(JSON.stringify(classOs))}`, 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      criaMensagemSucesso('Orçamento gravado com sucesso.', () => { window.location.href = `${BASE_URI}/orcamento`; });

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar os dados da ordem de serviço: ${error.message}`);
    } finally {
      $(this).attr('disabled', false);
      $.LoadingOverlay('hide')
    }
  });

  async function carregaValoresPadroes() {
    if (orcamento != 'create') {
      return;
    }

    const jsonStr = await buscaValoresPadroes('ORCAMENTO')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'MOEDA': {
          if (item.VALOR != '') {
            insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
          }
          break;
        }
        case 'HISTORICO': {
          if (item.VALOR != '') {
            insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'SITUACAO': {
          if (item.VALOR != '') {
            insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CLASSEGER': {
          if (item.VALOR != '') {
            insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TABPRECO': {
          if (item.VALOR != '') {
            insereValor('#txtTabPreco', item.VALOR, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'STATUS': {
          if (item.VALOR != '') {
            $('#selectStatusComercial').val(item.VALOR).trigger('change')
          }
          break;
        }
        case 'DIAS_VALIDADE': {
          if (item.VALOR != '') {
            $('#txtDiasValidade').val(item.VALOR).trigger('blur')
          }
          break;
        }
        case 'DIAS': {
          if (item.VALOR != '') {
            $('#txtDias').val(item.VALOR).trigger('blur')
          }
          break;
        }

      }
    });
  };

  function addPesquisaAutocompleta() {
    $("#txtCliente").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
    $("#btn-cliente").pesquisa_serverside(["#txtCliente"],
      ["CODCLI"], ["ENTIDADE.NOME"],
      `{
        "tabela":"ENTIDADE", 
        "camposSelect":[
          "CODCLI", 
          "ENTIDADE.NOME", 
          "FANTASIA", 
          "CNPJ", 
          "COD_UF", 
          "CIDADE.NOME" 
        ], 
        "leftJoin":[
          {"tabela": "CADCEP", "condicao": "ENTIDADE.CEP = CADCEP.CEP"},
          {"tabela": "CIDADE", "condicao": "CIDADE.CODIGO = CADCEP.CODMUN"}
        ],
        "where": ["ENTIDADE.nome <> 'CONSUMIDOR FINAL' and ENTIDADE.ativo = 'S'"]
       }`,
      "Pesquisa Cliente");
    $("#btn-limpa-cliente").on("click", function () {
      $("#txtCliente").val("")
      $("#txtCliente").trigger("blur");
    });

    $("#txtRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Representante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Representante");
    $("#btn-limpa-Representante").on("click", function () { $("#txtRepresentante").val(""); });

    $("#txtAgencia").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Agencia").pesquisa_serverside(["#txtAgencia"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Agência");
    $("#btn-limpa-Agencia").on("click", function () { $("#txtAgencia").val(""); });

    $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["ID CHAVE, NOME DESCRICAO"], "where": ["NOME <> ''"] }`, [], [], []);
    $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["ID"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "ID", "NOME" ], "where": ["NOME <> ''"]}`, "Pesquisa Solicitante",);
    $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });

    $("#txtTabPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-TabPreco").pesquisa_serverside(["#txtTabPreco"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`, "Pesquisa Tabela de Preço");
    $("#btn-limpa-TabPreco").on("click", function () { $("#txtTabPreco").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-classeGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-classeGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMoeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btnAMoeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtNatureza").autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`);
    $("#btn-natureza").pesquisa("#txtNatureza", "NATUREZA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`, "Pesquisa Natureza", "natureza");
    $("#btn-limpa-natureza").on("click", function () { $("#txtNatureza").val(""); });

    $("#txtTransportadora").autocompleta(1, `JSON={ "tabela":"tabtran", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`);
    $("#btnTransportadora").pesquisa("#txtTransportadora", "CODIGO", "NOME", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtran", "camposSelect":[ "codigo", "nome" ], "where": null}', "Pesquisa Transportadora", "tabtran");
    $("#btnATransportadora").on("click", function () { $("#txtTransportadora").val(""); });

    $("#txtCodigo").autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Codigo").pesquisa_serverside(["#txtCodigo"], ["PRODUTO.CODIGO"], ["PRODUTO.DESCRICAO"], `{"tabela": "PRODUTO",
      "camposSelect": ["PRODUTO.CODIGO",
        "PRODUTO.DESCRICAO",
        "PRODUTO.CODIGO2",
        "PRODUTO.CODCLI",
        "ENTIDADE.NOME",
        "PRODUTO.LINHA",
        "LINHA.DESCRICAO",
        "PRODUTO.GRUPO",
        "GRUPO.DESCRICAO",
        "PRODUTO.ETIQUETA",
        "ETIQUETA.DESCRICAO",
        "PRODUTO.COLECAO",
        "COLECAO.DESCRICAO",
        "PRODUTO.STATUS",
        "STATUS.DESCRICAO",
        "PRODUTO.MARCA",
        "MARCA.DESCRICAO",
        "PRODUTO.MODELO",
        "MODELO.DESCRICAO"],
      "leftJoin": [{"tabela": "ENTIDADE", "condicao": "PRODUTO.CODCLI = ENTIDADE.CODCLI"},
      {"tabela": "TABLIN", "alias": "LINHA", "condicao": "PRODUTO.LINHA = LINHA.CODIGO"},
      {"tabela": "GRUPO_PA", "alias": "GRUPO","condicao": "PRODUTO.GRUPO = GRUPO.CODIGO"},
      {"tabela": "ETQ_PROD", "alias": "ETIQUETA", "condicao": "PRODUTO.ETIQUETA = ETIQUETA.CODIGO"},
      {"tabela": "COLECAO", "condicao": "PRODUTO.COLECAO = COLECAO.CODIGO"},
      {"tabela": "SITPROD", "alias": "STATUS", "condicao": "PRODUTO.STATUS = STATUS.CODIGO"},
      {"tabela": "MARCA", "condicao": "PRODUTO.MARCA = MARCA.CODIGO"},
      {"tabela": "MODELO", "condicao": "PRODUTO.MODELO = MODELO.CODIGO"}],
      "where": ["PRODUTO.CODIGO <> ''"]}`, "Pesquisa Produto");
    $("#btn-limpa-Codigo").on("click", function () {
      $("#txtCodigo").val("");
      $('#txtCor').val('')
      bloqueiaCamposInclusao(true, false)
    });

    $("#txtCor").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Cor").pesquisa("#txtCor", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btn-limpa-Cor").on("click", function () { $("#txtCor").val(""); });

    $("#txtLinha").autocompleta(1, `JSON={ "tabela":"TABLIN", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Linha").pesquisa("#txtLinha", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Linha", "TABLIN");
    $("#btn-limpa-Linha").on("click", function () { $("#txtLinha").val(""); });

    $("#txtGrupo").autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Grupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Grupo", "GRUPO_PA");
    $("#btn-limpa-Grupo").on("click", function () { $("#txtGrupo").val(""); });

    $("#txtEtiqueta").autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Etiqueta").pesquisa("#txtEtiqueta", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Etiqueta", "ETQ_PROD");
    $("#btn-limpa-Etiqueta").on("click", function () { $("#txtEtiqueta").val(""); });

    $("#txtMarkup").autocompleta(1, `JSON={ "tabela":"CAD_MARKUP", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Markup").pesquisa("#txtMarkup", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Markup", "CAD_MARKUP");
    $("#btn-limpa-Markup").on("click", function () {
      $("#txtMarkup").val("");
      $('#txtMarkup').trigger('blur')
    });

    $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Deposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Depósito", "DEPOSITO");
    $("#btn-limpa-Deposito").on("click", function () { $("#txtDeposito").val(""); });

    $("#txtFornecedor").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
    $("#btnFornecedor").pesquisa_serverside(["#txtFornecedor"], ["CODCLI", "CNPJ"], ["NOME"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Fornecedor");
    $("#btnAFornecedor").on("click", function () { $("#txtFornecedor").val(""); });

    $("#txtMaterial").autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMaterial").pesquisa("#txtMaterial", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Material", "MATERIAL");
    $("#btnAMaterial").on("click", function () { $("#txtMaterial").val(""); });

    $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACor").on("click", function () { $("#txtCorItem").val(""); });

    $("#txtCorGrade").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCorGrade").pesquisa("#txtCorGrade", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACorGrade").on("click", function () { $("#txtCorGrade").val(""); });

    $("#txtFaixa").autocompleta(1, `JSON={ "tabela":"FAIXA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnFaixa").pesquisa("#txtFaixa", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FAIXA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Faixa", "Faixa");
    $("#btnAFaixa").on("click", function () { $("#txtFaixa").val(""); });

    $("#txtCondicao").autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":["CODCOND CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCondicao").pesquisa("#txtCondicao", "CODCOND", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND", "DESCRICAO", "ENTRADA", "PRZ_MEDIO", "NRPAR", "PRAZOINI", "NRDIA"], "where": null}', "Pesquisa Condicao", "CONDICAO");
    $("#btnLimpaCondicao").on("click", function () {
      $('.dadosFinan').prop('disabled', true)
      limpaDadosFinan()
      $("#txtCondicao").val("");
    });
  };

  function criaMascaraCampos() {
    $("#txtTamCm2, #txtLarguraBordado, #txtAlturaBordado, #txtLarguraSerigrafia, #txtAlturaSerigrafia, #txtComissaoFat, #txtComissaoRec, #txtComissao, #txtAliquota, #txtValFrete, #txtPesoBruto, #txtPesoLiquido, #txtFrete, #txtPreco, #txtLarguraDTF, #txtAlturaDTF").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#txtTotalPecasTermotape, #txtTotalPecasBordado, #txtQtdeProg, #txtTotalPecasDTF,#txtQtdeProgDTF, #txtTotalPecasSerigrafia, #txtVolumes, #txtQtdeCores").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $(".maskConsumos").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 4,
    });

    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });

    $('.maskInteiro').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $('.maskInteiro').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0');
      }
    });

    $('.blurEnter').on('keydown', function () {
      if (event.key == "Enter") {
        $(this).trigger("blur");
      }
    })
  };

  async function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      if (currentFs.prevObject[0].id == 'avancar1') {
        if (!$('#txtCliente').val()) {
          throw msgAlerta('Necessário inserir um cliente, verifique!')
        }
      }

      if (currentFs.prevObject[0].id == 'avancarFinanceiro') {
        if (!$('#txtMoeda').val()) {
          throw msgAlerta('Necessário inserir uma moeda, verifique!')
        }
        if (!$('#txtHistorico').val()) {
          throw msgAlerta('Necessário inserir um histórico, verifique!')
        }
        if (!$('#txtSituacao').val()) {
          throw msgAlerta('Necessário inserir uma situação, verifique!')
        }
        if (!$('#txtClasseGer').val()) {
          throw msgAlerta('Necessário inserir uma classe, verifique!')
        }
        if (!$('#txtCondicao').val()) {
          throw msgAlerta('Necessário infromar a condição de pagamento, verifique!')
        }
      }

      $("#progressbar li").eq($("fieldset").index(nextFs) - 2).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs) - 2).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };

  function addValidacaoCamposObrigatorios() {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCliente: {
          required: true,
        },
        txtDeposito: {
          required: true,
        },
        txtTransportadora: {
          required: true,
        },
        "txtProduto-0": {
          required: true,
        },
        "txtQuantidade-0": {
          required: true,
        },
        "txtPreco-0": {
          required: true,
        }
      },
      messages: {
        txtCliente: {
          required: "Informe um cliente válido.",
        },
        txtDeposito: {
          required: "Informe um depósito válido.",
        },
        txtTransportadora: {
          required: "Informe uma transportadora válida.",
        },
        "txtProduto-0": {
          required: "Informe um produto válido.",
        },
        "txtQuantidade-0": {
          required: "Informe uma quantidade válida.",
        },
        "txtPreco-0": {
          required: "Informe um preço válido.",
        }
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

  $('#btn-adiciona-cliente').on('click', async function () {
    $('#modal-cliente').modal('show');
    $('#txtCNPJModalCli').focus();
  })

  $('#modal-cliente').on('shown.bs.modal', async function () {
    $('#btnModalNovoCliente').trigger('click');

    $('#modal-cliente').on('shown.bs.modal', function () {
      const linkContato = $('a[data-toggle="collapse"][href="#multiCollapseContato"]');

      if (linkContato.attr('aria-expanded') === 'true') {
        linkContato.trigger('click');
      }
    });
  })

  $("#txtMaterial").on('blur', async function () {
    if ($("#txtMaterial").val() == '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"] }`);
      $("#btnCor").pesquisa("#txtCorItem",
        "COR",
        "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ 
                            "tabela":"CADCOR", 
                            "camposSelectSubSelect": ["COR", "DESCRICAO", "SUM(ESTOQUE) ESTOQUE", "SUM(SALDO) SALDO"],
                            "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO", "SUM(MAT_ITEN.QTDE) ESTOQUE", "ROUND((MAT_ITEN.QTDE - SUM(COALESCE(MAT_RESERVA.QTDE, 0) - COALESCE(MAT_RESERVA.QTDE_B, 0))),2) SALDO" ], 
                            "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}],
                            "leftjoin": [{"tabela": "MAT_RESERVA", "condicao": "MAT_RESERVA.CODIGO = MAT_ITEN.CODIGO AND MAT_RESERVA.COR = MAT_ITEN.COR AND MAT_RESERVA.QUAL = MAT_ITEN.QUALIDADE AND MAT_RESERVA.DEPOSITO = MAT_ITEN.DEPOSITO AND MAT_RESERVA.LOTE = MAT_ITEN.LOTE"}], 
                            "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], 
                            "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO, MAT_ITEN.QTDE"],
                            "groupBySubSelect": ["COR, DESCRICAO"]}`,
        "Pesquisa Cor",
        "CADCOR");
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#modalComposicao').on('shown.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      if ($("#txtMaterial").val() != '') {
        $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"] }`);
        $("#btnCor").pesquisa("#txtCorItem",
          "COR",
          "DESCRICAO",
          `/sisplan/funcoes/v1/pesquisa?JSON={ 
                              "tabela":"CADCOR", 
                              "camposSelectSubSelect": ["COR", "DESCRICAO", "SUM(ESTOQUE) ESTOQUE", "SUM(SALDO) SALDO"],
                              "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO", "SUM(MAT_ITEN.QTDE) ESTOQUE", "ROUND((MAT_ITEN.QTDE - SUM(COALESCE(MAT_RESERVA.QTDE, 0) - COALESCE(MAT_RESERVA.QTDE_B, 0))),2) SALDO" ], 
                              "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}],
                              "leftjoin": [{"tabela": "MAT_RESERVA", "condicao": "MAT_RESERVA.CODIGO = MAT_ITEN.CODIGO AND MAT_RESERVA.COR = MAT_ITEN.COR AND MAT_RESERVA.QUAL = MAT_ITEN.QUALIDADE AND MAT_RESERVA.DEPOSITO = MAT_ITEN.DEPOSITO AND MAT_RESERVA.LOTE = MAT_ITEN.LOTE"}], 
                              "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], 
                              "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO, MAT_ITEN.QTDE"],
                              "groupBySubSelect": ["COR, DESCRICAO"]}`,
          "Pesquisa Cor",
          "CADCOR");
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function limpaValoresItens() {
    limpaValor('#txtCodigo')
    limpaValor('#txtCor')
    limpaValor('#txtLinha')
    limpaValor('#txtGrupo')
    limpaValor('#txtMarkup')
    limpaValor('#txtEtiqueta')
    limpaValor('#txtDeposito')
    limpaValor('#txtFrete')
    limpaValor('#txtQtde')
    limpaValor('#txtPreco')
    limpaValor('#dtEntregaItem')
    limpaValor('#txtObsProduto')
    limpaValor('#txtObsProducao')
    limpaValor('#txtObsEspecificacoes')
    limpaValor('#txtCorGrade')
    limpaValor('#txtFaixa')
    limpaValor('#txtNomeSerigrafia')
    limpaValor('#txtQtdeCores')
    limpaValor('#txtAlturaSerigrafia')
    limpaValor('#txtLarguraSerigrafia')
    limpaValor('#txtTotalPecasSerigrafia')
    limpaValor('#txtTamCm2')
    limpaValor('#txtTotalPecasTermotape')
    limpaValor('#txtComplDescProd')
    $('#txtQtdeTotal').val(0)
    $('#txtValTotal').val(0)
    $('#txtIndiceTotal').val(0)

    limpaTabelas()
  }

  function limpaTabelas() {
    $('#tabelaCaracteristicas').DataTable().rows().clear().draw(false)
    $('#tabelaComposicao').DataTable().rows().clear().draw(false)
    $('#tabelaAplicacoes').DataTable().rows().clear().draw(false)
    $('#tabelaTecidosUtilizados').DataTable().rows().clear().draw(false)
    $('#tabelaConsumos').DataTable().rows().clear().draw(false)
    $('#tabelaSerigrafia').DataTable().rows().clear().draw(false)
    $('#tabelaBordado').DataTable().rows().clear().draw(false)
    $('#tabelaSublimacao').DataTable().rows().clear().draw(false)
    $('#tabelaTermotape').DataTable().rows().clear().draw(false)
    $('#tabelaTermotapeTipo').DataTable().rows().clear().draw(false)
    $('#tabelaGrade').DataTable().rows().clear().draw(false)
    $('#tabelaIndices').DataTable().rows().clear().draw(false)
    $('#tabelaDTF').DataTable().rows().clear().draw(false)
  }

  $('#btnDesistirInfos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      await limpaValoresItens()
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function buscarOrcamento(orcamento) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'OS',
        camposSelect: ['OS.NUMERO', 'OS.CLIENTE', 'ENTIDADE.NOME NOME_CLI', 'OS.PED_CLI', 'OS.DTDIGITA',
          'OS.CODREP', 'REPRESEN.NOME NOME_REP', 'OS.COM1', 'OS.COM2', 'OS.CODAGENCIA', 'AGENCIA.NOME NOME_AGEN',
          'OS.COM1_AGENCIA', 'OS.PEDIDO', 'OS.TERCEIRO SOLICITANTE', 'CONTATO.NOME NOME_SOL',
          'OS.TAB_PRE', 'REGIAO.DESCRICAO DESC_TABPRECO', 'OS.BLOQ_COM', 'OS.DT_CADASTRO DT_EMI', 'OS.VALIDADE',
          'OS.DT_VALIDADE', 'OS.DIAS_ENTREGA', 'OS.DT_ENTREGA', 'OS.DT_SAIDA', 'OS.OBSERVACAO', 'OS.SITUACAO', 'OS.SOMA_DIAS_ENT',
          'OS.MOEDA', 'MOEDA.DESCRICAO DESC_MOE', 'OS.HISTORICO', 'HISTCP.DESCRICAO DESC_HIST', 'OS.SIT_DUP',
          'TABSIT.DESCRICAO DESC_SIT', 'OS.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'OS.TAB_TRANS',
          'TABTRAN.NOME NOME_TRANSP', 'OS.CIF, OS.NATUREZA', 'NATUREZA.DESCRICAO DESC_NATUREZA', 'NATUREZA.ALIQUOTA',
          'OS.FRETE', 'OS.PESO_BRUTO', 'OS.PESO_LIQ', 'OS.VOLUMES', 'ENTIDADE.END_ENT', 'ENTIDADE.BAIRRO_ENT',
          'CIDADE.NOME NOME_CIDADE', 'CIDADE.COD_UF', 'ENTIDADE.NUM_ENT', 'ENTIDADE.CEP', 'OS.MARKUP',
          'OS.PGTO', 'OS.PER_DESC'],
        leftJoin: [{ tabela: "ENTIDADE", alias: "ENTIDADE", condicao: "ENTIDADE.CODCLI = OS.CLIENTE" },
        { tabela: "REPRESEN", alias: "REPRESEN", condicao: "REPRESEN.CODREP = OS.CODREP" },
        { tabela: "REPRESEN", alias: "AGENCIA", condicao: "AGENCIA.CODREP = OS.CODAGENCIA" },
        { tabela: "CONTATO", alias: "CONTATO", condicao: "CONTATO.NUMERO = OS.TERCEIRO " },
        { tabela: "REGIAO", alias: "REGIAO", condicao: "REGIAO.REGIAO = OS.TAB_PRE " },
        { tabela: "MOEDA", alias: "MOEDA", condicao: "MOEDA.CODMOE = OS.MOEDA" },
        { tabela: "HISTCP", alias: "HISTCP", condicao: "HISTCP.HISTORICO = OS.HISTORICO " },
        { tabela: "TABSIT", alias: "TABSIT", condicao: "TABSIT.CODIGO = OS.SIT_DUP " },
        { tabela: "CLASSE_GER", alias: "CLASSE_GER", condicao: "CLASSE_GER.CODIGO = OS.CLASSE_GER " },
        { tabela: "TABTRAN", alias: "TABTRAN", condicao: "TABTRAN.CODIGO = OS.TAB_TRANS" },
        { tabela: "NATUREZA", alias: "NATUREZA", condicao: "NATUREZA.NATUREZA = OS.NATUREZA " },
        { tabela: "CADCEP", alias: "CADCEP", condicao: "ENTIDADE.CEP = CADCEP.CEP " },
        { tabela: "CI", alias: "CIDADE", condicao: "CIDADE.CODIGO = CADCEP.CODMUN" }],
        where: [`OS.NUMERO = '${orcamento}'`],
        limit: 1
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      const os = jsonStr[0]

      //PREENCHE OS CAMPOS DO ORCAMENTO
      $('#txtNumero').val(orcamento)
      insereValor('#txtCliente', os.CLIENTE, os.NOME_CLI)
      $('#txtPedcli').val(os.PED_CLI)
      $('#dtDigitacao').val(os.DTDIGITA)
      insereValor('#txtRepresentante', os.CODREP, os.NOME_REP)
      $('#txtComissaoFat').val(os.COM1)
      $('#txtComissaoRec').val(os.COM2)
      insereValor('#txtAgencia', os.CODAGENCIA, os.NOME_AGEN)
      $('#txtComissao').val(os.COM1_AGENCIA)
      $('#txtPedido').val(os.PEDIDO)
      insereValor('#txtSolicitante', os.SOLICITANTE, os.NOME_SOL)
      insereValor('#txtTabPreco', os.TAB_PRE, os.DESC_TABPRECO)
      $('#selectStatusComercial').val(os.BLOQ_COM)
      $('#dtEmissao').val(os.DT_EMI)
      $('#txtDiasValidade').val(os.VALIDADE)
      $('#dtValidade').val(os.DT_VALIDADE)
      $('#txtDias').val(os.DIAS_ENTREGA)
      $('#dtEntrega').val(os.DT_ENTREGA)
      $('#dtSaida').val(os.DT_SAIDA)
      $('#txtObservacoes').val(os.OBSERVACAO)
      switch (os.SITUACAO) {
        case 'A': {
          $('#rdSituacaoAberto').prop('checked', true)
          break
        }
        case 'F': {
          $('#rdSituacaoFechado').prop('checked', true)
          break
        }
        case 'E': {
          $('#rdSituacaoEmAprov').prop('checked', true)
          break
        }
        case 'P': {
          $('#rdSituacaoPerdido').prop('checked', true)
          break
        }
        default: break
      }
      $('#rdSumDiasCorridos').prop('checked', os.SOMA_DIAS_ENT == 'C')
      $('#rdSumDiasUteis').prop('checked', os.SOMA_DIAS_ENT != 'C')
      //ABA FINANCEIRO
      insereValor('#txtMoeda', os.MOEDA, os.DESC_MOE)
      insereValor('#txtHistorico', os.HISTORICO, os.DESC_HIST)
      insereValor('#txtHistorico', os.HISTORICO, os.DESC_HIST)
      insereValor('#txtSituacao', os.SIT_DUP, os.DESC_SIT)
      insereValor('#txtClasseGer', os.CLASSE_GER, os.DESC_CLASSE)
      insereValor('#txtCondicao', os.PGTO, { tabela: 'CONDICAO', campoBusca: 'DESCRICAO', campoWhere: 'CODCOND', valorWhere: os.PGTO })
      $('#txtDesconto').val(os.PER_DESC)
      //ABA TRANSPORTE
      insereValor('#txtTransportadora', os.TAB_TRANS, os.NOME_TRANSP)
      $('#rgTransportador').val(os.CIF)
      insereValor('#txtNatureza', os.NATUREZA, os.DESC_NATUREZA)
      $('#txtAliquota').val(os.ALIQUOTA)
      $('#txtValFrete').val(os.FRETE)
      $('#txtPesoBruto').val(os.PESO_BRUTO)
      $('#txtPesoLiquido').val(os.PESO_LIQ)
      $('#txtVolumes').val(os.VOLUMES)
      $('#txtEndEntrega').val(os.END_ENT)
      $('#txtBairroEntrega').val(os.BAIRRO_ENT)
      $('#txtCidadeEntrega').val(os.NOME_CIDADE)
      $('#txtEstadoEntrega').val(os.COD_UF)
      $('#txtNumeroEntrega').val(os.NUM_ENT)
      $('#txtCepEntrega').val(os.CEP)

      await buscaItens(orcamento, os)
      await buscaFinanceiro(orcamento)
      await buscaCustomizacoes(orcamento)
      await buscaConsumos(orcamento)
      calculaTotais()

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function buscaItens(orcamento, os) {
    const pesquisaParam = {
      tabela: 'OS_ITEN',
      camposSelect: ['OS_ITEN.ORDEM_DIG', 'OS_ITEN.CODIGO', 'OS_ITEN.TIPO_PROD',
        'PRODUTO.DESCRICAO DESCPRO', 'PROTOTIPO.DESCRICAO DESCPROT',
        'OS_ITEN.COR', 'CADCOR.DESCRICAO DESCCOR',
        'OS_ITEN.TAM', 'OS_ITEN.QTDE', 'OS_ITEN.PRECO', 'OS_ITEN.FAIXA', 'OS_ITEN.PROTOTIPO',
        'OS_ITEN.VALOR_TOTAL VALOR', 'OS_ITEN.CUSTOMIZACAO', 'OS_ITEN.OBS_APROV', 'OS_ITEN.OBS2', 'OS_ITEN.OBS3', 'OS_ITEN.OBSERVACAO',
        'OS_ITEN.MARKUP1', 'OS_ITEN.PRECO_ORIG', 'OS_ITEN.COMPL_PROD',
        'PROTOTIPO.LINHA LINHAPROT', 'PROTOTIPO.GRUPO GRUPOPROT', 'PROTOTIPO.ETIQUETA ETIQUETAPROT',
        'PRODUTO.LINHA', 'PRODUTO.GRUPO', 'PRODUTO.ETIQUETA', 'OS_ITEN.DESCONTO', 'OS_ITEN.ACRESCIMO'],
      leftJoin: [{ tabela: "CADCOR", condicao: "CADCOR.COR = OS_ITEN.COR" },
      { tabela: "PRODUTO", condicao: "OS_ITEN.CODIGO = PRODUTO.CODIGO AND PRODUTO.CODIGO <> ''" },
      { tabela: "PRODUTO", alias: "PROTOTIPO", condicao: "OS_ITEN.PROTOTIPO = PROTOTIPO.PROTOTIPO AND OS_ITEN.PROTOTIPO IS NOT NULL AND OS_ITEN.PROTOTIPO <> ''" }
      ],
      where: [`OS_ITEN.NUMERO = '${orcamento}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    const codigos = []
    insereValor('#txtMarkup', os.MARKUP, { tabela: 'CAD_MARKUP', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: os.MARKUP })
    jsonStr.map(item => {
      $('#tabelaItens').DataTable().row.add({
        ORDEM: item.ORDEM_DIG,
        CODIGO: item.CODIGO == '' ? item.PROTOTIPO : item.CODIGO,
        DESCRICAO: item.DESCPRO == '' ? item.DESCPROT : item.DESCPRO,
        COR: item.COR,
        DESCCOR: item.DESCCOR,
        TAM: item.TAM,
        QTDE: item.QTDE,
        PRECO: item.PRECO,
        DESCONTO: item.DESCONTO,
        ACRESCIMO: item.ACRESCIMO,
        VALOR: item.VALOR,
        CUSTOMIZACAO: item.CUSTOMIZACAO,
        OBS2: item.OBS2,
        OBS3: item.OBS3,
        OBSERVACAO: item.OBSERVACAO,
        FAIXA: item.FAIXA,
        PROTOTIPO: item.PROTOTIPO,
        MARKUP: item.MARKUP1,
        PRECO_ORIG: parseFloat(item.PRECO_ORIG) <= 0 ? item.PRECO : item.PRECO_ORIG,
        COMPL_PROD: item.COMPL_PROD,
        LINHA: item.CODIGO == '' ? item.LINHAPROT : item.LINHA,
        GRUPO: item.CODIGO == '' ? item.GRUPOPROT : item.GRUPO,
        ETIQUETA: item.CODIGO == '' ? item.ETIQUETAPROT : item.ETIQUETA,
      }).draw(false);

      codigos.push(item.PROTOTIPO)
    });

    let codigosUnicos = codigos.reduce((acc, item) => {
      if (!acc.includes(item)) {
        acc.push(item);
      }
      return acc;
    }, []);

    codigosUnicos = await formataListas(codigosUnicos.toString())
    await buscarCaracteristicas(codigosUnicos)
  }

  async function buscaFinanceiro(orcamento) {
    const pesquisaParam = {
      tabela: 'OS_SIMULA',
      camposSelect: ['NUM_PARCELA', 'VENCTO', 'VALOR_PARCELA', 'CONSIDERAR', 'QUANT_PARC', 'PRZ_PRIM_PARC', 'INTERV_PARC', 'PRZ_MEDIO'],
      where: [`NUMERO = '${orcamento}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaDuplicatas').DataTable().row.add({
        PARCELA: item.NUM_PARCELA,
        VENCIMENTO: item.VENCTO,
        VALOR: item.VALOR_PARCELA
      }).draw(false);
    });

    if (jsonStr.length > 0) {
      $('#txtNParcelas').val(jsonStr[0].QUANT_PARC)
      $('#txtPrazoPrimeiraParc').val(jsonStr[0].PRZ_PRIM_PARC)
      $('#txtIntervaloParc').val(jsonStr[0].INTERV_PARC)
      $('#txtPrazoMedioCalc').val(jsonStr[0].PRZ_MEDIO)

      $('#checkConsiderarSimulação').prop('checked', jsonStr[0].CONSIDERAR != 'N');
    }

    $('.dadosFinan').prop('disabled', false)

    const pesquisaParamCond = {
      tabela: 'CONDICAO',
      camposSelect: ['CONDICAO.ENTRADA', 'CONDICAO.PRZ_MEDIO', 'CONDICAO.NRPAR', 'CONDICAO.PRAZOINI', 'CONDICAO.NRDIA', 'COND_PERC.DESCONTO DESCMAX'],
      leftJoin: [{ tabela: 'COND_PERC', condicao: 'COND_PERC.CODIGO = CONDICAO.COND_PERC' }],
      where: [`CONDICAO.CODCOND = '${pegaChave('#txtCondicao')}'`]
    }

    const jsonStrCond = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParamCond));

    if (jsonStrCond.length > 0) {
      $('#txtPercEntrada').val(jsonStrCond[0].ENTRADA)
      $('#txtPrzMedio').val(jsonStrCond[0].PRZ_MEDIO)
      $('#txtMaxParcelas').val(jsonStrCond[0].NRPAR)
      $('#txtPrzMaxPrimeira').val(jsonStrCond[0].PRAZOINI)
      $('#txtIntervaloParcelas').val(jsonStrCond[0].NRDIA)
    }
  }

  async function buscaCustomizacoes(orcamento) {
    const pesquisaParam = {
      tabela: 'OS_CUSTOMIZA',
      camposSelect: ['OS_CUSTOMIZA.TIPO', 'OS_CUSTOMIZA.ID_TIPO', 'OS_CUSTOMIZA.ID_PROG', 'OS_CUSTOMIZA.ID_TAMANHO', 'OS_CUSTOMIZA.ID_LOCAL',
        'OS_CUSTOMIZA.COD_PROD', 'OS_CUSTOMIZA.COD_PROT', 'OS_CUSTOMIZA.TAM_CM', 'OS_CUSTOMIZA.PRECO', 'OS_CUSTOMIZA.TOTAL',
        'OS_CUSTOMIZA.QTDE_CORES', 'OS_CUSTOMIZA.ALTURA', 'OS_CUSTOMIZA.LARGURA', 'OS_CUSTOMIZA.NOME',
        'TIPO.DESCRICAO DESCTIPO', 'PROG.DESCRICAO DESCPROG', 'TAM.DESCRICAO DESCTAM', 'LOCAL.DESCRICAO DESCLOCAL'
      ],
      leftJoin: [{ tabela: "CUSTOMIZA", alias: "TIPO", condicao: "OS_CUSTOMIZA.ID_TIPO = TIPO.ID" },
      { tabela: "CUSTOMIZA", alias: "PROG", condicao: "OS_CUSTOMIZA.ID_PROG = PROG.ID" },
      { tabela: "CUSTOMIZA", alias: "TAM", condicao: "OS_CUSTOMIZA.ID_TAMANHO = TAM.ID" },
      { tabela: "CUSTOMIZA", alias: "LOCAL", condicao: "OS_CUSTOMIZA.ID_LOCAL = LOCAL.ID" }
      ],
      where: [`OS_CUSTOMIZA.NUMERO = '${orcamento}'`],
      orderBy: ['OS_CUSTOMIZA.COD_PROT', 'OS_CUSTOMIZA.COD_PROD']
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr) {
      jsonStr.map(item => {
        switch (item.TIPO) {
          case 'SERIG':
            $('#tabelaItensSerigrafia').DataTable().row.add({
              CODIGO: item.COD_PROD == '' ? item.COD_PROT : item.COD_PROD,
              TIPO_ITEM: item.COD_PROD == '' ? 'N' : 'E',
              TIPO: item.DESCTIPO,
              TAMANHO: item.DESCTAM,
              LOCAL: item.DESCLOCAL,
              QTDE_CORES: item.QTDE_CORES,
              TOTAL: item.TOTAL,
              ALTURA: item.ALTURA,
              LARGURA: item.LARGURA,
              NOME: item.NOME,
              PRECO: item.PRECO
            }).draw(false);
            break;
          case 'BORD':
            $('#tabelaItensBordado').DataTable().row.add({
              CODIGO: item.COD_PROD == '' ? item.COD_PROT : item.COD_PROD,
              TIPO_ITEM: item.COD_PROD == '' ? 'N' : 'E',
              PROGRAMACAO: item.DESCPROG,
              TAMANHO: item.DESCTAM,
              LOCAL: item.DESCLOCAL,
              QTDE_PROG: item.QTDE_CORES,
              TOTAL: item.TOTAL,
              ALTURA: item.ALTURA,
              LARGURA: item.LARGURA,
              NOME: item.NOME,
              PRECO: item.PRECO
            }).draw(false);
            break;
          case 'SUBLI':
            $('#tabelaItensSublimacao').DataTable().row.add({
              ITEM: item.COD_PROD == '' ? item.COD_PROT : item.COD_PROD,
              TIPO_ITEM: item.COD_PROD == '' ? 'N' : 'E',
              CODIGO: item.ID_TIPO,
              DESCRICAO: item.DESCTIPO,
              PRECO: item.PRECO
            }).draw(false);
            break;
          case 'TERMO':
            $('#tabelaItensTermotape').DataTable().row.add({
              ITEM: item.COD_PROD == '' ? item.COD_PROT : item.COD_PROD,
              TIPO_ITEM: item.COD_PROD == '' ? 'N' : 'E',
              CODIGO: item.ID_TIPO,
              DESCRICAO: item.DESCTIPO,
              TOTAL: item.TOTAL,
              TAM_CM2: item.TAM_CM,
              PRECO: item.PRECO
            }).draw(false);
            break;
          case 'DTF':
            $('#tabelaItensDTF').DataTable().row.add({
              CODIGO: item.COD_PROD == '' ? item.COD_PROT : item.COD_PROD,
              TIPO_ITEM: item.COD_PROD == '' ? 'N' : 'E',
              PROGRAMACAO: item.DESCPROG,
              TAMANHO: item.DESCTAM,
              LOCAL: item.DESCLOCAL,
              QTDE_PROG: item.QTDE_CORES,
              TOTAL: item.TOTAL,
              ALTURA: item.ALTURA,
              LARGURA: item.LARGURA,
              NOME: item.NOME,
              PRECO: item.PRECO
            }).draw(false);
            break

          default:
            break;
        }
      });
    }
  }

  async function buscaConsumos(orcamento) {
    const pesquisaParam = {
      tabela: 'OS_CONSUMOS',
      camposSelect: ['OS_CONSUMOS.PRODUTO', 'OS_CONSUMOS.CODIGO', 'OS_CONSUMOS.QTDE', 'OS_CONSUMOS.COR', 'OS_CONSUMOS.SETOR',
        'CADCOR.DESCRICAO DESCCOR', 'CADFLUXO.DESCRICAO DESCSETOR', 'MATERIAL.DESCRICAO DESCMAT', 'PRODUTO.DESCRICAO DESCPROD', 'OS_CONSUMOS.CUSTO', 'OS_CONSUMOS.VALOR',
        'OS_CONSUMOS.CARACTERISTICA', 'CARACTERISTICA.DESCRICAO DESCCARACTERISTICA', 'OS_CONSUMOS.TIPO', 'PRODUTO.DIVISOR DIVISORPROD', 'MATERIAL.DIVISOR'],
      leftJoin: [{ tabela: "CADCOR", alias: "CADCOR", condicao: "CADCOR.COR = OS_CONSUMOS.COR" },
      { tabela: "CADFLUXO", alias: "CADFLUXO", condicao: "CADFLUXO.CODIGO = OS_CONSUMOS.SETOR" },
      { tabela: "MATERIAL", alias: "MATERIAL", condicao: "OS_CONSUMOS.CODIGO = MATERIAL.CODIGO" },
      { tabela: "PRODUTO", alias: "PRODUTO", condicao: "OS_CONSUMOS.CODIGO = PRODUTO.CODIGO" },
      { tabela: "CARACTERISTICA", alias: "CARACTERISTICA", condicao: "OS_CONSUMOS.CARACTERISTICA = CARACTERISTICA.CODIGO" }
      ],
      where: [`OS_CONSUMOS.NUMERO = '${orcamento}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr) {
      if (usaFatorConv) {
        jsonStr.map(item => {
          $('#tabelaItensConsumos').DataTable().row.add({
            CODIGO: item.PRODUTO,
            INSUMO: item.CODIGO,
            DESCRICAO: item.TIPO == 'P' ? item.DESCPROD : item.DESCMAT,
            QTDE: item.QTDE,
            CUSTO: item.CUSTO,
            DIVISOR: item.TIPO == 'P' ? item.DIVISORPROD : item.DIVISOR,
            VALOR: item.VALOR,
            COR: item.COR,
            DESC_COR: item.DESCCOR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESCSETOR,
            COD_OPCIONAL: item.CARACTERISTICA,
            DESC_CARACTERISTICA: item.DESCCARACTERISTICA,
            TIPO: item.TIPO
          }).draw(false);
        });
      } else {
        jsonStr.map(item => {
          $('#tabelaItensConsumos').DataTable().row.add({
            CODIGO: item.PRODUTO,
            INSUMO: item.CODIGO,
            DESCRICAO: item.TIPO == 'P' ? item.DESCPROD : item.DESCMAT,
            QTDE: item.QTDE,
            CUSTO: item.CUSTO,
            VALOR: item.VALOR,
            COR: item.COR,
            DESC_COR: item.DESCCOR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESCSETOR,
            COD_OPCIONAL: item.CARACTERISTICA,
            DESC_CARACTERISTICA: item.DESCCARACTERISTICA,
            TIPO: item.TIPO
          }).draw(false);
        });
      }
    }
  }

  async function buscarCaracteristicas(prototipo) {
    if (prototipo == '') {
      return
    }
    const pesquisaParam = {
      tabela: 'OS_CARACT_CAD',
      camposSelect: ['DISTINCT ID_CARACT', 'ID_CARACT_CAD', 'COD_PROT'],
      where: [`COD_PROT in (${prototipo})`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr) {
      jsonStr.map(item => {
        $('#tabelaItensCaracteristica').DataTable().row.add({
          ID_CARACT: item.ID_CARACT,
          ID_CARACT_CAD: item.ID_CARACT_CAD,
          COD_PROT: item.COD_PROT
        }).draw(false);
      });
    }
  }

  async function buscaTabelaCliente() {
    if (pegaChave('#txtCliente') == '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'ENTIDADE',
        camposSelect: ['ENTIDADE.TABELA', 'REGIAO.DESCRICAO'],
        leftJoin: [{ tabela: "REGIAO", condicao: "REGIAO.REGIAO = ENTIDADE.TABELA" }],
        where: [`ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        insereValor('#txtTabPreco', jsonStr[0].TABELA, jsonStr[0].DESCRICAO)
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function carregaConsumosExpress(sCodigo, sCor) {
    $.LoadingOverlay('show');
    $('#tabelaConsumos').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumosexpress?', `CODIGO=${sCodigo}&COR=${sCor}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      if (usaFatorConv) {
        jsonStr.map(item => {
          $('#tabelaConsumos').DataTable().row.add({
            CODIGO: item.INSUMO,
            DESCRICAO: item.DESCRICAO,
            QTDE: item.CONSUMO,
            CUSTO: item.CUSTO,
            DIVISOR: item.DIVISOR,
            VALOR: item.VALOR,
            SETOR: '',
            DESC_SETOR: '',
            COR: item.COR_I,
            DESC_COR: item.DESCCOR,
            COD_OPCIONAL: '',
            DESC_CARACTERISTICA: '',
            ACOES: retornaBotaoExcluir('consumo'),
            TIPO: item.TIPO
          }).draw(false);
        });
      } else {
        jsonStr.map(item => {
          $('#tabelaConsumos').DataTable().row.add({
            CODIGO: item.INSUMO,
            DESCRICAO: item.DESCRICAO,
            QTDE: item.CONSUMO,
            CUSTO: item.CUSTO,
            VALOR: item.VALOR,
            SETOR: '',
            DESC_SETOR: '',
            COR: item.COR_I,
            DESC_COR: item.DESCCOR,
            COD_OPCIONAL: '',
            DESC_CARACTERISTICA: '',
            ACOES: retornaBotaoExcluir('consumo'),
            TIPO: item.TIPO
          }).draw(false);
        });
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function explodeFaixaExpress(sFaixa, sTabPreco, sCodigo) {
    $.LoadingOverlay('show');
    $('#tabelaGrade').DataTable().clear();
    try {
      let pesquisaParam;
      if (!usaPrecoCorTam) {
        pesquisaParam = {
          tabela: 'FAIXA_ITEN',
          camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'TABPRECO.PRECO_00 PRECO'],
          leftJoin: [{ tabela: "TABPRECO", condicao: `TABPRECO.REGIAO = '${sTabPreco}' AND TABPRECO.CODIGO = '${sCodigo}'` }],
          where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
          orderBy: ['FAIXA_ITEN.POSICAO'],
        }
      } else {
        pesquisaParam = {
          tabela: 'FAIXA_ITEN',
          camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'PRECO_COR_TAM.PRECO'],
          leftJoin: [{ tabela: "PRECO_COR_TAM", condicao: `PRECO_COR_TAM.REGIAO = '${sTabPreco}' AND PRECO_COR_TAM.CODIGO = '${sCodigo}' AND PRECO_COR_TAM.COR = '${pegaChave('#txtCor')}' AND PRECO_COR_TAM.TAM = FAIXA_ITEN.TAMANHO` }],
          where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
          orderBy: ['FAIXA_ITEN.POSICAO'],
        }
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const precoVenda = await montaPrecoVenda(true);

      jsonStr.map((item, index) => {
        const precoItem = item.PRECO > 0 && usaPrecoCorTam ? item.PRECO : precoVenda
        $('#tabelaGrade').DataTable().row.add({
          TAMANHO: item.TAMANHO,
          QTDE: retornaInputValor('txtQtdeGrade txtCamposGrade', index, true),
          PRECO: retornaInputValor('txtPrecoGrade txtCamposGrade', index, false, precoItem),
          PERC_ACRESC: retornaInputValor('txtPercAcresGrade txtCamposGrade', index),
          VAL_ACRESC: retornaInputValor('txtValAcresGrade txtCamposGrade', index),
          PERC_DESC: retornaInputValor('txtPercDescGrade txtCamposGrade', index),
          VAL_DESC: retornaInputValor('txtValDescGrade txtCamposGrade', index),
          PRECO_LIQ: '0.00',
          TOTAL: '0.00',
          PRECO_ORIG: precoItem,
        }).draw(false);
      });

      if (itensAlteracao.length > 0) {
        const precoOrig = parseFloat(itensAlteracao[0].PRECO_ORIG)
        $('#tabelaGrade').DataTable().data().toArray().forEach((item, index) => {
          const itemAlteracao = itensAlteracao.find(item2 => item2.TAM == item.TAMANHO);
          const data = item
          item.PRECO_ORIG = precoOrig.toFixed(2)

          $('#tabelaGrade').DataTable().row(index).data(data).draw(false)
          if (itemAlteracao) {
            $($('.txtQtdeGrade')[index]).val(itemAlteracao.QTDE)
            $($('.txtPrecoGrade')[index]).val(itemAlteracao.PRECO)
            calculaTotaisGrade($($('.txtQtdeGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtQtdeGrade')[index]).attr('data-index'));

            if (itemAlteracao.DESCONTO > 0) {
              $($('.txtValDescGrade')[index]).val(itemAlteracao.DESCONTO)
              calculaTotaisGrade($($('.txtValDescGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtValDescGrade')[index]).attr('data-index'));
            }

            if (itemAlteracao.ACRESCIMO > 0) {
              $($('.txtValAcresGrade')[index]).val(itemAlteracao.ACRESCIMO)
              calculaTotaisGrade($($('.txtValAcresGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtValAcresGrade')[index]).attr('data-index'));
            }
          } else {
            $($('.txtQtdeGrade')[index]).val(0)
            $($('.txtPrecoGrade')[index]).val(precoOrig)
            $($('.txtValDescGrade')[index]).val(0)
            $($('.txtValAcresGrade')[index]).val(0)
            calculaTotaisGrade($($('.txtQtdeGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtQtdeGrade')[index]).attr('data-index'));
          }
        })
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });

      insereValor('#txtQtdeTotal', '0.00');
      insereValor('#txtValTotal', '0.00');

      aplicaMascara();

      $.LoadingOverlay('hide');
    }
  };

  async function preencheFaixa() {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'PRODUTO',
        camposSelect: ['PRODUTO.FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA'],
        leftJoin: [{ tabela: "FAIXA", condicao: `FAIXA.CODIGO = PRODUTO.FAIXA` }],
        where: [`PRODUTO.CODIGO = '${pegaChave('#txtCodigo')}'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        insereValor('#txtFaixa', jsonStr[0].FAIXA, jsonStr[0].DESC_FAIXA);
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnConfirmarInfos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      await preencheItens()
      await limpaValoresItens()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function validacoesPreencheItens(tabelaGrade, cor) {
    let qtdeTotal = 0;
    let existeItemSemValor = false

    for (let i = 0; i < tabelaGrade.length; i++) {
      qtdeTotal += parseInt($($('.txtQtdeGrade')[i]).val())

      if (parseInt($($('.txtQtdeGrade')[i]).val()) > 0 && parseFloat($($('.txtPrecoGrade')[i]).val()) <= 0) {
        existeItemSemValor = true
        break;
      }
    }
    if (cor == '') {
      throw new Error('Cor da grade não informada')
    }
    if (qtdeTotal <= 0) {
      throw new Error('Quantidade da grade não preenchida, verifique.')
    }
    if (existeItemSemValor) {
      throw new Error('Existem itens com quantidade sem preço informado, verifique.')
    }
  }

  async function preencheItens() {
    const tabelaItens = $('#tabelaItens').DataTable()
    let ordem = tabelaItens.data().toArray().length <= 0 ? 0 : tabelaItens.column(0).data().reduce(function (a, b) {
      return Math.max(a, b)
    })
    const codProt = $('#txtCodigo').val() != '' ? pegaChave('#txtCodigo') : await RetornaProximo('PROTOTIPO', 'PRODUTO', 'PROTOTIPO', 6)
    ordem = itensAlteracao.length > 0 ? parseInt(itensAlteracao[0].ORDEM) <= 0 ? ordem + 1 : itensAlteracao[0].ORDEM : ordem + 1
    const cor = $('#txtCor').val() == '' ? pegaChave('#txtCorGrade') : pegaChave('#txtCor')
    const descCor = $('#txtCor').val() == '' ? pegaDescricao('#txtCorGrade') : pegaDescricao('#txtCor')
    const codigo = codProt
    const prototipo = itensAlteracao.length > 0 ? itensAlteracao[0].PROTOTIPO == '' ? '' : itensAlteracao[0].PROTOTIPO : $('#txtCodigo').val() != '' ? '' : codProt
    const descricao = $('#txtCodigo').val() != '' ? pegaDescricao('#txtCodigo') : pegaDescricao('#txtLinha') + ' - ' + pegaDescricao('#txtGrupo') + ' - ' + pegaDescricao('#txtEtiqueta');

    const tabelaGrade = $('#tabelaGrade').DataTable().data().toArray()

    validacoesPreencheItens(tabelaGrade, cor)

    for (let i = 0; i < tabelaGrade.length; i++) {
      const grade = tabelaGrade[i]

      const obj = {
        ORDEM: ordem,
        CODIGO: codigo,
        DESCRICAO: descricao,
        COR: cor,
        DESCCOR: descCor,
        TAM: grade.TAMANHO,
        QTDE: parseInt($($('.txtQtdeGrade')[i]).val()),
        PRECO: parseFloat(grade.PRECO_ORIG),
        DESCONTO: parseFloat($($('.txtValDescGrade')[i]).val()),
        ACRESCIMO: parseFloat($($('.txtValAcresGrade')[i]).val()),
        VALOR: parseFloat(grade.TOTAL),
        CUSTOMIZACAO: parseFloat(retornaPrecoCustomizacoes()),
        OBS2: $('#txtObsProduto').val(),
        OBS3: $('#txtObsProducao').val(),
        OBSERVACAO: $('#txtObsEspecificacoes').val(),
        FAIXA: pegaChave('#txtFaixa'),
        PROTOTIPO: prototipo,
        MARKUP: pegaChave('#txtMarkup'),
        PRECO_ORIG: grade.PRECO_ORIG,
        COMPL_PROD: pegaValor('#txtComplDescProd'),
        LINHA: pegaChave('#txtLinha'),
        GRUPO: pegaChave('#txtGrupo'),
        ETIQUETA: pegaChave('#txtEtiqueta'),
      }

      if (itensAlteracao && itensAlteracao.length > 0) {
        const itemExistente = itensAlteracao.find(item =>
          item.ORDEM == obj.ORDEM &&
          item.CODIGO == obj.CODIGO &&
          item.COR == obj.COR &&
          item.TAM == obj.TAM
        );

        if (itemExistente) {
          tabelaItens.rows(function (idx, data, node) {
            return data.ORDEM == obj.ORDEM && data.CODIGO == obj.CODIGO && data.COR == obj.COR && data.TAM == obj.TAM;
          }).remove().draw(false);
        }
      }


      if (parseInt($($('.txtQtdeGrade')[i]).val()) <= 0) {
        continue
      }

      preencheCustomizacoes(codigo, prototipo == '' ? 'E' : 'N')
      preencheConsumos(codigo)

      if (prototipo != '') {
        preencheCaracteristicas(prototipo, idCaracteristica)
      }

      tabelaItens.row.add(obj).draw(false);
    }
    calculaTotais()
    $('#modalItem').modal('hide')
  }

  function calculaTotais() {
    let qtdeTotal = 0;
    let valorTotal = 0;
    for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
      const item = $('#tabelaItens').DataTable().data().toArray()[i]
      qtdeTotal += parseInt(item.QTDE)
      valorTotal = parseFloat(valorTotal) + parseFloat(item.VALOR)
    }

    const novoValor = parseFloat(valorTotal) || 0
    const desc = $('#txtDesconto').val() || 0
    let novoValorLiq = 0
    if (desc > 0) {
      novoValorLiq = novoValor - (novoValor * (desc / 100))
    } else {
      novoValorLiq = novoValor
    }
    $('.txtTotalQtde').text(qtdeTotal)
    $('.txtValorTotal').html(parseFloat(novoValor.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }));
    $('.txtTotalLiquido').html(parseFloat(novoValorLiq.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }));
    $("#txtValorFinanceiro").html(parseFloat(novoValorLiq.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }))
  }

  $('#modalItem').on('hidden.bs.modal', function () {
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
    itensAlteracao = []
    limpaValoresItens()
  })

  function preencheCustomizacoes(codigo, tipo) {
    const tabelaSerigrafiaItens = $('#tabelaItensSerigrafia').DataTable()

    if (tabelaSerigrafiaItens) {
      const codigoExistenteSerig = tabelaSerigrafiaItens.data().toArray().some(item => item.CODIGO == codigo);

      if (codigoExistenteSerig) {
        tabelaSerigrafiaItens.rows(function (idx, data, node) {
          return data.CODIGO == codigo;
        }).remove().draw(false);
      }

      for (let i = 0; i < $('#tabelaSerigrafia').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaSerigrafia').DataTable().data().toArray()[i]
        const serigrafia = {
          CODIGO: codigo,
          TIPO_ITEM: tipo,
          TIPO: item.TIPO,
          TAMANHO: item.TAMANHO,
          LOCAL: item.LOCAL,
          QTDE_CORES: parseInt(item.QTDE_CORES) || 0,
          TOTAL: parseInt(item.TOTAL) || 1,
          ALTURA: parseFloat(item.ALTURA) || 0,
          LARGURA: parseFloat(item.LARGURA) || 0,
          NOME: item.NOME,
          PRECO: parseFloat($($('.txtPrecoSerig')[i]).val()) || 0
        }

        tabelaSerigrafiaItens.row.add(serigrafia).draw(false)
      }
    }

    const tabelaBordadoItens = $('#tabelaItensBordado').DataTable()
    if (tabelaBordadoItens) {
      const codigoExistenteBord = tabelaBordadoItens.data().toArray().some(item => item.CODIGO == codigo);

      if (codigoExistenteBord) {
        tabelaBordadoItens.rows(function (idx, data, node) {
          return data.CODIGO == codigo;
        }).remove().draw(false);
      }

      for (let i = 0; i < $('#tabelaBordado').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaBordado').DataTable().data().toArray()[i]
        const bordado = {
          CODIGO: codigo,
          TIPO_ITEM: tipo,
          PROGRAMACAO: item.PROGRAMACAO,
          TAMANHO: item.TAMANHO,
          LOCAL: item.LOCAL,
          QTDE_PROG: parseInt(item.QTDE_PROG) || 0,
          TOTAL: parseInt(item.TOTAL) || 1,
          ALTURA: parseFloat(item.ALTURA) || 0,
          LARGURA: parseFloat(item.LARGURA) || 0,
          NOME: item.NOME,
          PRECO: parseFloat($($('.txtPrecoBordado')[i]).val()) || 0
        }

        tabelaBordadoItens.row.add(bordado).draw(false)
      }
    }

    const tabelaSublimacaoItens = $('#tabelaItensSublimacao').DataTable()
    if (tabelaSublimacaoItens) {
      const codigoExistenteSublimacao = tabelaSublimacaoItens.data().toArray().some(item => item.ITEM == codigo);

      if (codigoExistenteSublimacao) {
        tabelaSublimacaoItens.rows(function (idx, data, node) {
          return data.ITEM == codigo;
        }).remove().draw(false);
      }

      for (let i = 0; i < $('#tabelaSublimacao').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaSublimacao').DataTable().data().toArray()[i];
        const row = $('#tabelaSublimacao').DataTable().row(i).node();
        const isChecked = $(row).find('.checkSublimacao').is(':checked');

        if (isChecked) {
          const sublimacao = {
            ITEM: codigo,
            TIPO_ITEM: tipo,
            CODIGO: item.CODIGO,
            DESCRICAO: item.DESCRICAO,
            PRECO: parseFloat($($('.txtPrecoSublimacao')[i]).val()) || 0
          };

          tabelaSublimacaoItens.row.add(sublimacao).draw(false);
        }
      }
    }

    const tabelaTermotapeItens = $('#tabelaItensTermotape').DataTable()
    if (tabelaTermotapeItens) {
      const codigoExistenteTermo = tabelaTermotapeItens.data().toArray().some(item => item.ITEM == codigo);

      if (codigoExistenteTermo) {
        tabelaTermotapeItens.rows(function (idx, data, node) {
          return data.ITEM == codigo;
        }).remove().draw(false);
      }

      for (let i = 0; i < $('#tabelaTermotape').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaTermotape').DataTable().data().toArray()[i]
        const termotape = {
          ITEM: codigo,
          TIPO_ITEM: tipo,
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          TAM_CM2: item.TAM_CM2,
          TOTAL: parseInt(item.TOTAL) || 1,
          PRECO: parseFloat($($('.txtPrecoTermo')[i]).val()) || 0
        }

        tabelaTermotapeItens.row.add(termotape).draw(false)
      }
    }

    const tabelaDTFItens = $('#tabelaItensDTF').DataTable()
    if (tabelaDTFItens) {
      const codigoExistenteBord = tabelaDTFItens.data().toArray().some(item => item.CODIGO == codigo);

      if (codigoExistenteBord) {
        tabelaDTFItens.rows(function (idx, data, node) {
          return data.CODIGO == codigo;
        }).remove().draw(false);
      }

      for (let i = 0; i < $('#tabelaDTF').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaDTF').DataTable().data().toArray()[i]
        const dtf = {
          CODIGO: codigo,
          TIPO_ITEM: tipo,
          PROGRAMACAO: item.PROGRAMACAO,
          TAMANHO: item.TAMANHO,
          LOCAL: item.LOCAL,
          QTDE_PROG: parseInt(item.QTDE_PROG) || 0,
          TOTAL: parseInt(item.TOTAL) || 1,
          ALTURA: parseFloat(item.ALTURA) || 0,
          LARGURA: parseFloat(item.LARGURA) || 0,
          NOME: item.NOME,
          PRECO: parseFloat($($('.txtPrecoDTF')[i]).val()) || 0
        }

        tabelaDTFItens.row.add(dtf).draw(false)
      }
    }
  }

  function preencheCaracteristicas(prototipo, idCaracteristica) {
    const tabelaCaracteristicaItens = $('#tabelaItensCaracteristica').DataTable()
    if (tabelaCaracteristicaItens) {
      const codigoExistenteCaracteristica = tabelaCaracteristicaItens.data().toArray().some(item => item.COD_PROT == prototipo);

      if (codigoExistenteCaracteristica) {
        tabelaCaracteristicaItens.rows(function (idx, data, node) {
          return data.COD_PROT == prototipo;
        }).remove().draw(false);
      }

      for (let i = 0; i < $('#tabelaCaracteristicas').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaCaracteristicas').DataTable().data().toArray()[i];
        const row = $('#tabelaCaracteristicas').DataTable().row(i).node();
        const isChecked = $(row).find('.checkCaracteristica').is(':checked');

        if (isChecked) {
          const caracteristica = {
            COD_PROT: prototipo,
            ID_CARACT: idCaracteristica,
            ID_CARACT_CAD: item.ID
          };

          tabelaCaracteristicaItens.row.add(caracteristica).draw(false);
        }
      }
    }
  }

  function preencheConsumos(codigo) {
    const tabelaConsumosItens = $('#tabelaItensConsumos').DataTable()
    if (tabelaConsumosItens) {
      const codigoExistenteConsumo = tabelaConsumosItens.data().toArray().some(item => item.CODIGO == codigo);

      if (codigoExistenteConsumo) {
        tabelaConsumosItens.rows(function (idx, data, node) {
          return data.CODIGO == codigo;
        }).remove().draw(false);
      }

      for (let i = 0; i < $('#tabelaConsumos').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaConsumos').DataTable().data().toArray()[i]
        let consumos
        if (usaFatorConv) {
          consumos = {
            CODIGO: codigo,
            INSUMO: item.CODIGO,
            DESCRICAO: item.DESCRICAO,
            QTDE: parseFloat(item.QTDE) || 0,
            CUSTO: parseFloat(item.CUSTO) || 0,
            DIVISOR: parseFloat(item.DIVISOR) || 0,
            VALOR: parseFloat(item.VALOR) || 0,
            COR: item.COR,
            DESC_COR: item.DESC_COR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESC_SETOR,
            COD_OPCIONAL: item.COD_OPCIONAL,
            DESC_CARACTERISTICA: item.DESC_CARACTERISTICA,
            TIPO: item.TIPO
          }
        } else {
          consumos = {
            CODIGO: codigo,
            INSUMO: item.CODIGO,
            DESCRICAO: item.DESCRICAO,
            QTDE: parseFloat(item.QTDE) || 0,
            CUSTO: parseFloat(item.CUSTO) || 0,
            VALOR: parseFloat(item.VALOR) || 0,
            COR: item.COR,
            DESC_COR: item.DESC_COR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESC_SETOR,
            COD_OPCIONAL: item.COD_OPCIONAL,
            DESC_CARACTERISTICA: item.DESC_CARACTERISTICA,
            TIPO: item.TIPO
          }
        }

        tabelaConsumosItens.row.add(consumos).draw(false)
      }
    }
  }

  $('#tabelaItens').on('click', '#btn-excluir', async function () {
    await msgAguardaConfirmacao('Deseja excluir este registro?', async () => {
      const codigo = $('#tabelaItens').DataTable().row($($(this).get(0)).closest('tr')).data().CODIGO
      $('#tabelaItens').DataTable().data().rows($('#tabelaItens').DataTable().row($($(this).get(0)).closest('tr')).index()).remove().draw(false);
      exclusaoTabelasAuxiliares(codigo)
      calculaTotais()
    })
  })

  function exclusaoTabelasAuxiliares(codigo) {
    const codigoExistente = $('#tabelaItens').DataTable().data().toArray().some(item => item.CODIGO == codigo);

    if (!codigoExistente) {
      $('#tabelaItensSerigrafia').DataTable().rows(function (idx, data, node) {
        return data.CODIGO == codigo;
      }).remove().draw(false);

      $('#tabelaItensBordado').DataTable().rows(function (idx, data, node) {
        return data.CODIGO == codigo;
      }).remove().draw(false);

      $('#tabelaItensSublimacao').DataTable().rows(function (idx, data, node) {
        return data.ITEM == codigo;
      }).remove().draw(false);

      $('#tabelaItensTermotape').DataTable().rows(function (idx, data, node) {
        return data.ITEM == codigo;
      }).remove().draw(false);

      $('#tabelaItensDTF').DataTable().rows(function (idx, data, node) {
        return data.CODIGO == codigo;
      }).remove().draw(false);

      $('#tabelaItensConsumos').DataTable().rows(function (idx, data, node) {
        return data.CODIGO == codigo;
      }).remove().draw(false);

      $('#tabelaItensCaracteristica').DataTable().rows(function (idx, data, node) {
        return data.COD_PROT == codigo;
      }).remove().draw(false);
    }
  }

  $('#tabelaItens').on('click', '#btn-editar', async function () {
    $.LoadingOverlay('show')
    try {
      const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      itensAlteracao = $('#tabelaItens').DataTable().data().toArray().filter(item => { return item.CODIGO == data.CODIGO && item.ORDEM == data.ORDEM })
      insereValor('#txtCodigo', data.CODIGO, data.DESCRICAO)
      insereValor('#txtCor', data.COR, data.DESCCOR)
      $('#txtQtde').val(1);
      $('#txtPreco').val(data.PRECO);
      $('#txtObsProduto').val(data.OBS2)
      $('#txtObsProducao').val(data.OBS3)
      $('#txtObsEspecificacoes').val(data.OBSERVACAO)
      $('#txtComplDescProd').val(data.COMPL_PROD)
      insereValor('#txtMarkup', data.MARKUP, { tabela: 'CAD_MARKUP', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.MARKUP })
      preencheTabelaIndices(data.MARKUP)

      insereValor('#txtLinha', data.LINHA, { tabela: 'TABLIN', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.LINHA })
      insereValor('#txtGrupo', data.GRUPO, { tabela: 'GRUPO_PA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.GRUPO })
      insereValor('#txtEtiqueta', data.ETIQUETA, { tabela: 'ETQ_PROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.ETIQUETA })

      if (data.FAIXA) {
        insereValor('#txtFaixa', data.FAIXA, { tabela: 'FAIXA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.FAIXA })
      }

      await carregaCustomSublimacao()
      carregaEdicaoCustomizacao(data.CODIGO)
      await carregaEdicaoCaracteristica(data.PROTOTIPO, data.GRUPO, data.LINHA, data.ETIQUETA)
      carregaEdicaoConsumos(data.CODIGO)

      bloqueiaCamposEdicao(true)

      $('#modalItem').modal('show')
      $('#txtCodigo').trigger('blur')
    } catch (e) {
      console.error(e)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function carregaEdicaoCustomizacao(codigo) {
    try {
      $('#tabelaSerigrafia').DataTable().clear().draw(false)
      $('#tabelaBordado').DataTable().clear().draw(false)
      $('#tabelaTermotape').DataTable().clear().draw(false)
      $('#tabelaDTF').DataTable().clear().draw(false)
      const itensSerigrafia = $('#tabelaItensSerigrafia').DataTable().data().toArray().filter(item => item.CODIGO == codigo);

      if (itensSerigrafia) {
        itensSerigrafia.forEach((item, index) => {
          $('#tabelaSerigrafia').DataTable().row.add({
            NOME: item.NOME,
            TIPO: item.TIPO,
            TAMANHO: item.TAMANHO,
            LOCAL: item.LOCAL,
            QTDE_CORES: item.QTDE_CORES,
            TOTAL: item.TOTAL,
            ALTURA: item.ALTURA,
            LARGURA: item.LARGURA,
            PRECO: retornaInputValor('txtPrecoSerig txtCamposSerig', index, false,
              item.PRECO,
              false
            )
          }).draw(false);
        });
      }

      const itensBordado = $('#tabelaItensBordado').DataTable().data().toArray().filter(item => item.CODIGO == codigo);

      if (itensBordado) {
        itensBordado.forEach((item, index) => {
          $('#tabelaBordado').DataTable().row.add({
            NOME: item.NOME,
            PROGRAMACAO: item.PROGRAMACAO,
            TAMANHO: item.TAMANHO,
            LOCAL: item.LOCAL,
            QTDE_PROG: item.QTDE_PROG,
            TOTAL: item.TOTAL,
            ALTURA: item.ALTURA,
            LARGURA: item.LARGURA,
            PRECO: retornaInputValor('txtPrecoBordado txtCamposBordado', index, false,
              item.PRECO,
              false
            )
          }).draw(false);
        });
      }

      const itensSublimacao = $('#tabelaItensSublimacao').DataTable().data().toArray().filter(item => item.ITEM == codigo);

      if (itensSublimacao) {
        itensSublimacao.forEach(item => {
          $('#tabelaSublimacao').DataTable().rows().every(function (rowIdx) {
            const data = this.data();

            if (data.CODIGO == item.CODIGO) {
              const row = $(this.node());
              const checkBox = row.find('.checkSublimacao');

              if (!checkBox.is(':checked')) {
                checkBox.prop('checked', true);
              }

              data.PRECO = retornaInputValor(
                'txtPrecoSublimacao',
                rowIdx,
                false,
                item.PRECO,
                false
              );

              this.data(data).draw(false);
            }
          });
        });
      }

      const itensTermotape = $('#tabelaItensTermotape').DataTable().data().toArray().filter(item => item.ITEM == codigo);

      if (itensTermotape) {
        itensTermotape.forEach((item, index) => {
          $('#tabelaTermotape').DataTable().row.add({
            CODIGO: item.CODIGO,
            DESCRICAO: item.DESCRICAO,
            TAM_CM2: item.TAM_CM2,
            TOTAL: item.TOTAL,
            PRECO: retornaInputValor('txtPrecoTermo txtCamposTermo', index, false,
              item.PRECO,
              false
            )
          }).draw(false);
        });
      }

      const itensDTF = $('#tabelaItensDTF').DataTable().data().toArray().filter(item => item.CODIGO == codigo);

      if (itensDTF) {
        itensDTF.forEach((item, index) => {
          $('#tabelaDTF').DataTable().row.add({
            NOME: item.NOME,
            PROGRAMACAO: item.PROGRAMACAO,
            TAMANHO: item.TAMANHO,
            LOCAL: item.LOCAL,
            QTDE_PROG: item.QTDE_PROG,
            TOTAL: item.TOTAL,
            ALTURA: item.ALTURA,
            LARGURA: item.LARGURA,
            PRECO: retornaInputValor('txtPrecoDTF txtCamposDTF', index, false,
              item.PRECO,
              false
            )
          }).draw(false);
        });
      }
    } finally {
      aplicaMascara()
    }
  }

  function carregaEdicaoConsumos(codigo) {
    $('#tabelaConsumos').DataTable().clear().draw(false)

    const itensConsumos = $('#tabelaItensConsumos').DataTable().data().toArray().filter(item => item.CODIGO == codigo);

    if (itensConsumos) {
      itensConsumos.forEach(item => {
        $('#tabelaConsumos').DataTable().row.add({
          CODIGO: item.INSUMO,
          DESCRICAO: item.DESCRICAO,
          QTDE: item.QTDE,
          CUSTO: item.CUSTO,
          DIVISOR: item.DIVISOR,
          VALOR: item.VALOR,
          SETOR: item.SETOR,
          DESC_SETOR: item.DESC_SETOR,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          COD_OPCIONAL: item.COD_OPCIONAL,
          DESC_CARACTERISTICA: item.DESC_CARACTERISTICA,
          ACOES: retornaBotaoExcluir('consumo'),
          TIPO: item.TIPO
        }).draw(false);
      });
    }
  }

  async function carregaEdicaoCaracteristica(prototipo, grupo, linha, etiqueta) {
    $.LoadingOverlay('show')
    try {
      if (prototipo == '') {
        return;
      }
      const itensCaracteristicas = $('#tabelaItensCaracteristica').DataTable().data().toArray().filter(item => item.COD_PROT == prototipo);

      if (linha && grupo && etiqueta) {
        await buscaCaracteristica(linha, grupo, etiqueta, true);

        const rows = $('#tabelaCaracteristicas').DataTable().rows().nodes();
        const selectedIds = new Set(itensCaracteristicas.map(item => item.ID_CARACT_CAD));

        for (let i = 0; i < rows.length; i++) {
          const row = $(rows[i]);
          const data = $('#tabelaCaracteristicas').DataTable().row(row).data();
          const checkBox = row.find('.checkCaracteristica');

          if (selectedIds.has(data.ID)) {
            if (!checkBox.is(':checked')) {
              row.trigger('click');
              row.find('td').trigger('click');
            }
          } else {
            if (checkBox.is(':checked')) {
              row.trigger('click');
              row.find('td').trigger('click');
            }
          }
        }
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function bloqueiaCamposEdicao(edicao) {
    // $('.checkCaracteristica').prop('disabled', edicao)
    $('.btn-editar-composicao').prop('disabled', edicao)
    $('.btn-excluir-composicao').prop('disabled', edicao)
    $('#btnAddComposicao').prop('disabled', edicao)
    $('#btnBuscarComposicao').prop('disabled', edicao)
    $('.checkAplicacoes').prop('disabled', edicao)
    $('.txtAltura').prop('disabled', edicao)
    $('.txtLargura').prop('disabled', edicao)
    $('.txtFundo').prop('disabled', edicao)
    $('.txtVisor').prop('disabled', edicao)
    $('.txtConsumo').prop('disabled', edicao)
    // $('.btn-editar-consumos').prop('disabled', edicao)
    // $('.btn-excluir-consumos').prop('disabled', edicao)
    // $('#btnAddConsumo').prop('disabled', edicao)
    // $('#txtNomeSerigrafia').prop('disabled', edicao)
    // $('#txtQtdeCores').prop('disabled', edicao)
    // $('#txtAlturaSerigrafia').prop('disabled', edicao)
    // $('#txtLarguraSerigrafia').prop('disabled', edicao)
    // $('#txtTotalPecasSerigrafia').prop('disabled', edicao)
    // $('#btnRemoveSerigrafia').prop('disabled', edicao)
    // $('#btnAddSerigrafia').prop('disabled', edicao)
    // $('#txtNomeBordado').prop('disabled', edicao)
    // $('#txtQtdeProg').prop('disabled', edicao)
    // $('#txtAlturaBordado').prop('disabled', edicao)
    // $('#txtLarguraBordado').prop('disabled', edicao)
    // $('#txtTotalPecasBordado').prop('disabled', edicao)
    // $('#btnRemoveBordado').prop('disabled', edicao)
    // $('#btnAddBordado').prop('disabled', edicao)
    // $('#txtNomeDTF').prop('disabled', edicao)
    // $('#txtQtdeProgDTF').prop('disabled', edicao)
    // $('#txtAlturaDTF').prop('disabled', edicao)
    // $('#txtLarguraDTF').prop('disabled', edicao)
    // $('#txtTotalPecasDTF').prop('disabled', edicao)
    // $('#btnRemoveDTF').prop('disabled', edicao)
    // $('#btnAddDTF').prop('disabled', edicao)
    // $('.checkSublimacao').prop('disabled', edicao)
    // $('#txtTamCm2').prop('disabled', edicao)
    // $('#txtTotalPecasTermotape').prop('disabled', edicao)
    // $('#btnRemoveTermotape').prop('disabled', edicao)
    // $('#btnAddTermotape').prop('disabled', edicao)
    $('#txtCodigo').prop('disabled', edicao)
    $('#btn-Codigo').prop('disabled', edicao)
    $('#btn-limpa-Codigo').prop('disabled', edicao)
    $('#txtCor').prop('disabled', edicao)
    $('#btn-Cor').prop('disabled', edicao)
    $('#btn-limpa-Cor').prop('disabled', edicao)
    $('#txtLinha').prop('disabled', edicao)
    $('#btn-Linha').prop('disabled', edicao)
    $('#btn-limpa-Linha').prop('disabled', edicao)
    $('#txtGrupo').prop('disabled', edicao)
    $('#btn-Grupo').prop('disabled', edicao)
    $('#btn-limpa-Grupo').prop('disabled', edicao)
    $('#txtEtiqueta').prop('disabled', edicao)
    $('#btn-Etiqueta').prop('disabled', edicao)
    $('#btn-limpa-Etiqueta').prop('disabled', edicao)
    $('#txtMarkup').prop('disabled', edicao)
    $('#btn-Markup').prop('disabled', edicao)
    $('#btn-limpa-Markup').prop('disabled', edicao)
    $('#txtQtde').prop('disabled', edicao)
    $('#txtComplDescProd').prop('disabled', !edicao)

    if (edicao) {
      // $('#tabelaCaracteristicas tbody tr').addClass('linhaDesabilitada')
      $('#tabelaComposicao tbody tr').addClass('linhaDesabilitada')
      $('#tabelaTecidosUtilizados tbody tr').addClass('linhaDesabilitada')
      // $('#tabelaConsumos tbody tr').addClass('linhaDesabilitada')
      // $('#tabelaSerigrafiaTipo tbody').addClass('linhaDesabilitada')
      // $('#tabelaSerigrafiaLocal tbody').addClass('linhaDesabilitada')
      // $('#tabelaSerigrafiaTamanho tbody').addClass('linhaDesabilitada')
      // $('#tabelaSerigrafia tbody tr').addClass('linhaDesabilitada')
      // $('#tabelaBordadoProgramacao tbody').addClass('linhaDesabilitada')
      // $('#tabelaBordadoLocal tbody').addClass('linhaDesabilitada')
      // $('#tabelaBordadoTamanho tbody').addClass('linhaDesabilitada')
      // $('#tabelaBordado tbody tr').addClass('linhaDesabilitada')
      // $('#tabelaDTFProgramacao tbody').addClass('linhaDesabilitada')
      // $('#tabelaDTFLocal tbody').addClass('linhaDesabilitada')
      // $('#tabelaDTFTamanho tbody').addClass('linhaDesabilitada')
      // $('#tabelaDTF tbody tr').addClass('linhaDesabilitada')
      // $('#tabelaSublimacao tbody tr').addClass('linhaDesabilitada')
      // $('#tabelaTermotapeTipo tbody').addClass('linhaDesabilitada')
      // $('#tabelaTermotape tbody tr').addClass('linhaDesabilitada')
    } else {
      // $('#tabelaCaracteristicas tbody tr').removeClass('linhaDesabilitada')
      $('#tabelaComposicao tbody tr').removeClass('linhaDesabilitada')
      $('#tabelaTecidosUtilizados tbody tr').removeClass('linhaDesabilitada')
      // $('#tabelaConsumos tbody tr').removeClass('linhaDesabilitada')
      // $('#tabelaSerigrafiaTipo tbody').removeClass('linhaDesabilitada')
      // $('#tabelaSerigrafiaLocal tbody').removeClass('linhaDesabilitada')
      // $('#tabelaSerigrafiaTamanho tbody').removeClass('linhaDesabilitada')
      // $('#tabelaSerigrafia tbody tr').removeClass('linhaDesabilitada')
      // $('#tabelaBordadoProgramacao tbody').removeClass('linhaDesabilitada')
      // $('#tabelaBordadoLocal tbody').removeClass('linhaDesabilitada')
      // $('#tabelaBordadoTamanho tbody').removeClass('linhaDesabilitada')
      // $('#tabelaBordado tbody tr').removeClass('linhaDesabilitada')
      // $('#tabelaDTFProgramacao tbody').removeClass('linhaDesabilitada')
      // $('#tabelaDTFLocal tbody').removeClass('linhaDesabilitada')
      // $('#tabelaDTFTamanho tbody').removeClass('linhaDesabilitada')
      // $('#tabelaDTF tbody tr').removeClass('linhaDesabilitada')
      // $('#tabelaSublimacao tbody tr').removeClass('linhaDesabilitada')
      // $('#tabelaTermotapeTipo tbody').removeClass('linhaDesabilitada')
      // $('#tabelaTermotape tbody tr').removeClass('linhaDesabilitada')
    }
  }

  $('#txtQtde').on('keydown', function (e) {
    if (e.key == ',' || e.key == '.') {
      e.preventDefault();
    }
  });

  $('#txtQtde').on('input', function () {
    this.value = this.value.replace(/[^\d-]/g, '');
    this.value = this.value.replace(/(\d+)[.,](\d+)/, '$1');
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('ORCAMENTO', getCookie('usuario'), orcamento);
    window.location.href = `${BASE_URI}/orcamento`;
  })

  $('#btnBuscarComposicao').on('click', async function () {
    $.LoadingOverlay('show')
    $('#tabelaComposicao').DataTable().clear().draw();
    try {
      const caracteristicas = $('#tabelaCaracteristicas').DataTable().rows(function (idx, data, node) {
        return $(node).find('input.checkCaracteristica').is(':checked');
      }).data().map(item => item.CODIGO).toArray();
      const caracteristicasFormatadas = await formataListas(caracteristicas.toString())

      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacomposicaocarac?', `ID=${idCaracteristica}&CARACTERISTICAS=${caracteristicasFormatadas}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      jsonStr.map(item => {
        $('#tabelaComposicao').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          FORNECEDOR: '',
          NOME_FORNECEDOR: '',
          COD_OPCIONAL: item.COD_OPCIONAL,
          DESC_OPCIONAL: item.DESC_OPCIONAL,
          ACOES: retornaBotaoExcluir('composicao'),
        }).draw(false);
      });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#txtMarkup').off('blur')
  $('#txtMarkup').on('blur', async function () {
    $.LoadingOverlay('show')
    try {
      if ($(this).val() == '') {
        $('#txtIndiceTotal').val('0');
        $('#tabelaIndices').DataTable().rows().clear().draw(false)
      } else {
        $('#tabelaIndices').DataTable().rows().clear().draw(false)
        await preencheTabelaIndices(pegaChave('#txtMarkup'))
      }

      let precoVenda = 0

      if (($('#txtLinha').val() != '') && ($('#txtGrupo').val() != '') && ($('#txtEtiqueta').val() != '')) {
        precoVenda = await montaPrecoVenda();
      } else if ($('#txtCodigo').val() != '' && $('#txtCor').val() != '') {
        precoVenda = await montaPrecoVenda(true);
      }

      if ($('#tabelaGrade').DataTable().data().toArray().length > 0) {
        $('#tabelaGrade').DataTable().data().toArray().forEach((item, index) => {
          const data = item
          data.PRECO_ORIG = precoVenda;
          const qtdeAtual = $($('.txtQtdeGrade')[index]).val()
          const desconto = $($('.txtValDescGrade')[index]).val()
          const acrescimo = $($('.txtValAcresGrade')[index]).val()
          $('#tabelaGrade').DataTable().row(index).data(data).draw(false)
          $($('.txtPrecoGrade')[index]).val(precoVenda)
          $($('.txtQtdeGrade')[index]).val(qtdeAtual)
          calculaTotaisGrade($($('.txtQtdeGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtQtdeGrade')[index]).attr('data-index'));

          if (desconto > 0) {
            $($('.txtValDescGrade')[index]).val(desconto)
            calculaTotaisGrade($($('.txtValDescGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtValDescGrade')[index]).attr('data-index'));
          }

          if (acrescimo > 0) {
            $($('.txtValAcresGrade')[index]).val(acrescimo)
            calculaTotaisGrade($($('.txtValAcresGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtValAcresGrade')[index]).attr('data-index'));
          }

        });
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });
      $.LoadingOverlay('hide')
    }
  })

  async function carregaConsumosCaracteristicas(codApl, codigo) {
    $.LoadingOverlay('show');
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumoscarac?', `ID=${idCaracteristica}&CODAPL=${codApl}&CODIGO=${codigo}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      if (usaFatorConv) {
        jsonStr.map(item => {
          $('#tabelaConsumos').DataTable().row.add({
            CODIGO: item.COD_MAT,
            DESCRICAO: item.DESC_MAT,
            QTDE: item.QTDE,
            CUSTO: item.CUSTO,
            DIVISOR: item.DIVISOR,
            VALOR: item.VALOR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESC_SETOR,
            COR: item.COR,
            DESC_COR: item.DESC_COR,
            COD_OPCIONAL: codigo,
            DESC_CARACTERISTICA: item.DESC_CARACTERISTICA,
            ACOES: retornaBotaoExcluir('consumo'),
            TIPO: item.TIPO
          }).draw(false);
        });
      } else {
        jsonStr.map(item => {
          $('#tabelaConsumos').DataTable().row.add({
            CODIGO: item.COD_MAT,
            DESCRICAO: item.DESC_MAT,
            QTDE: item.QTDE,
            CUSTO: item.CUSTO,
            VALOR: item.VALOR,
            SETOR: item.SETOR,
            DESC_SETOR: item.DESC_SETOR,
            COR: item.COR,
            DESC_COR: item.DESC_COR,
            COD_OPCIONAL: codigo,
            DESC_CARACTERISTICA: item.DESC_CARACTERISTICA,
            ACOES: retornaBotaoExcluir('consumo'),
            TIPO: item.TIPO
          }).draw(false);
        });
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function validaCaracteristicaUnica(codApl, indexSel) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'PCPAPL',
        camposSelect: ['CARACT_UNICA'],
        where: [`CODIGO = '${codApl}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0 && jsonStr[0].CARACT_UNICA == 'S') {
        const caracteristicas = $('#tabelaCaracteristicas').DataTable().data().toArray()
        const linhas = $('#tabelaCaracteristicas').DataTable().rows().nodes()
        for (let i = 0; i < caracteristicas.length; i++) {
          const item = caracteristicas[i]

          if (item.COD_APL != codApl) {
            continue
          }

          const row = $(linhas[i]);
          const checkBox = row.find('.checkCaracteristica');

          if (checkBox.length > 0) {
            if (i == indexSel) {
              if (!checkBox.is(':checked')) {
                checkBox.trigger('click');
              }
            } else {
              if (checkBox.is(':checked')) {
                checkBox.trigger('click');
              }
            }
          }
        }
      } else {
        return
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function limpaDadosFinan() {
    $('.dadosFinan').val('')
    $('.dadosFinanHeader').val('')
  }

  $('#txtCondicao').on('blur', async function () {
    if ($(this).val() == '') {
      $('.dadosFinan').prop('disabled', true)
      limpaDadosFinan()
      return
    }
    $.LoadingOverlay('show')
    try {
      $('.dadosFinan').prop('disabled', false)

      const pesquisaParam = {
        tabela: 'CONDICAO',
        camposSelect: ['CONDICAO.ENTRADA', 'CONDICAO.PRZ_MEDIO', 'CONDICAO.NRPAR', 'CONDICAO.PRAZOINI', 'CONDICAO.NRDIA', 'COND_PERC.DESCONTO DESCMAX'],
        leftJoin: [{ tabela: 'COND_PERC', condicao: 'COND_PERC.CODIGO = CONDICAO.COND_PERC' }],
        where: [`CONDICAO.CODCOND = '${pegaChave('#txtCondicao')}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        $('#txtPercEntrada').val(jsonStr[0].ENTRADA)
        $('#txtPrzMedio').val(jsonStr[0].PRZ_MEDIO)
        $('#txtMaxParcelas').val(jsonStr[0].NRPAR)
        $('#txtPrzMaxPrimeira').val(jsonStr[0].PRAZOINI)
        $('#txtIntervaloParcelas').val(jsonStr[0].NRDIA)

        $('#txtNParcelas').val(jsonStr[0].NRPAR)
        $('#txtPrazoPrimeiraParc').val(jsonStr[0].PRAZOINI)
        $('#txtIntervaloParc').val(jsonStr[0].NRDIA)
        calculaPrazoMedio()
      } else {
        return
      }

      if (jsonStr.length > 0 && jsonStr[0].DESCMAX != '') {
        $('#txtDesconto1').val(jsonStr[0].DESCMAX)
        $('#txtDesconto1').trigger('blur')
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $("#txtDesconto1, #txtDesconto2, #txtDesconto3, #txtDesconto4, #txtDesconto5").change(async function () {
    const desc = descontoUnificado('0' + $('#txtDesconto1').val() + '+0' + $('#txtDesconto2').val() + '+0' + $('#txtDesconto3').val() + '+0' + $('#txtDesconto4').val() + '+0' + $('#txtDesconto5').val())
    $('#txtDesconto').val(desc)
    $('#txtDesconto').trigger('change')
  });

  $('#txtDesconto').on('change', function () {
    const valorTot = parseFloat($('#txtValorTotalItens').text().replace(/\./g, '').replace(',', '.'))
    const desc = parseFloat($(this).val())
    const valFinal = roundTo(valorTot - (valorTot * (desc / 100)), 2)

    $("#txtValorFinanceiro").html(parseFloat(valFinal).toLocaleString("pt-BR", { style: "decimal" }));
    $(".txtTotalLiquido").html(parseFloat(valFinal).toLocaleString("pt-BR", { style: "decimal" }));
  })

  function descontoUnificado(descontos) {
    let descUni = 100;
    let descRestante = descontos + '+';

    while (descRestante.indexOf('+') > 0 && descRestante.length > 1) {
      let desc = parseFloat($.trim(descRestante.substring(0, descRestante.indexOf('+'))));
      descUni = descUni - ((descUni / 100) * desc);
      descRestante = descRestante.substring(descRestante.indexOf('+') + 1);
    }

    return parseFloat((100 - descUni).toFixed(2));
  }

  function calculaPrazoMedio() {
    let dias = 0;
    let totGeral = 0
    let ultimo
    const parcelas = parseInt($('#txtNParcelas').val())

    for (let i = 0; i < parcelas; i++) {
      if (i == 0) {
        dias = parseInt($('#txtPrazoPrimeiraParc').val())
        ultimo = dias
        totGeral = ultimo
      } else {
        dias = dias + parseInt($('#txtIntervaloParc').val())
        ultimo = dias
        totGeral = totGeral + ultimo
      }
    }

    if (parseFloat(totGeral) > 0 && parseFloat(parcelas) > 0) {
      return $('#txtPrazoMedioCalc').val(parseFloat(totGeral) / parseFloat(parcelas))
    } else {
      return $('#txtPrazoMedioCalc').val(0)
    }
  }

  $('#txtNParcelas').on('blur', function () {
    if (parseInt($(this).val()) > parseInt($('#txtMaxParcelas').val())) {
      msgAlerta('Número de parcelas não pode ser maior que o máximo definido na condição de pagamento.', () => {
        $('#txtNParcelas').focus()
      }, null, null, null, false, true)
      $('#txtNParcelas').val(0)
    }

    calculaPrazoMedio()
  })

  $('#txtPrazoPrimeiraParc').on('blur', function () {
    if (parseInt($(this).val()) > parseInt($('#txtPrzMaxPrimeira').val())) {
      msgAlerta('Prazo da primeira parcela não pode ser maior que o máximo definido na condição de pagamento.', () => {
        $('#txtPrazoPrimeiraParc').focus()
      }, null, null, null, false, true)
      $('#txtPrazoPrimeiraParc').val(0)
    }

    calculaPrazoMedio()
  })

  $('#txtValorEntrada').on('blur', function () {
    const valorTot = parseFloat($('#txtValorFinanceiro').text().replace(/\./g, '').replace(',', '.'));
    if ((parseFloat($('#txtPercEntrada').val()) > 0) && ((parseFloat($('#txtValorEntrada').val()) <= 0) || (parseFloat(valorTot) <= 0))) {
      msgAlerta('Valor de entrada ou valor total do orçamento zerado, impossível continuar.', () => { }, null, null, null, false, true)
      $('#txtValorEntrada').val(0)
      return
    }

    if (parseFloat($('#txtValorEntrada').val()) > parseFloat(valorTot)) {
      msgAlerta('Valor de entrada maior que o valor total do orçamento, impossível continuar.', () => { }, null, null, null, false, true)
      $('#txtValorEntrada').val(0)
      return
    }

    if (parseFloat($('#txtValorEntrada').val()) > 0) {
      const perc = roundTo((parseFloat($('#txtValorEntrada').val()) / parseFloat(valorTot)) * 100, 2)
      if (parseFloat(perc.toFixed(2)) < parseFloat(parseFloat($('#txtPercEntrada').val()).toFixed(2))) {
        $('#txtValorEntrada').val(0)
        msgAlerta('Valor de entrada não pode ser menor que o definido na condição de pagamento.', () => { }, null, null, null, false, true)
        $('#txtValorEntrada').val(0)
        return
      }
    }

    calculaPrazoMedio()
  })

  $('#txtIntervaloParc').on('blur', function () {
    if (parseInt($(this).val()) > parseInt($('#txtIntervaloParcelas').val())) {
      msgAlerta('Intervalo entre as parcelas não pode ser maior que o máximo definido na condição de pagamento.', () => {
        $('#txtIntervaloParc').focus()
      }, null, null, null, false, true)
      $('#txtIntervaloParc').val(0)
    }

    calculaPrazoMedio()
  })

  function validacoesGerarParcelas() {
    const valorTot = parseFloat($('#txtValorFinanceiro').text().replace(/\./g, '').replace(',', '.'));
    if (parseInt($('#txtPrazoMedioCalc').val()) > parseInt($('#txtPrzMedio').val())) {
      throw new Error('Prazo médio calculado não pode ser maior que o máximo definido na condição de pagamento.')
    }

    if ((parseFloat($('#txtPercEntrada').val()) > 0) && ((parseFloat($('#txtValorEntrada').val()) <= 0) || (parseFloat(valorTot) <= 0))) {
      throw new Error('Valor de entrada ou valor total do orçamento zerado, impossível continuar.')
    }

    if (parseFloat($('#txtValorEntrada').val()) > 0) {
      const perc = roundTo((parseFloat($('#txtValorEntrada').val()) / parseFloat(valorTot)) * 100, 2)
      if (parseFloat(perc.toFixed(2)) < parseFloat(parseFloat($('#txtPercEntrada').val()).toFixed(2))) {
        $('#txtValorEntrada').val(0)
        throw new Error('Valor de entrada não pode ser menor que o definido na condição de pagamento.')
      }
    }

    if (parseFloat($('#txtValorEntrada').val()) == 0 && parseFloat($('#txtMaxParcelas').val()) == 0) {
      throw new Error('O Número máximo de parcelas não pode ser 0. Favor Verificar!')
    }
  }

  $('#btnGerarParcelas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      validacoesGerarParcelas()
      await gerarParcelas()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function gerarParcelas() {
    $.LoadingOverlay('show')
    try {
      await simulaFinanceiro()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function simulaFinanceiro() {
    const numParcelas = parseInt($('#txtNParcelas').val()) || 0;
    const primeiraParcela = parseInt($('#txtPrazoPrimeiraParc').val()) || 0;
    const intervalo = parseInt($('#txtIntervaloParc').val()) || 0;
    const entrada = parseFloat($('#txtValorEntrada').val()) || 0;
    const valorTot = parseFloat($('#txtValorFinanceiro').text().replace(/\./g, '').replace(',', '.')) || 0;

    const inicial = entrada > 0 ? 0 : 1;
    let dias = entrada > 0 ? 0 : primeiraParcela;
    let vParcelas = 0;

    $("#tabelaDuplicatas").DataTable().rows().remove().draw(false);

    for (let i = inicial; i <= numParcelas; i++) {
      let valorParcela;

      if (i == 0) {
        valorParcela = entrada;
      } else if (i == numParcelas) {
        valorParcela = ((valorTot - entrada) - vParcelas).toFixed(2);
        vParcelas += parseFloat(valorParcela);
      } else {
        valorParcela = ((valorTot - entrada) / numParcelas).toFixed(2);
        vParcelas += parseFloat(valorParcela);
      }


      $("#tabelaDuplicatas").DataTable().row.add({
        PARCELA: i,
        VENCIMENTO: formatDateDup(new Date(Date.now() + dias * 24 * 60 * 60 * 1000)),
        VALOR: parseFloat(valorParcela).toFixed(2)
      }).draw(false);

      dias += intervalo;
    }
  }

  function formatDateDup(date) {
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    return `${year}-${month}-${day}`;
  }

  function campoDesconto(desc1, desc2, desc3, desc4, desc5) {
    let sDescontos = '';

    function formatDesconto(valor) {
      if (valor > 0) {
        return valor.toFixed(2).padStart(5, ' ');
      } else {
        return ''
      }
    }

    sDescontos += formatDesconto(desc1);
    sDescontos += formatDesconto(desc2);
    sDescontos += formatDesconto(desc3);
    sDescontos += formatDesconto(desc4);
    sDescontos += formatDesconto(desc5);

    return sDescontos;
  }

  async function preencheTabelaIndices(markup) {
    $.LoadingOverlay('show')
    try {
      const comissaoRec = parseFloat($('#txtComissaoRec').val()) || 0;
      const comissaoFat = parseFloat($('#txtComissaoFat').val()) || 0;
      const comissao = parseFloat($('#txtComissao').val()) || 0;

      const comissoes = comissaoRec + comissaoFat + comissao;

      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaindices?', `MARKUP=${markup}&COMISSAO=${comissoes}`, '', 36000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      jsonStr.map(item => {
        $('#tabelaIndices').DataTable().row.add({
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          INDICE: item.INDICE,
        }).draw(false);
      });

      let total = 0
      $('#tabelaIndices').DataTable().data().toArray().reduce((acc, item) => {
        const indice = parseFloat(item.INDICE) || 0
        total = parseFloat(total) + indice
        return total
      }, 0);

      total = (100 - total) / 100

      $('#txtIndiceTotal').val(total);

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }

  }

});
