$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtNumero',
            popover: {
                title: 'Número',
                description: 'Este campo é preenchido automaticamente.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o lançaamento.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    const queryString = window.location.href;
    const parametros = queryString.split('/');
    const lancRep = parametros[parametros.length - 1];
    adicionaPesquisa()

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('LANCREP', getCookie('usuario'), lancRep);
        window.location.href = `${BASE_URI}/lancrep`;
    });

    if (lancRep != '' && lancRep != 'create') {
        try {
            $.LoadingOverlay("show");
            try {
                const url = "/sisplan/cadastros/v1/lancrep?";
                const response = await requisicao("GET", url, `NUMERO=${lancRep}`, "", 36000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json()
                if (response.status != 200) {
                    throw new Error(jsonStr['RESULT'][0].mensagem);
                }
                const data = jsonStr[0]

                $('#txtNumero').val(data.NUMERO)
                $('#txtLancamento').val(data.LANCAMENTO)
                $('#txtFatura').val(data.FATURA)
                $('#txtData').val(data.DT_EMISSAO)
                $('#txtDataPagto').val(data.DT_PAGO)
                $('#txtValPed').val(data.VAL_PED)
                $('#txtPercPed').val(data.PERC_PED)
                $('#txtObs').val(data.DESCRICAO)
                $('#txtValor').val(Math.abs(data.VALOR))
                $('#txtPercCom').val(data.PERC_COM)

                if (data.OPERACAO == 'C') {
                    $('#rdCredito').prop('checked', true)
                } else {
                    $('#rdDebito').prop('checked', true)
                }
                $('#cbImpRenda').prop('checked', data.CONSIDERA_IR == 'S')


                insereValor('#txtRepresentante', data.CODREP, data.NOME_REP)
                insereValor('#txtPedido', data.PEDIDO, { tabela: 'PEDIDO', campoBusca: 'CODCLI', campoWhere: 'NUMERO', valorWhere: data.PEDIDO })
                insereValor('#txtColecao', data.COLECAO, data.DESC_COLECAO)
                insereValor('#txtHistorico', data.HISTORICO, data.DESC_HISTORICO)
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados do tipo: ${error}`);
            }
        } finally {
            $('#txtTipo').attr('readonly', true);
            $.LoadingOverlay('hide');
        }
    }

    $('#txtPedido').on('blur', async function () {
        if ($(this).val() == '') {
            $('#txtValPed').prop('disabled', false);
            return
        }
        $.LoadingOverlay('show')
        try {
            $('#txtValPed').prop('disabled', true);
            const pesquisa = {
                tabela: 'PED_ITEN',
                campoSubSelect: ['SUM(VALOR)'],
                camposSelect: ['COALESCE(COALESCE(PED_ITEN.PRECO,0)*PED_ITEN.QTDE,0) AS VALOR'],
                where: [`NUMERO = '${pegaChave('#txtPedido')}'`]
            }

            const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (json.length > 0) {
                const valor = json.map(item => { return item.VALOR }).reduce((a, b) => a + b)
                $('#txtValPed').val(parseFloat(valor.toFixed(2)));
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnLimpaPedido').on('click', function (){
        $('#txtValPed').prop('disabled', false);
    })

    $('#txtPercPed').on('change', function () {
        if (parseFloat($(this).val()) > 0){
            const percPed = parseFloat($(this).val())
            const valPed = parseFloat($('#txtValPed').val())
            const valorTotal = (valPed*(percPed/100))

            $('#txtValor').val(parseFloat(valorTotal.toFixed(2)))
        }
    })

    function validacoesGravar() {
        if ($('#txtValor').val() == '') {
            throw new Error('Valor não informado. Impossível gravar!')
        }
        if ($('#txtRepresentante').val() == '') {
            throw new Error('Representante não informado. Impossível gravar!')
        }
        if ($('#txtPercCom').val() == '') {
            throw new Error('Percentual de comissão não informado. Impossível gravar!')
        }
    }

    $("#gravar").on('click', async function () {
        $.LoadingOverlay("show");
        try {
            validacoesGravar()

            const lancamento = $('#txtLancamento').val() == '' ? await retornaProximoLancamento() : $('#txtLancamento').val()
            const numero = lancRep == 'create' ? await RetornaProximo('LANC_REP', 'LANC_REP', 'NUMERO', 7) : lancRep

            const lancRepObj = {
                NUMERO: numero,
                FATURA: $('#txtFatura').val(),
                DOCTO: lancamento,
                LANCAMENTO: lancamento,
                DT_EMISSAO: pegaValor('#txtData'),
                DT_VENCTO: pegaValor('#txtData'),
                DT_FLUXO: pegaValor('#txtData'),
                DT_LAN: pegaValor('#txtData'),
                VAL_PED: parseFloat($('#txtValPed').val()),
                PERC_PED: parseFloat($('#txtPercPed').val()),
                DESCRICAO: $('#txtObs').val(),
                VALOR: parseFloat($('#txtValor').val()),
                OPERACAO: $('#rdCredito').is(':checked') ? 'C' : 'D',
                CONSIDERAR_IR: $('#cbImpRenda').is(':checked') ? 'S' : 'N',
                PEDIDO: pegaChave('#txtPedido'),
                COLECAO: pegaChave('#txtColecao'),
                HISTORICO: pegaChave('#txtHistorico'),
                PAGO: 'N',
                TIPO: 'MAN',
                EMP_ID: getCookie('emp_id'),
            };

            const codrep = pegaChave('#txtRepresentante')
            const com1 = $('#txtPercCom').val().replace('.', ',')

            let response = await requisicao('POST', '/Sisplan/Cadastros/v1/lancrep?', `CODREP=${codrep}&NUMERO=${numero}&COM1=${com1}`, encodeURIComponent(JSON.stringify(lancRepObj)));

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success(
                `Cadastro efetuado com sucesso!`,
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/lancrep`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });

        } catch (error) {
            console.error(error);
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    function adicionaPesquisa() {
        componenteFiltro('representante', false, false)
        componenteFiltro('pedido', false, false)
        componenteFiltro('colecao', false, false)
        componenteFiltro('historico', false, false)

        $('.camposValor').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });
    }
});