$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: '#txtCodigo',
        popover: {
          title: 'Código',
          description: "Aqui, adicionamos o código do Função.",
          position: 'top'
        }
      },
      {
        element: '#txtDescricao',
        popover: {
          title: 'Descricao',
          description: 'Aqui, adicionamos o descrição da Função.',
          position: 'top'
        }
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: '#gravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para gravar o cadastro da função.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  async function aplicaMascara() {
    $('.campoValor').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });

    $('.campoInteger').on('input', function (e) {
      let valorAtual = $(this).val();

      let novoValor = valorAtual.replace(/\D/g, '');

      if (novoValor != valorAtual) {
        $(this).val(novoValor);
      }
    });
  }

  async function aplicaCalculoPorcentagem() {
    function calcularValor(inputPerc, inputCalc, valorBase) {
      let percentual = parseFloat($(inputPerc).val()) || 0;
      let resultado = (valorBase * percentual) / 500;
      $(inputCalc).val(resultado.toFixed(2));
    }

    let valorBase = 1000;

    $('.calculoPorcentagem').on('input', function () {
      if (this.id === 'txtPercAvalA') {
        calcularValor('#txtPercAvalA', '#txtMostraCalcA', valorBase);
      } else if (this.id === 'txtPercAvalB') {
        calcularValor('#txtPercAvalB', '#txtMostraCalcB', valorBase);
      } else if (this.id === 'txtPercAvalC') {
        calcularValor('#txtPercAvalC', '#txtMostraCalcC', valorBase);
      } else if (this.id === 'txtPercAvalD') {
        calcularValor('#txtPercAvalD', '#txtMostraCalcD', valorBase);
      }
    });
  }

  await aplicaMascara()
  await aplicaCalculoPorcentagem()

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let funcao = parametros[parametros.length - 1];

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('FUNCAO', getCookie('usuario'), funcao);
    window.location.href = `${BASE_URI}/funcao`;
  });

  $('#txtCodigo').on('blur', async function () {
    if ($(this).val() != '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      const newCodigo = await RetornaProximo('CODIGO', 'FUNCAO', 'CODIGO', 5)

      $(this).val(newCodigo)
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  if (funcao != '' && funcao != 'create') {

    if (await liberarRegistro('FUNCAO', funcao) == false) {
      window.location.href = '../funcao';
    } else {

      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"FUNCAO", 
                    "camposSelect":["CODIGO", "DESCRICAO", "VAL_PROD", "VAL_AVAL", "PREMIO_PROD", "PREMIO_AVAL", "DESC_FALTA", "VAL_PERC" , "PERC_AVAL_A", "PERC_AVAL_B", "PERC_AVAL_C", "PERC_AVAL_D"], 
                    "where": ["CODIGO = '${funcao}'"]}`, null);

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
          $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
          $('#txtValProd').val(jsonStr.RESULT[0][0].VAL_PROD);
          $('#txtValAval').val(jsonStr.RESULT[0][0].VAL_AVAL);
          $('#txtPremioProd').val(jsonStr.RESULT[0][0].PREMIO_PROD);
          $('#txtPremioAval').val(jsonStr.RESULT[0][0].PREMIO_AVAL);
          $('#txtDescFalta').val(jsonStr.RESULT[0][0].DESC_FALTA);
          $('#txtValPerc').val(jsonStr.RESULT[0][0].VAL_PERC);
          $('#txtPercAvalA').val(jsonStr.RESULT[0][0].PERC_AVAL_A);
          $('#txtPercAvalB').val(jsonStr.RESULT[0][0].PERC_AVAL_B);
          $('#txtPercAvalC').val(jsonStr.RESULT[0][0].PERC_AVAL_C);
          $('#txtPercAvalD').val(jsonStr.RESULT[0][0].PERC_AVAL_D);

          $('.campoValor').each(function () {
            let valorAtual = $(this).val();
            $(this).val(valorAtual).trigger('mask');
          });

          $('#txtPercAvalA, #txtPercAvalB, #txtPercAvalC, #txtPercAvalD').trigger('input');

        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados da Função: ${error}`);
        }
      } finally {
        $('#txtCodigo').attr('readonly', true);
        $.LoadingOverlay('hide');
      }
    }
  }

  $("#gravar").click(
    async function () {
      try {
        $.LoadingOverlay("show");

        const codigo = $('#txtCodigo').val()
        const descricao = $('#txtDescricao').val()

        if (codigo == '') {
          throw new Error('Código do Cilindro não informado, impossível Continuar!')
        }

        if (descricao == '') {
          throw new Error('Descrição do Cilindro não informado, impossível Continuar!')
        }

        let funcao = {};

        funcao.Codigo = codigo
        funcao.Descricao = descricao
        funcao.ValProd = $('#txtValProd').val();
        funcao.ValAval = $('#txtValAval').val();
        funcao.PremioProd = $('#txtPremioProd').val();
        funcao.PremioAval = $('#txtPremioAval').val();
        funcao.DescFalta = $('#txtDescFalta').val();
        funcao.ValPerc = $('#txtValPerc').val();
        funcao.PercAvalA = $('#txtPercAvalA').val();
        funcao.PercAvalB = $('#txtPercAvalB').val();
        funcao.PercAvalC = $('#txtPercAvalC').val();
        funcao.PercAvalD = $('#txtPercAvalD').val();

        let response = await requisicao('POST', '/Sisplan/Cadastros/v1/funcao?', `JSON=${encodeURIComponent(JSON.stringify(funcao))}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        };

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr.success(
          `Cadastro efetuado com sucesso!`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/funcao`;
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });

      } catch (error) {
        console.error(error);
        msgAlerta(error.message)
        $.LoadingOverlay("hide");
      }
    });
});
