$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });
        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para realizar a consulta.',
                position: 'bottom'
            }
        },
        {
            element: '#txtNumeroAP',
            popover: {
                title: 'Campo Obrigatório',
                description: 'Esse é um campo obrigatório, preencha com um número da AP que deseja estornar.',
                position: 'top'
            }
        },
        {
            element: '#btnConsultar',
            popover: {
                title: 'Botão Consulta',
                description: 'Clique aqui para realizar a consulta.',
                position: 'left'
            }
        },
        {
            element: '#btnReabrirPgto',
            popover: {
                title: 'Botão Reabrir Pagamento',
                description: 'Clique aqui para reabrir o pagamento.',
                position: 'right'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    //Pesquisas

    $('#txtPeriodoDe').autocompleta(
        1,
        `JSON={ 
            "tabela":"TABPRZ", 
            "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnPeriodoDe').pesquisa(
        '#txtPeriodoDe',
        'PRAZO',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO", "DT_INICIO", "DT_FIM"], "where": null}',
        'Pesquisa de Prazo',
        'TABPRZ'
    );

    $('#btnLimpaPeriodoDe').on('click', function () {
        $('#txtPeriodoDe').val('');
    });

    $('#txtPeriodoAte').autocompleta(
        1,
        `JSON={ 
            "tabela":"TABPRZ", 
            "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnPeriodoAte').pesquisa(
        '#txtPeriodoAte',
        'PRAZO',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO", "DT_INICIO", "DT_FIM"], "where": null}',
        'Pesquisa de Prazo',
        'TABPRZ'
    );

    $('#btnLimpaPeriodoAte').on('click', function () {
        $('#txtPeriodoAte').val('');
    });

    $('#txtTipo').autocompleta(
        1,
        `JSON={ 
            "tabela":"TIPO", 
            "camposSelect":["ID CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnTipo').pesquisa(
        '#txtTipo',
        'ID',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO", "camposSelect":["ID", "DESCRICAO", "AREA"], "where": null}',
        'Pesquisa de Tipo',
        'TIPO'
    );

    $('#btnLimpaTipo').on('click', function () {
        $('#txtTipo').val('');
    });


    $('#txtPedido').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"PEDIDO", 
            "camposSelect":["PEDIDO.NUMERO", "ENTIDADE.NOME"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
            "where": null}
            `,
        "NUMERO",
        "NOME");

    $("#btnPedido").pesquisa_serversideSel(
        "#txtPedido",
        `{
            "tabela":"PEDIDO", 
            "camposSelect":["PEDIDO.NUMERO", "ENTIDADE.NOME", "PEDIDO.CODCLI", "PEDIDO.DT_FATURA", "PEDIDO.DT_EMISSAO", "PEDIDO.COLECAO", "PEDIDO.DT_SAIDA", "PEDIDO.ENTREGA",  "PEDIDO.TIPO"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
            "where": null
        }`,
        "Pesquisa de Pedido");

    $('#btnLimpaPedido').on('click', function () {
        $('#txtPedido').empty().trigger('change');
    });

    $('#txtSetor').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"CADFLUXO", 
            "camposSelect":["CODIGO", "DESCRICAO"], 
            "where": null}
            `,
        "CODIGO",
        "DESCRICAO");

    $("#btnSetor").pesquisa_serversideSel(
        "#txtSetor",
        `{
            "tabela":"CADFLUXO", 
            "camposSelect":["CODIGO", "DESCRICAO", "ORDEM", "CUSTO"], 
            "where": null
        }`,
        "Pesquisa de Setor");

    $('#btnLimpaSetor').on('click', function () {
        $('#txtSetor').empty().trigger('change');
    });

    $('#txtFaccao').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"ENTIDADE", 
            "camposSelect":["CODCLI", "NOME"], 
            "where": null}
            `,
        "CODCLI",
        "NOME");

    $("#btnFaccao").pesquisa_serversideSel(
        "#txtFaccao",
        `{
            "tabela":"ENTIDADE", 
            "camposSelect":["CODCLI", "NOME", "CNPJ", "FANTASIA"], 
            "where": null
        }`,
        "Pesquisa de Facção");

    $('#btnLimpaFaccao').on('click', function () {
        $('#txtFaccao').empty().trigger('change');
    });

    $('#txtOF').pesquisa_variosServerside(
        2,
        `{ 
            "tabela":"OF1", 
            "camposSelect":["OF1.NUMERO", "OF1.PERIODO"], 
            "where": null,
            "groupby": ["OF1.NUMERO", "OF1.PERIODO"]
        }`,
        "NUMERO",
        "PERIODO");

    $("#btnOF").pesquisa_serversideSel(
        "#txtOF",
        `{
            "tabela":"OF1", 
            "camposSelect":["OF1.NUMERO", "OF1.PERIODO", "PRODUTO.CODIGO", "PRODUTO.DESCRICAO"], 
            "leftJoin": [{ "TABELA": "PRODUTO", "CONDICAO": "PRODUTO.CODIGO = OF1.CODIGO"}],
            "where": null,
            "groupby": ["OF1.NUMERO", "PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "OF1.PERIODO"]
        }`,
        "Pesquisa de OF",);

    $('#btnLimpaOF').on('click', function () {
        $('#txtOF').empty().trigger('change');
    });

    function botaoSelecionarGrid() {
        return (
            '<div class="form-check pl-0">' +
            '<div class="icheck-primary"><input type="checkbox" class="campoCheck" value""><label></label></div>' +
            "</div>"
        );
    }

    async function consultaEstornoFaccao() {
        // event.preventDefault();
        if (!$('#txtNumeroAP').val()) {
            msgAlerta('Insira o número de AP para consulta.');
            return
        }

        $.LoadingOverlay("show");

        if ($.fn.DataTable.isDataTable('#tabelaEstorno')) {
            $("#tabelaEstorno").DataTable().destroy();
            $("#tabelaEstorno").empty();
        }

        try {
            const params = await buscaDadosCampos();
            const response = await requisicao('GET', `/sisplan/facpreco/v1/facestornopag?`, `JSON=${JSON.stringify(params)}`, '', 90000);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();

            if (jsonStr[1].length > 0 || jsonStr[0].length > 0) {
                let dataSetCols = [
                    {
                        title: `<div class="icheck-primary" for="check_todos" id="cbTodos">
                                <input class="form-check-input" type="checkbox" id="check_todos">
                                <label for="check_todos" value="option5" data-toggle="tooltip" data-placement="top" title="Selecionar todos os registros"></label>
                            </div>`,
                        data: "SEL"
                    },
                    { title: "Lanc. Manual", data: "LANCTO_MANUAL" },
                    { title: "Fac. Cód. Cli.", data: "FAC_CODCLI" },
                    { title: "Fac. Data S.", data: "FAC_DT_S" },
                    { title: "Fac. Data Lanc.", data: "FAC_DT_LAN" },
                    { title: "Fac. Data Prev.", data: "FAC_DT_PREV" },
                    { title: "Fac. Número", data: "FAC_NUMERO" },
                    { title: "Fac. OP", data: "FAC_OP" },
                    { title: "Fac. Desc. Setor", data: "FAC_DESCSETOR" },
                    { title: "Fac. Preço", data: "FAC_PRECO" },
                    { title: "Fac. Qtde Orig.", data: "FAC_QT_ORIG" },
                    { title: "Fac. Obs.", data: "FAC_OBS" },
                    { title: "Fac. Ficha", data: "FAC_FICHA" },
                    { title: "Fac. Qtde", data: "FAC_QUANT" },
                    { title: "Fac. Qtde 2", data: "FAC_QUANT_2" },
                    { title: "Fac. Qtde I", data: "FAC_QUANT_I" },
                    { title: "Fac. Qtde F", data: "FAC_QUANT_F" },
                    { title: "Fac. Valor", data: "FAC_VALOR" },
                    { title: "Unitário", data: "UNITARIO" },
                    { title: "Fac. Lanc.", data: "FAC_LANCTO" },
                    { title: "Fac. Unitário", data: "FAC_UNITARIO" },
                    { title: "Fac. Nota", data: "FAC_NOTA" },
                    { title: "Pago", data: "PAGO" },
                    { title: "Fac. Código", data: "FAC_CODIGO" },
                    { title: "Cód. Coleção", data: "COD_COLECAO" },
                    { title: "Desc. Coleção", data: "DESC_COLECAO" },
                    { title: "Fac. Grupo", data: "FAC_GRUPO" },
                    { title: "Desc. Grupo", data: "DESC_GRUPO" },
                    { title: "Fac. Pedido", data: "FAC_PEDIDO" },
                    { title: "Fac. Tam.", data: "FAC_TAM" },
                    { title: "Fac. Cor", data: "FAC_COR" },
                    { title: "Fac. Parte", data: "FAC_PARTE" },
                    { title: "Núm. AP", data: "NUM_AP" },
                    { title: "Fac. Desc. Parte", data: "FAC_DESCPARTE" },
                    { title: "Cor Parte", data: "COR_PARTE" },
                    { title: "Desc. Cor Parte", data: "DESC_COR_PARTE" },
                    { title: "Fac. Estoque", data: "FAC_ESTOQUE" },
                    { title: "Prod. Desc.", data: "PRODUTO_DESCRICAO" },
                    { title: "Prod. Unidade", data: "PRODUTO_UNIDADE" },
                    { title: "Largura", data: "LARGURA" },
                    { title: "Estimativa Mês", data: "ESTIMATIVA_MES" },
                    { title: "Etiqueta", data: "ETIQUETA" },
                    { title: "Desc. Etiqueta", data: "DES_ETIQUETA" },
                    { title: "Cód. FIS", data: "CODFIS" },
                    { title: "Desc. FIS", data: "DESC_FIS" },
                    { title: "Produto Uniconv", data: "PRODUTO_UNICONV" },
                    { title: "Nome Cliente", data: "CLIENTE_NOME" },
                    { title: "DDD Fone", data: "DDD_FONE" },
                    { title: "Fone Cliente", data: "CLIENTE_FONE" },
                    { title: "Fone Compl.", data: "FONE_COMPL" },
                    { title: "Observação", data: "OBSERVACAO" },
                    { title: "Bonificação", data: "BONIFICACAO" },
                    { title: "Fac. Desc. Cor", data: "FAC_DESCCOR" },
                    { title: "Pagamento", data: "DT_PAGTO" },
                    { title: "Mov.", data: "MOV" },
                    { title: "Identificador", data: "IDENTIFICADOR" },
                    { title: "OF Cód. Cli.", data: "OF_CODCLI" },
                    { title: "OF Cli. Nome", data: "OF_CLINOME" },
                    { title: "OF Pedido", data: "OF_PEDIDO" },
                    { title: "Período", data: "PERIODO" },
                    { title: "Fac. ID Ant.", data: "FAC_ID_ANT" },
                    { title: "DI", data: "DI" },
                    { title: "DF", data: "DF" },
                    { title: "Setor", data: "SETOR" },
                    { title: "PCP Qtde Orig.", data: "PCP_QTDE_ORIG" },
                    { title: "Qtde Tot. PCP", data: "QTDE_TOT_PCP" },
                    { title: "Tempo", data: "TEMPO" },
                    { title: "Tempo Total", data: "TEMPO_TOTAL" },
                    { title: "Mov. Ant.", data: "MOV_ANT" },
                    { title: "Fac. Núm. Ref.", data: "FAC_NUMERO_REF" },
                    { title: "Fac. OP Ref.", data: "FAC_OP_REF" },
                    { title: "Fac. Mov. Ref.", data: "FAC_MOV_REF" },
                    { title: "Reprocesso", data: "REPROCESSO" },
                    { title: "Qtde Orig. Mov. Ant.", data: "QT_ORIG_MOV_ANT" },
                    { title: "Ped. Cli.", data: "PED_CLI" },
                    { title: "ABVTEX", data: "ABVTEX" },
                    { title: "Mov. Ligação", data: "MOV_LIGACAO" },
                    { title: "Entrega", data: "ENTREGA" },
                    { title: "Dt. Orig. Entrega", data: "DT_ORIG_ENTREGA" },
                    { title: "Endereço", data: "ENDERECO" },
                    { title: "Num. End.", data: "NUM_END" },
                    { title: "Bairro", data: "BAIRRO" },
                    { title: "CEP", data: "CEP" },
                    { title: "Complemento", data: "COMPLEMENTO" },
                    { title: "Cidade", data: "CIDADE" },
                    { title: "Cód. UF", data: "COD_UF" },
                    { title: "CNPJ", data: "CNPJ" },
                    { title: "Funcionário", data: "FUNCIONARIO" },
                    { title: "Nome Funcionário", data: "NOME_FUNCIONARIO" },
                    { title: "Máquina", data: "MAQUINA" },
                    { title: "Desc. Máquina", data: "DESC_MAQUINA" },
                    { title: "Turno", data: "TURNO" },
                    { title: "Marca", data: "MARCA" },
                    { title: "Desc. Marca", data: "DESC_MARCA" },
                    { title: "Mês Ano", data: "MES_ANO" },
                    { title: "Perc.", data: "PERC" },
                    { title: "Código 2", data: "CODIGO2" },
                    { title: "Protótipo", data: "PROTOTIPO" },
                    { title: "Tam. Posição", data: "TAM_POSICAO" },
                    { title: "Cubagem", data: "CUBAGEM" },
                    { title: "Qtde", data: "QUANT" },
                    { title: "Linha", data: "LINHA" },
                    { title: "Obs. OF", data: "OBS_OF" },
                    { title: "Desc. Linha", data: "DESC_LINHA" },
                    { title: "Tipo OF", data: "TIPO_OF" },
                    { title: "Lanc. Pag.", data: "LANCTO_PAGAR" },
                    { title: "Valor", data: "VALOR" },
                    { title: "Val. Pag.", data: "VAL_PAG" },
                    { title: "Saldo", data: "SALDO" }
                ];

                let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
                if (colunasInvisiveis == null || colunasInvisiveis.acessoFacEstornoPag == undefined) {
                    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacEstornoPag: ['EMPRESA'] }));
                    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
                }

                let tabelaEstorno = $('#tabelaEstorno').DataTable({
                    paging: true,
                    filter: false,
                    searching: true,
                    info: true,
                    colReorder: false,
                    destroy: true,
                    lengthChange: true,
                    scrollX: true,
                    scrollY: '310px',
                    lengthMenu: [10, 25, 50, 100],
                    pageLength: 10,
                    processing: true,
                    "data": jsonStr[1],
                    "columns": dataSetCols,
                    columnDefs: [{
                        targets: [3, 4, 5, 53, 77, 78, 94],
                        render(data) {
                            const dateObject = new Date(data);
                            const dia = dateObject.getDate().toString().padStart(2, '0');
                            const mes = (dateObject.getMonth() + 1).toString().padStart(2, '0');
                            const ano = dateObject.getFullYear();
                            const dataFormatada = `${dia}/${mes}/${ano}`;
                            return dataFormatada;
                        },
                        targets: [0],
                        render: botaoSelecionarGrid
                    }]
                });

                $('#btnReabrirPgto').removeClass('d-none');

                $('#modal-filtros').modal('hide');

                $('#tabelaEstorno_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaEstorno_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const dados = $("#tabelaEstorno").DataTable().data().toArray();
                    await exportaCSV("", "", undefined, null, 'Relatório da aba acesso estorno de pagamento de terceiros', '', '', 999, false, false, dados);
                });

                $('#tabelaEstorno').DataTable().columns().every(function () {
                    if ((colunasInvisiveis.acessoFacEstornoPag).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                });

            } else {
                msgErro('Sem dados na consulta');
                return
            }
        } catch (error) {
            console.error(error)
            msgErro('Não foi possível fazer a consulta. Erro: ' + $(error));
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $("#tabelaEstorno").on("click", "td", function () {
        selecionarLinhaTabela("#tabelaEstorno", "campoCheck", this);
    });

    $(document).on('change', '#check_todos', function () {
        let isChecked = $('#check_todos').prop('checked');
        let table = $('#tabelaEstorno').DataTable();

        table.rows().every(function () {
            let row = $(this.node());
            row.find('.campoCheck').prop('checked', isChecked);

            if (isChecked) {
                row.addClass('selected');
            } else {
                row.removeClass('selected');
            }
        });
    });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaEstorno').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoFacEstornoPag ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["SEL"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoFacEstornoPag: novasColunas }));

            $('#tabelaEstorno').DataTable().columns().visible(true);

            $('#tabelaEstorno').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#btnConsultar').on('click', consultaEstornoFaccao);


    $('#btnReabrirPgto').on('click', async function () {
        estornoPagamento();
    })

    async function estornoPagamento() {
        let _url = `/Sisplan/facpreco/v1/facestornopag?`;
        let arrayLancamentos = [];

        try {
            $.LoadingOverlay("show");
            let tabelaEstornoSelected = $('#tabelaEstorno').DataTable().rows('.selected').data().toArray()

            for (let i = 0; i < tabelaEstornoSelected.length; i++) { 
                if (arrayLancamentos.filter((item) => item.lancamentoPagar === tabelaEstornoSelected[i].LANCTO_PAGAR).length <= 0){
                    let Tabela = {
                        lancamentoPagar: tabelaEstornoSelected[i].LANCTO_PAGAR,
                        numeroFaccao: tabelaEstornoSelected[i].FAC_NUMERO,
                        numeroAp: $('#txtNumeroAP').val()
                    };
                    arrayLancamentos.push(Tabela);
                } else {
                    continue
                }
            }

            const body = {
                Tabela: arrayLancamentos
            }

            let response = await requisicao('POST', _url, '', JSON.stringify(body), 60000)

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(
                    'Não é possível fazer o estorno dessa AP, pois a mesma possui baixas!',
                    async function () {
                        consultaEstornoFaccao()
                    },
                    async function () {
                        consultaEstornoFaccao()
                    });

                return
            }

            toastr.success(
                'Estorno efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: async function () {
                    consultaEstornoFaccao()
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });;
            $.LoadingOverlay("hide");
            return jsonStr;
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro(error);
        }
    };



    async function buscaDadosCampos() {
        inputsTela = {
            retornoDe: $('#txtRetornoDe').val() != '' ? formataDataBonita($('#txtRetornoDe').val()) : '01/01/1200',
            retornoAte: $('#txtRetornoAte').val() != '' ? formataDataBonita($('#txtRetornoAte').val()) : '31/12/2500',
            pagamentoDe: $('#txtPagamentoDe').val() != '' ? formataDataBonita($('#txtPagamentoDe').val()) : '01/01/1200',
            pagamentoAte: $('#txtPagamentoAte').val() != '' ? formataDataBonita($('#txtPagamentoAte').val()) : '31/12/2500',
            envioDe: $('#txtEnvioDe').val() != '' ? formataDataBonita($('#txtEnvioDe').val()) : '01/01/1200',
            envioAte: $('#txtEnvioAte').val() != '' ? formataDataBonita($('#txtEnvioAte').val()) : '31/12/2500',
            periodoDe: pegaChave('#txtPeriodoDe'),
            periodoAte: pegaChave('#txtPeriodoAte'),
            numeroAP: $('#txtNumeroAP').val(),
            pedido: $('#txtPedido').val() != '' ? await formataListas($('#txtPedido').val().toString()) : '',
            setor: $('#txtSetor').val() != '' ? await formataListas($('#txtSetor').val().toString()) : '',
            consideraFaccao: $('#cbConsideraFaccao').is(':checked') ? '0' : '1',
            faccao: $('#txtFaccao').val() != '' ? await formataListas($('#txtFaccao').val().toString()) : '',
            consideraOF: $('#cbConsideraOF').is(':checked') ? '0' : '1',
            offaccao: $('#txtOF').val() != '' ? await formataListas($('#txtOF').val().toString()) : '',
            tipo: pegaChave('#txtTipo')
        }
        return inputsTela;
    }

});