$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma ordem de compra.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimirIndividual',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as ordens de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaOrdemCompra',
        popover: {
          title: 'Tabela Ordem Compra',
          description: 'Aqui estão os dados das ordens de compra cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  /////COLUNAS INVISIVEIS
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.tabelaConsignado == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaConsignado: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.tabelaItens == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaItens: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.tabelaAcerto == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaAcerto: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      if (localStorage.getItem('tabelaConsignado') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaConsignado: novasColunas }))
        $('#tabelaConsignado').DataTable().columns().visible(true);
        $('#tabelaConsignado').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelaItens') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaItens: novasColunas }))
        $('#tabelaItens').DataTable().columns().visible(true);
        $('#tabelaItens').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelaAcerto') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaAcerto: novasColunas }))
        $('#tabelaAcerto').DataTable().columns().visible(true);
        $('#tabelaAcerto').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('tabelaConsignado') == 'true') {
      $('#tabelaConsignado').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.tabelaConsignado ?? [], [])
    } else if (localStorage.getItem('tabelaItens') == 'true') {
      $('#tabelaItens').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.tabelaItens ?? [], [])
    } else if (localStorage.getItem('tabelaAcerto') == 'true') {
      $('#tabelaAcerto').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.tabelaAcerto ?? [], [])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('tabelaConsignado')
    localStorage.removeItem('tabelaItens')
    localStorage.removeItem('tabelaAcerto')
  })

  const formataValor = (valor) => new Intl.NumberFormat('pt-BR', {
    minimumFractionDigits: 2,
    maximumFractionDigits: 2,
  }).format(valor);

  // await setarDataAtual('dtIni')
  const date = new Date();
  const firstDay = new Date(date.getFullYear(), 0, 1);//ta setando a data de inicio sempre pro primeiro dia do ano, melhor pra consultar em larga escala e não quebrar o datatable
  $('#dtIni').val(formataData(firstDay));
  await setarDataAtual('dtFim')

  const columnsConferencia = [
    { "data": "codigo", "title": "Código" },
    { "data": "descricao", "title": "Descrição" },
    { "data": "cor", "title": "Cor" },
    { "data": "tamanho", "title": "Tamanho" },
    { "data": "quantidade", "title": "Quantidade" },
    { "data": "quantidadeVenda", "title": "Quantidade de Venda" },
    { "data": "tipo", "title": "Tipo" },
    { "data": "tabelaPreco", "title": "Tabela de Preço" },
    { "data": "preco", "title": "Preço" },
    { "data": "precoTotal", "title": "Preço Total" },
    { "data": "desconto", "title": "Desconto" },
    { "data": "barra", "title": "Barra" },
    { "data": "descricaoCor", "title": "Desc. Cor", "visible": false },
  ]

  const columnsGridPrincipal = [
    { "data": "id", "title": "ID" },
    { "data": "codcli", "title": "Cliente" },
    { "data": "nome", "title": "Nome Cliente" },
    { "data": "data", "title": "Data" },
    { "data": "dataAcerto", "title": "Data de Acerto" },
    { "data": "situacao", "title": "Situação" },
    { "data": "descricaoSituacao", "title": "Desc. Situação" },
    { "data": "status", "title": "Status" },
    { "data": "descricaoStatus", "title": "Desc. Status" },
    { "data": "deposito", "title": "Depósito" },
    { "data": "depositoEnt", "title": "Deposito Entrada" },
    { "data": "codrep", "title": "Vendedor" },
    { "data": "nomeRepresentante", "title": "Nome Vendedor" },
    { "data": "tabelaPreco", "title": "Tabela de Preço" },
    { "data": "valorMinimo", "title": "Valor Mínimo" },
    { "data": "tipo", "title": "Tipo" },
    { "data": "descricaoTipo", "title": "Desc. Tipo" },
    { "data": "dias", "title": "Dias" },
    { "data": "quantidade", "title": "Quantidade" },
    { "data": "valor", "title": "Valor" },
    { "data": "codven", "title": "CodVen" },
    { "data": "dataEmissao", "title": "Data de Emissão" },
    { "data": "quantidadeExp", "title": "Quantidade Expedida" },
    { "data": "quanitdadeFat", "title": "Quantidade Faturada" },
    { "data": "quantidadeDev", "title": "Quantidade Devolvida" },
    { "data": "quantidadeFatDev", "title": "Quantidade FatDev" },
  ]

  const columnsGridItens = [
    { "data": "codigo", "title": "Código" },
    { "data": "descricao", "title": "Descrição" },
    { "data": "cor", "title": "Cor" },
    { "data": "descricaoCor", "title": "Desc. Cor" },
    { "data": "tamanho", "title": "Tamanho" },
    { "data": "quantidade", "title": "Quantidade" },
    { "data": "preco", "title": "Desc. Preço" },
    { "data": "precoTotal", "title": "Preço Total" },
    { "data": "quantidadeExp", "title": "Quantidade Expedida" },
    { "data": "quantidadeFat", "title": "Quantidade Faturada" },
    { "data": "quantidadeDev", "title": "Quantidade Devolvida" },
    { "data": "quantidadeFatDev", "title": "Quantidade FatDev" },
    { "data": "data", "title": "Data" },
    { "data": "dataAcerto", "title": "Data de Acerto" },
    { "data": "situacao", "title": "Situação" },
    { "data": "descricaoSituacao", "title": "Desc. Situação" },
    { "data": "status", "title": "Status" },
    { "data": "descricaoStatus", "title": "Desc. Status" },
    { "data": "tipo", "title": "Tipo" },
    { "data": "descricaoTipo", "title": "Desc. Tipo" },
    { "data": "deposito", "title": "Depósito" },
    { "data": "tabelaPreco", "title": "Tabela de Preço" },
    { "data": "codrep", "title": "Vendedor" },
    { "data": "precoLiquido", "title": "Preço Líquido" },
  ]

  const columnsGridAcerto = [
    { "data": "codigo", "title": "Código" },
    { "data": "descricao", "title": "Descrição" },
    { "data": "cor", "title": "Cor" },
    { "data": "descricaoCor", "title": "Desc. Cor" },
    { "data": "tamanho", "title": "Tamanho" },
    { "data": "preco", "title": "Preço" },
    { "data": "tabelaPreco", "title": "Tabela de Preço" },
    { "data": "quantidade", "title": "Quantidade" },
    { "data": "barra28", "title": "Barra28" },
  ]

  criaDataTablePadrao('#tabelaConferencia', false, false, false, false, true, false, false);

  $("#tabelaConsignado").DataTable({
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    columns: columnsGridPrincipal,
    data: []
  });

  $("#tabelaItens").DataTable({
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    columns: columnsGridItens,
    data: []
  });

  $("#tabelaAcerto").DataTable({
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    columns: columnsGridAcerto,
    data: []
  });

  const permissaoUsuarioLogado = await permissaoAcessos("CONSIGNADO");

  addFuncoesBotoes();
  await buscaGridPrincipal();

  $('#btnConsultar').on('click', async function () {
    $('#txtQuantidadeSaida').val('0')
    $('#txtValorSaida').val('0')
    $('#txtQuantidadePendente').val('0')
    $('#txtQuantidadeDevolvida').val('0')
    $('#txtValorDevolvido').val('0')
    $('#txtQuantidadeAcerto').val('0')
    $('#txtValorPendente').val('0')
    $('#txtTotalAcerto').val('0')
    $('#txtPercAcerto').val('0')
    $('#txtQuantidadeTotal').val('0')
    $('#txtValorTotal').val('0')
    $('#modal-filtros').modal('hide');
    await buscaGridPrincipal();
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "consignado/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaConsignado').on('click', '#btnEditar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaConsignado').DataTable().row($(this).parents('tr')).data();
      await senhaSupervisor('Para conseguir editar um consignado é necessário informar a senha de supervisor',
        async () => window.location.href = `consignado/${data.id}`
      )
      // else {
      //   msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      // }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  const itensConsignadosProcessados = async (ids) => {
    const pesquisa = {
      tabela: 'VEN_CONSIG_ITENS',
      leftJoin: [{ tabela: 'VEN_CONSIG', condicao: 'VEN_CONSIG.ID = VEN_CONSIG_ITENS.ID_VEN_CONSIG' }],
      camposSelect: ['*'],
      where: [`ID_VEN_CONSIG IN (${ids})`],
    }

    return await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
  }

  async function retornaJsonVenda() {
    const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;

    const consignado = $('#tabelaConsignado').DataTable().data();

    const capa = {
      DEBITADUPLICATAS: false,
      VALOR_FRETE: '0',
      VENDACUPOM: false,
      VENDA_TIPO: '2',
      ACRES: '0',
      CODCLI: consignado[0].codcli,
      CODREP: consignado[0].codrep,
      CODREP2: '',
      CODVEN: '',
      CONDICAO: [],
      DATA: dtAtual,
      DESCONTO: 0,
      DEVOLUCAO: false,
      DT_ORIG: dtAtual,
      FECHADA: false,
      HR_VENDA: dtAtual,
      LANCAMENTO: '',
      NOME_CONSUMIDOR: consignado[0].nome,
      NRCAIXA: '001',
      OBSERVACAO: '',
      PRAZO: 0,
      PREVENDA: '',
      REGRA: '',
      STATUS: consignado[0].status,
      TABELA: consignado[0].tabelaPreco,
      USUARIO: getCookie('usuario'),
      VALOR_PROMO: 0,
      BASE_DESC: 0,
      VALOR: 0,
      VALOR_BRUTO: 0,
      ITENS: [],
      LISTABARRALOG: [],
      TIPO: 'P',
      CONSIGNADO: consignado.map(item => ({ id: item.id })).toArray()
    };

    let ids = capa.CONSIGNADO.map(c => c.id).join(',');
    const itensConsignados = await itensConsignadosProcessados(ids);

    const mapaItens = {};

    for (const item of itensConsignados) {
      const chave = `${item.CODIGO}-${item.COR}-${item.TAM}`;

      if (!mapaItens[chave]) {
        mapaItens[chave] = {
          ...item,
          QTDE: 0,
          VALOR: 0
        };
      }

      if (item.TIPO === 'S') {
        mapaItens[chave].QTDE += item.QTDE;
        mapaItens[chave].VALOR += item.QTDE * item.PRECO;
      } else if (item.TIPO === 'D') {
        mapaItens[chave].QTDE -= item.QTDE;
        mapaItens[chave].VALOR -= item.QTDE * item.PRECO;
      }
    }

    for (const key in mapaItens) {
      const item = mapaItens[key];

      if (item.QTDE > 0) {
        const precoTotal = TruncaDecimaisNova(2, item.VALOR);

        capa.ITENS.push({
          BASEDESC_REGRAPROMO: 0,
          PERCDESC_REGRAPROMO: 0,
          VALORDESC_REGRAPROMO: 0,
          BARRA: item.BARRA,
          CAIXA: '',
          CODREP: consignado[0].codrep,
          CODVENDEV: 0,
          CODIGO: item.CODIGO,
          CONCATENACAO: `${item.CODIGO} - ${item.DESCRICAO}`,
          COR: item.COR,
          DEPOSITO: item.DEPOSITO,
          DESCONTO: 0,
          DT_INCLUSAO: dtAtual,
          ID_ESTOQUE: item.ID,
          LOTE: '000000',
          ORDEM_PED: 0,
          PEDIDO: 0,
          PERC_DESC: 0,
          PERC_ICMS: 0,
          PRECO_CUSTO: 0,
          PRECO_LIQ: item.PRECO,
          PRESENTE: false,
          PROMOCAO: false,
          QUALIDADE: '1',
          QUANTIDADE: item.QTDE,
          TAM: item.TAM,
          TIPO: 'P',
          TOTAL: precoTotal,
          TOTAL_LIQ: precoTotal,
          VALOR: item.PRECO,
          VALOR_DESC: 0
        });

        capa.BASE_DESC += precoTotal;
        capa.VALOR += precoTotal;
        capa.VALOR_BRUTO += precoTotal;
      }
    }

    capa.CODVEN = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
    return capa;
  }

  await preencheOrdenacaoTela('RelConsignadoIndividual');
  retornaHintRelatorio('btnImprimirIndividual', 'RelConsignadoIndividual')

  $('#btnGerarVenda').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const tabelaConsignado = $('#tabelaConsignado').DataTable().data().toArray()
      let cliente = null;

      for (const item of tabelaConsignado) {
        if (!cliente) {
          cliente = item.codcli;
          continue;
        }

        if (cliente !== item.codcli) {
          throw new Error('Há mais de um cliente na tabela. Por favor, selecione apenas um cliente para continuar.');
        }
      }

      const consignado = await retornaJsonVenda(this);

      await geraVenda(consignado)

    } catch (error) {
      return msgAlerta(error.message || 'Não foi possível realizar o processamento dos consignados.')
    } finally {
      $.LoadingOverlay('hide')
      setTimeout(() => { $('#btnConsultar').trigger('click') }, 200)
    }
  })

  $('#tabelaConsignado').on('click', '#btnAlterarStatus', async function () {
    const data = $('#tabelaConsignado').DataTable().rows($(this).closest('tr')).data()[0];
    $('#tituloAlteraStatus').html(`Alteração de Status | [${data.id}] - ${data.nome}`)
    await senhaSupervisor('Para conseguir alterar um status é necessário informar a senha de supervisor',
      async () => $('#modal-altera-status').modal('show')
    )

  })

  $('#tabelaConsignado').on('click', '#btnAlterarAcerto', async function () {
    $('#modal-altera-acerto').modal('show')
  })

  $('#btnConfirmarAlteraAcerto').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const table = $('#tabelaConsignado').DataTable()
      const dados = table.rows('.selected').data()[0]
      table.rows().data().filter((item) => {
        if (item.codcli != dados.codcli) {
          throw new Error('Contém mais de um cliente no grid. Impossível continuar, selecione apenas um cliente!')
        }
      })

      const body = {
        data: $('#tabelaConsignado').DataTable().data().toArray()
      }

      const response = await requisicao('POST', '/sisplan/consignado/v1/alteraracerto?', `&DATA_NOVA=${$('#dtAcerto').val()}&`, JSON.stringify(body), 36000000)

      if (!response) {
        return
      }

      if (response.status != 200) {
        toastr.error('Não foi possível alterar a Data de Acerto!', "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          onHidden() {
            $('#modal-alterar-acerto').modal('hide')
            $('#dtAcerto').val('')
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

        return
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#btnConsultar').trigger('click')
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível alterar a Data de Acerto do consignado. Por favor, verifique!')
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#btnConfirmarAlteraStatus').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const valor = $('#tituloAlteraStatus').html().match(/\[(.*?)\]/)[1]
      const response = await requisicao('POST', '/sisplan/consignado/v1/alterarstatus?', `ID=${valor}&STATUS_NOVO=${pegaChave('#txtStatusAltera')}`, 36000000)

      if (!response) {
        return
      }

      if (response.status != 200) {
        toastr.error('Não foi possível alterar o status!', "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

        return
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        onHidden() {
          $('#modal-altera-status').modal('hide')
          $('#txtStatusAltera').val('')
          $('#btnConsultar').trigger('click')
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível alterar o status do consignado. Por favor, verifique!')
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#tabelaConsignado').on('click', '#btnGerarNotaFiscal', async function (event) {
    event.preventDefault();

    var data = $('#tabelaConsignado').DataTable().row($(this).parents('tr')).data();

    insereValor('#txtClienteNFE', data.codcli, data.nome)
    $('#txtIDConsignado').val(data.id);
    $('#txtTipoNFE').val(data.tipo);

    $('#btnNaturezaNFE').unbind();
    if (data.tipo == 'D') {
      if (!((data.quantidadeDev - data.quantidadeFatDev) > 0)) {
        return msgAlerta('Não existem itens de Devolução Pendentes para Faturar. Impossível Continuar')
      }

      $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '2'"] }`);
      $('#btnNaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '2'"]}`, 'Pesquisa Natureza', 'natureza');
    } else {
      $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
      $('#btnNaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
    }

    $('#modalNFE').modal('show');
  });

  function retornaItens() {
    let arrItens = [];
    $('#tabelaItens').DataTable().rows().data().map(item => {
      arrItens.push({
        codigo: item.codigo,
        cor: item.cor,
        tamanho: item.tamanho,
        quantidade: item.quantidade,
        preco: item.preco,
        tipo: item.tipo
      })
    });

    return arrItens;
  };

  $('#tabelaConsignado').on('click', '#btnCancelarConsignado', async function (event) {
    event.preventDefault();

    msgAlerta('Tem certeza que deseja cancelar?',
      async function () {
        await senhaSupervisor('Para conseguir cancelar um consignado é necessário informar a senha de supervisor',
          async () => cancelarConsignado(),
        )
      },
      undefined,
      undefined,
      undefined
    );
  });

  async function cancelarConsignado() {
    $.LoadingOverlay('show')
    try {
      let data = $('#tabelaConsignado').DataTable().row('.selected').data();
      if (data.codven) {
        throw new Error('Consignado já possui uma venda vinculada. Impossível cancelar.')
      }
      if (data.situacao === 'C') {
        throw new Error('Consignado já está cancelado.')
      }
      const consignado = {
        numeroDocumento: data.id,
        deposito: data.deposito,
        tipo: data.tipo,
        itens: retornaItens(),
      };

      const response = await requisicao('DELETE', `/sisplan/consignado/v1/cancelar?`, `JSON=${JSON.stringify(consignado)}`, 15000)

      if (!response) {
        return
      }

      if (response.status != 200) {
        toastr.error('Não foi possível cancelar o consignado.', "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

        return
      }

      toastr.success("Consignado excluído com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#btnConsultar').trigger('click')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível cancelar o consignado.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  // $('#tabelaConsignado').on('click', '#btnGerarNotaFiscalDevolucao', async function (event) {
  //   event.preventDefault();
  //   var data = $('#tabelaConsignado').DataTable().row($(this).parents('tr')).data();

  //   insereValor('#txtClienteNFE', data.codcli, data.nome)
  //   $('#txtIDConsignado').val(data.id);

  //   $('#btnNaturezaNFE').unbind();
  //   $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '2'"] }`);
  //   $('#btnNaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '2'"]}`, 'Pesquisa Natureza', 'natureza');
  //   $('#modalNFE').modal('show');
  // });

  $('#modalNFE').on('hidden.bs.modal', function () {
    $('#txtOperacaoNota').val('');
  });

  $('#btn_confirmar_nfe').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      const operacao = pegaChave('#txtOperacaoNota');
      let validacao = ''
      if (operacao != '') {
        validacao = $('#txtClienteNFE').val() != ''
      } else {
        validacao = $('#txtNaturezaNFE').val() != '' && $('#txtClienteNFE').val() != ''
      }
      const nota = {};
      nota.CONSIGNADO = {
        ID_CONSIGNADO: $('#txtIDConsignado').val(),
        TIPO: $('#txtTipoNFE').val() === 'D' ? 'VENCONSIG_DEV' : 'VENCONSIG_VEN'
      }
      nota.NATUREZA = $('#txtNaturezaNFE').val();
      nota.CLIENTE = $('#txtClienteNFE').val();
      nota.OPERACAO = $('#txtOperacaoNFE').val();

      const jsonNota = JSON.stringify(nota);

      if (parent && parent.abrirEmNovaAbaIFrame) {
        parent.abrirEmNovaAbaIFrame('Faturamento Geral', `${BASE_URI}/faturamento`, `/${criptografaUrl(jsonNota)}`);
        parent.removerTelaCheia();

        let iframe = parent.document.querySelector('#panel--sisplan_web-consignado iframe');
        let src = iframe.getAttribute("src");
        iframe.setAttribute("src", src);
      } else {
        console.error("A função do pai não está definida ou não pode ser acessada.");
      }

    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function geraVenda(consignado) {
    try {
      const response = await requisicao('POST', '/sisplan/vendas/v1/venda?', `FECHAF10=${false}&NRSERIE=${getCookie('serie_ecf')}`, `JSON=${encodeURIComponent(JSON.stringify(consignado))}`, 180000);

      if (!response) {
        return false;
      }

      const jsonStrConsig = await response.json();

      if (response.status != 200) {
        toastr.error(jsonStrConsig.mensagem, "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

        return
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        async onHidden() {
          if (parent.verificaTelaAbertaVenda('Loja')) {
            msgAlerta("Tela já aberta, verifique.");
            return;
          }
          parent.abrirEmNovaAbaIFrame('Loja Principal', `${BASE_URI}/loja`);
          $('#btnLimparFiltros').trigger('click')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (error) {
      throw new Error(error.message || 'Não foi possível gravar o consignado');
    }
  }

  $('#tabelaConsignado').on('click', '#btnImprimirIndividual', async function () {
    try {
      const data = $('#tabelaConsignado').DataTable().row($(this).closest('tr')).data();
      imprimirIndividual({ id: data.id })

    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao validar os dados.')
    }
    // $('#modal-seleciona-ordenacao').modal('show')
  });

  const imprimirIndividual = async ({ id }) => {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/impressao/v1/orcamento_cortina_individual?`;
      const ordem = `&TELA_ORDENACAO=RelOrcamentoCortinaIndividual&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrcamentoCortinaIndividual');
      let arquivo = await GeraRelatorio(`${url}${ordem}&ID=${id}`, 'GET', 1000000, false, 'RelConsignadoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnImprimir').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/impressao/v1/orcamento_cortina?`;
      const filtros = await retornaFiltros()
      const ordem = `&TELA_ORDENACAO=RelOrcamentoCortina&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelConsignado');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrcamentoCortina');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  retornaHintRelatorio('btnImprimirIndividual', 'RelConsignadoIndividual')

  // $('#tabelaConsignado').on('dblclick', 'tr', async function () {
  //   if (permissaoUsuarioLogado.ALTERA == 'S') {
  //     const data = $('#tabelaConsignado').DataTable().row($(this)).data();
  //     window.location.href = `consignado/${data.id}`;
  //   } else {
  //     msgAlertaSemConfirmacao("Sem permissão para alterar!");
  //   }
  // });

  function retornaBotaoOpcoes(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Cancelar" id="btnCancelarConsignado">Cancelar</button>     ' +
      '    <div class="dropdown-divider"></div>' +
      // '    <button class="dropdown-item" type="button" title="Conferência" id="btnConferencia">Conferência</button>     ' +
      '    <button class="dropdown-item" type="button" title="Alterar Status" id="btnAlterarStatus">Alterar Status</button>     ' +
      '    <button class="dropdown-item" type="button" title="Alterar Status" id="btnAlterarAcerto">Alterar Data de Acerto</button>     ' +
      '    <div class="dropdown-divider"></div>' +
      // `    <button class="dropdown-item" type="button" ${row.situacao === 'P' ? '' : 'disabled'} title="Gerar Venda" id="btnGerarVenda">Processar</button>     ` +
      `    <button class="dropdown-item" type="button" title="Gerar NFe" id="btnGerarNotaFiscal">Gerar NFE ${row.tipo === 'S' ? 'Venda' : 'Devolução'}</button>    ` + //${/*row.tipo === 'S' ? '' : 'disabled'*/}
      // `    <button class="dropdown-item" type="button" ${row.tipo === 'D' ? '' : 'disabled'} title="Gerar NFe" id="btnGerarNotaFiscalDevolucao">Gerar NFe Devolução</button>     ` +
      '    <div class="dropdown-divider"></div>' +
      '    <button class="dropdown-item" type="button" title="Imprimir" id="btnImprimirIndividual">Imprimir</button>     ' +
      '</div>';
    return retorno;
  };

  async function retornaFiltros() {
    const sDtIni = `${$('#dtIni').val()} 00:00:00`;
    const sDtFim = `${$('#dtFim').val()} 23:59:59`;
    const sDtAcertoIni = $('#dtAcertoIni').val();
    const sDtAcertoFim = $("#dtAcertoFim").val();
    const sCliente = pegaChave("#txtCliente");
    const sStatus = pegaChave('#txtStatus');
    const sVendedor = pegaChave('#txtVendedor');
    const sRegiao = pegaChave('#txtTabPreco');
    const sId = await formataListas($('#txtConsignado').val().toString());
    const sSituacao = $('input[name="rdListar"]:checked').val();

    const filtros =
      `&DT_INI=${sDtIni}` +
      `&DT_FIM=${sDtFim}` +
      `&DT_ACERTO_INI=${sDtAcertoIni}` +
      `&DT_ACERTO_FIM=${sDtAcertoFim}` +
      `&CLIENTE=${sCliente}` +
      `&STATUS=${sStatus}` +
      `&VENDEDOR=${sVendedor}` +
      `&REGIAO=${sRegiao}` +
      `&ID=${sId}` +
      `&SITUACAO=${sSituacao}`;

    return filtros;
  };

  function calcularTotalizadores() {
    const tabela = $('#tabelaConsignado').DataTable()
    const linhaSelecionada = tabela.row($('.selected')).data()

    linhaSelecionada.codcli
    linhaSelecionada.dataAcerto

    $('#txtQuantidadeTotal').val(linhaSelecionada.quantidade)
    $('#txtValorTotal').val(formataValor(linhaSelecionada.valor))

    let edtQtdeSaida = 0;
    let edtVlSaida = 0;
    let edtQtdePendente = 0;
    let edtQtdeDevolucao = 0;
    let edtVlDevolucao = 0;
    let edtTotalAcerto = 0;
    let edtQtdeAcerto = 0;
    let edtPercAcerto = 0;
    let edtValPendente = 0;

    tabela.data().map((item) => {
      if (linhaSelecionada.codcli === item.codcli && linhaSelecionada.dataAcerto === item.dataAcerto) {
        if (item.situacao === "P") {
          if (item.tipo === "S") {
            edtQtdeSaida = edtQtdeSaida + item.quantidade;
            edtVlSaida = edtVlSaida + item.valor;
            edtQtdePendente = edtQtdePendente + item.quantidade;
          } else if (item.tipo === "D") {
            edtQtdeDevolucao = edtQtdeDevolucao + item.quantidade;
            edtVlDevolucao = edtVlDevolucao + item.valor;
            edtQtdePendente = edtQtdePendente - item.quantidade;
          }
        } else if (item.tipo === "S") {
          edtQtdeSaida = edtQtdeSaida + item.quantidade;
          edtVlSaida = edtVlSaida + item.valor;
          edtTotalAcerto = TruncaDecimaisNova(2, edtTotalAcerto + item.valor);
          edtQtdeAcerto = TruncaDecimaisNova(2, edtQtdeAcerto + item.quantidade);
        } else if (item.tipo === "D") {
          edtQtdeDevolucao = edtQtdeDevolucao + item.quantidade;
          edtVlDevolucao = edtVlDevolucao + item.valor;
          edtTotalAcerto = TruncaDecimaisNova(2, edtTotalAcerto - item.valor);
          edtQtdeAcerto = TruncaDecimaisNova(2, edtQtdeAcerto - item.quantidade);
        }
      }
    })

    if (edtTotalAcerto < 0) edtTotalAcerto = 0;

    edtPercAcerto = (edtTotalAcerto / edtVlSaida) * 100;
    edtValPendente = edtVlSaida - edtVlDevolucao;

    $('#txtQuantidadeSaida').val(TruncaDecimaisNova(2, edtQtdeSaida));
    $('#txtValorSaida').val(formataValor(TruncaDecimaisNova(2, edtVlSaida)));
    $('#txtQuantidadePendente').val(TruncaDecimaisNova(2, edtQtdePendente));
    $('#txtQuantidadeDevolvida').val(TruncaDecimaisNova(2, edtQtdeDevolucao));
    $('#txtValorDevolvido').val(formataValor(TruncaDecimaisNova(2, edtVlDevolucao)));
    $('#txtQuantidadeAcerto').val(TruncaDecimaisNova(2, edtQtdeAcerto));
    $('#txtValorPendente').val(formataValor(TruncaDecimaisNova(2, edtValPendente)));
    $('#txtTotalAcerto').val(formataValor(TruncaDecimaisNova(2, edtTotalAcerto)));
    $('#txtPercAcerto').val(TruncaDecimaisNova(2, edtPercAcerto));
  }

  function retornaFiltrosAuxiliares() {
    const tabela = $('#tabelaConsignado').DataTable()

    const tabelaConsignado = tabela.row($('.selected')).data()

    if (!tabelaConsignado) return

    const sDtAcerto = tabelaConsignado?.dataAcerto.split('T')[0];
    const sCliente = tabelaConsignado?.codcli;
    const sId = tabelaConsignado?.id;

    const filtros =
      `&DATA_ACERTO=${sDtAcerto}` +
      `&CLIENTE=${sCliente}` +
      `&ID=${sId}`;

    return filtros;
  };

  async function buscaGridPrincipal() {
    if ($.fn.DataTable.isDataTable('#tabelaConsignado')) {
      $('#tabelaConsignado').DataTable().clear().draw();
    }
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().clear().draw();
    }
    if ($.fn.DataTable.isDataTable('#tabelaAcerto')) {
      $('#tabelaAcerto').DataTable().clear().draw();
    }
    try {
      $.LoadingOverlay("show");

      $('#btnGerarVenda').prop('disabled', false)

      const params = await retornaFiltros()

      const response = await requisicao('GET', '/sisplan/consignado/v1/buscagridprincipal?', params);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      if (!jsonStr.resultado) {
        return
      }

      for (const item of jsonStr.resultado) {
        if (item.situacao != 'P') {
          $('#btnGerarVenda').prop('disabled', true)
          break
        }
      }
      $("#tabelaConsignado").DataTable({
        searching: false,
        paging: true,
        destroy: true,
        lengthChange: false,
        colReorder: true,
        scrollX: true,
        scrollY: '300px',
        info: false,
        scroller: true,
        deferRender: true,
        order: [[12, 'asc'], [13, 'desc']],
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columns: columnsGridPrincipal,
        data: jsonStr.resultado ? jsonStr.resultado : [],
        columnDefs: [
          {
            type: 'date-br',
            targets: [3, 4, 21],
            render: function (data) {
              if (data != undefined && data != '') {
                const x = data.slice(0, 10).split('-');
                const hora = data.split(' ')[1];
                if (x[2]) {
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return `${x} ${hora}`;
                }
              } else {
                return '';
              }
            }
          },
          {
            render(data, type, row) {
              return retornaBotaoOpcoes(data, row);
            },
            targets: 0,
          },
          {
            targets: [19],
            render(data) {
              return new Intl.NumberFormat('pt-BR', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
              }).format(data)
            },
          },
          {
            targets: [14, 18, 19, 22, 23, 24, 25],
            "className": 'pr-4 text-right'
          }
        ],
        rowCallback: function (row, data) {
          if (data.situacao === "P") {
            $(row).css('color', 'green');
            $(row).css('font-weight', 'bold');
          }
          if (data.tipo === 'D') {
            $(row).css('color', 'red');
            $(row).css('font-weight', 'bold');
          }
        },
      });

      $('#tabelaConsignado_wrapper').addClass('row');
      $('#tabelaConsignado_wrapper').prepend('<button class="buttonColVis" id="buttonColVisConsignado"><i class="fas fa-cogs"></i></button>');
      $('#tabelaConsignado_wrapper').prepend('<button class="buttonExcel ml-2" id="buttonExcelConsignado"><i class="fas fa-file-excel"></i></button>');
      // $('#tabelaConsignado_wrapper').removeClass('dts');
      // $('#tabelaConsignado_wrapper').prop('style', 'display: flex !important');
      $('#tabelaConsignado_wrapper').removeClass('dts');
      $('#tabelaConsignado_paginate').remove()
      $('#tabelaConsignado tbody').css('height', '300px')

      $('#buttonColVisConsignado').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcelConsignado').prop('title', 'Exportar')

      $('#buttonColVisConsignado').on('click', async function () {
        $.LoadingOverlay('show');
        localStorage.setItem('tabelaConsignado', 'true')
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcelConsignado').on('click', async function () {
        if ($('#tabelaConsignado').DataTable().data().length > 0) {
          const tabelaConsignado = $('#tabelaConsignado').DataTable().row($('.selected').closest('tr')).data()
          await exportaCSV('', '', true, null, `Consignado - ${tabelaConsignado.id}`, undefined, '', 999, false, false, jsonStr.resultado)
        }
      })

      $("#tabelaConsignado tbody").on("click", "tr", async function () {
        $("#tabelaConsignado tbody tr td")[0].click();
        $("#tabelaConsignado tbody tr.selected").removeClass("selected");
        $(this).addClass("selected");

        setTimeout(async () => { calcularTotalizadores() }, 50)
        setTimeout(async () => { await buscaGridAuxiliares() }, 50)
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaConsignado').DataTable().columns(colunas.tabelaConsignado ?? []).visible(false);
      $('#tabelaConsignado').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.tabelaConsignado).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#tabelaConsignado').DataTable().columns.adjust().draw();

      setTimeout(async () => { $("#tabelaConsignado tbody tr td")[0].click() }, 50)

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaConsignado tbody").on("click", "tr", async function () {
    $("#tabelaConsignado tbody tr td")[0].click();
    $("#tabelaConsignado tbody tr.selected").removeClass("selected");
    $(this).addClass("selected");

    setTimeout(async () => { calcularTotalizadores() }, 50)
    setTimeout(async () => { await buscaGridAuxiliares() }, 50)
  });

  async function buscaGridAuxiliares() {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaAcerto')) {
      $('#tabelaAcerto').DataTable().destroy();
      $('#tabelaAcerto').empty();
    }
    try {
      const params = retornaFiltrosAuxiliares()
      if (!params) return

      const response = await requisicao('GET', '/sisplan/consignado/v1/buscagridsauxiliares?', params);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }
      const jsonStr = await response.json();

      $("#tabelaItens").DataTable({
        destroy: true,
        paging: false,
        searching: false,
        info: false,
        lengthChange: false,
        pageLength: 6,
        scrollY: '200px',
        scrollX: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsGridItens,
        data: jsonStr.gridItens ? jsonStr.gridItens : [],
        columnDefs: [{
          type: 'date-br',
          targets: [12, 13],
          render: function (data) {
            if (data != undefined && data != '') {
              x = data.slice(0, 10).split('-');
              hora = data.split(' ')[1]
              if (x[2]) {
                return `${x[2]}/${x[1]}/${x[0]}`
              } else {
                return `${x} ${hora} `;
              }
            } else {
              return ''
            }
          }
        },
        {
          targets: [5, 6, 7, 8, 9, 10, 11, 23],
          "className": 'pr-4 text-right'
        },
        {
          targets: [6, 7, 23],
          render(data) {
            return new Intl.NumberFormat('pt-BR', {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
            }).format(data)
          },
        },
        ],
        rowCallback: function (row, data) {
          if (data.tipo === 'D') {
            $(row).css('color', 'red');
            $(row).css('font-weight', 'bold');
          }
        },
      });

      const colunasInvisiveisItens = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaItens_wrapper').prepend('<button class="buttonColVis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>');
      $('#tabelaItens_wrapper').prepend('<button class="buttonExcel ml-2" id="buttonExcelItens"><i class="fas fa-file-excel"></i></button>');
      $('#tabelaItens_wrapper').addClass('row');

      $('#buttonColVisItens').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcelItens').prop('title', 'Exportar')

      $('#buttonColVisItens').on('click', async function () {
        $.LoadingOverlay('show');
        localStorage.setItem('tabelaItens', 'true')
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcelItens').on('click', async function () {
        if ($('#tabelaItens').DataTable().data().length > 0) {
          const tabelaConsignado = $('#tabelaConsignado').DataTable().row($('.selected').closest('tr')).data()
          await exportaCSV('', '', true, null, `Itens - ${tabelaConsignado.id}`, undefined, '', 999, false, false, jsonStr.gridItens)
        }
      })

      $('#tabelaItens').DataTable().columns().every(
        function () {
          if ((colunasInvisiveisItens.tabelaItens).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#tabelaItens th').on('click', async function () {
        const nomeColuna = $(this).html();
        const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
        const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
        await buscaDados(nomeColuna + ' ' + ordenacao);
      });

      $("#tabelaAcerto").DataTable({
        destroy: true,
        paging: false,
        searching: false,
        info: false,
        lengthChange: false,
        pageLength: 6,
        scrollX: true,
        scrollY: '200px',
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columns: columnsGridAcerto,
        data: jsonStr.gridAcerto ? jsonStr.gridAcerto : [],
        columnDefs: [{
          targets: [5, 8],
          "className": 'pr-4 text-right'
        },
        {
          targets: [5],
          render(data) {
            return new Intl.NumberFormat('pt-BR', {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
            }).format(data)
          },
        },]
      });

      const colunasInvisiveisAcerto = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaAcerto_wrapper').prepend('<button class="buttonColVis" id="buttonColVisAcerto"><i class="fas fa-cogs"></i></button>');
      $('#tabelaAcerto_wrapper').prepend('<button class="buttonExcel ml-2" id="buttonExcelAcerto"><i class="fas fa-file-excel"></i></button>');
      $('#tabelaAcerto_wrapper').addClass('row');

      $('#buttonColVisAcerto').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcelAcerto').prop('title', 'Exportar')

      $('#buttonColVisAcerto').on('click', async function () {
        $.LoadingOverlay('show');
        localStorage.setItem('tabelaAcerto', 'true')
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcelAcerto').on('click', async function () {
        if ($('#tabelaAcerto').DataTable().data().length > 0) {
          const tabelaConsignado = $('#tabelaConsignado').DataTable().row($('.selected').closest('tr')).data()
          await exportaCSV('', '', true, null, `Acerto - ${tabelaConsignado.id}`, undefined, '', 999, false, false, jsonStr.gridAcerto)
        }
      })

      $('#tabelaAcerto').DataTable().columns().every(
        function () {
          if ((colunasInvisiveisAcerto.tabelaAcerto).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#tabelaConsignado th').on('click', async function () {
        const nomeColuna = $(this).html();
        const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
        const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
        await buscaDados(nomeColuna + ' ' + ordenacao);
      });
    } catch (error) {
      console.error(error);
    }
  };

  function addFuncoesBotoes() {
    componenteFiltro('cliente', false, false)
    componenteFiltro('vendedor', false, false, '', [`ATIVO = 'S'`])
    componenteFiltro('status', false, false, '', [`ORCAMENTO = 'S'`])
    componenteFiltro('tabPreco')
    componenteFiltro('consignado', true, true)

    componenteFiltro('cliente', false, false, 'ClienteNFE')
    componenteFiltro('operacao', false, false, 'OperacaoNFE')

    componenteFiltro('status', false, false, 'StatusAltera', ["ORCAMENTO = 'S'"])

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtCliente').val('');
      $('#txtVendedor').val('');
      $('#txtStatus').val('');
      $("#txtTabPreco").val('');
      $("#dtAcertoIni").val("1200-01-01");
      $("#dtAcertoFim").val("2500-12-01");

      $('#txtConsignado').empty().trigger('change');
      $('#txtConsignado').val('');
      $('#txtConsignado').attr('data-chave', '');
      $('#txtConsignado').attr('data-desc', '');

      const date = new Date();
      const firstDay = new Date(date.getFullYear(), 0, 1);//ta setando a data de inicio sempre pro primeiro dia do ano, melhor pra consultar em larga escala e não quebrar o datatable
      $('#dtIni').val(formataData(firstDay));
      await setarDataAtual('dtFim')
    });
  };

  async function buscaItensConferencia() {
    const body = {
      GridPrincipalConsignado: $('#tabelaConsignado').DataTable().data().toArray()
    }
    try {
      const response = await requisicao('POST', '/sisplan/consignado/v1/buscaconferencia?', ``, JSON.stringify(body), 15000)

      if (!response) {
        return
      }

      const jsonStr = await response.json()

      $("#tabelaConferencia").DataTable({
        order: [],
        sort: false,
        paging: false,
        destroy: true,
        autoWidth: true,
        colReorder: true,
        lengthChange: false,
        lengthMenu: false,
        searching: false,
        info: false,
        scrollX: true,
        scrollY: '500px',
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columns: columnsConferencia,
        data: jsonStr.Conferencia ? jsonStr.Conferencia : [],
        columnsDefs: [
          {
            targets: [4, 8, 9],
            "className": 'pr-4 text-right'
          }
        ],
        rowCallback: async function (row, data) {
          let colunaConferida = $(`td:eq(5)`, row);
          // let colunaTipoConferencia = $(row).find('td').eq(5);

          // colunaTipoConferencia.text($('#selectConferencia').val() || 'N/A');

          // let table = $('#tabelaItens').DataTable();
          // let rowData = table.row(row).data();
          // rowData.TIPO_CONF = $('#selectConferencia').val();

          // table.row(row).data(rowData);

          colunaConferida.css('display', 'flex');
          colunaConferida.empty().append(
            $('<input>', {
              type: 'number',
              min: 0,
              id: `txtQuantidadeVenda_${row._DT_RowIndex}`,
              class: 'input-default focus form-control text-right txtQuantidadeVenda',
              value: data.quantidadeVenda,
              blur: function () {
                if ($(this).val() === '') {
                  $(this).val(0)
                }
                if (parseFloat(this) !== 0) {
                  data.quantidadeVenda = parseFloat($(this).val())

                  if (data.quantidadeVenda > data.quantidade) {
                    $(this).val(0)
                    msgAlerta('Quantidade de retorno não pode ser maior que a quantidade!')
                    return
                  }
                }
              },
              focus: function () {
                if ($(this).val() == '0') {
                  $(this).val('')
                }
              }
            }).css({
              width: '180px',
              'box-sizing': 'border-box'
            }),
          );
        },
      });
      setTimeout(() => { $('#tabelaConferencia').DataTable().columns.adjust().draw() }, 50)

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível buscar os consignados para conferir')
    }
  }

  $('#tabelaConsignado').on('click', '#btnConferencia', async function () {
    const data = $('#tabelaConsignado').DataTable().rows($(this).closest('tr')).data()[0];

    await buscaItensConferencia(data.id)

    $('#modal-conferencia').modal('show')
  });

  $('#txtDiasConf').on('focus', function () {
    if ($(this).val() == 0) {
      $(this).val('')
    }
  })

  $('#txtDiasConf').on('blur', function () {
    if ($(this).val() == '') {
      $(this).val(0)
    }

    const dias = parseInt($(this).val());
    const dataAtual = new Date();

    dataAtual.setDate(dataAtual.getDate() + dias);

    const dia = ("0" + dataAtual.getDate()).slice(-2);
    const mes = ("0" + (dataAtual.getMonth() + 1)).slice(-2);
    const ano = dataAtual.getFullYear();
    const dataFormatada = `${ano}-${mes}-${dia}`;

    $('#dtAcertoConf').val(dataFormatada);
  });

  $('#cbNovoConsignado').on('change', function () {
    if ($('#cbNovoConsignado').is(':checked')) {
      $('#dtAcertoConf').prop('disabled', false)
    } else {
      $('#dtAcertoConf').prop('disabled', true)
    }
  })

  async function gravaConferencia() {
    try {
      const tabelaConferencia = $('#tabelaConferencia').DataTable().data()
      const tabelaConsignado = $('#tabelaConsignado').DataTable().row($('.selected').closest('tr')).data()

      const quantidade = tabelaConferencia.reduce((acc, current) => { return acc + current.quantidade }, 0)
      const quantidadeVenda = tabelaConferencia.reduce((acc, current) => { return acc + current.quantidadeVenda }, 0)

      if ((quantidade - quantidadeVenda) === 0) {
        throw new Error('A soma da quantidade menos a quantidade de venda é 0. Não foi possível realizar a conferência.')
      }

      const body = {
        Conferencia: tabelaConferencia.toArray(),
        Consignado: tabelaConsignado,
        data_acerto: tabelaConsignado.dataAcerto,
        data_acerto_input: `${$('#dtAcertoConf').val()}T00:00:00.000Z`,
        novo_consignado: $('#cbNovoConsignado').is(':checked') ? '1' : '0',
        dias: $('#txtDiasConf').val(),
      }

      const response = await requisicao('POST', '/sisplan/consignado/v1/confirmaconferencia?', '', JSON.stringify(body), 3600000)

      if (!response) {
        return
      }

      if (response.status != 200) {
        const jsonStr = await response.json()
        toastr.error(jsonStr.mensagem, "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

        return
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal-conferencia').modal('hide')
          $('#dtAcertoConf').val('')
          $('#txtDiasConf').val(0)
          $('#cbNovoConsignado').prop('checked', true)
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (error) {
      throw new Error('Não foi possível confirmar a conferência!')
    }
  }

  $('#btnConfirmarConferencia').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      if ($('#dtAcertoConf').val() === '') {
        throw new Error('A Data de Acerto não foi informada. Por favor, verifique!')
      }

      await gravaConferencia()
    } catch (error) {
      msgAlerta(error.message || 'Não foi possível confirmar a conferência!');
    } finally {
      $.LoadingOverlay('hide')
    }
  })

});