$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para filtrar a consulta.',
                position: 'right'
            }
        },
        {
            element: '#btnIncluir',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro de uma região.',
                position: 'right'
            }
        },
        {
            element: '#tabelaClasseGerencial',
            popover: {
                title: 'Tabela Classes Gerenciais',
                description: 'Aqui estão os dados das Classes Gerenciais.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CLASSEGERENCIAL");

    $('#txtClasseGerencial').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO chave", "descricao"], "where": null}`);
    $('#btn-ClasseGerencial').pesquisa('#txtClasseGerencial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'classe_ger');
    $('#btn-limpa-ClasseGerencial').on('click', function () {
        $('#txtClasseGerencial').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnIncluir').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "classegerencial/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    function retornaBotaoOpcoes(data, row) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ';
        if (row.LANCA_RATEIO == 'S') {
            retorno += '    <button class="dropdown-item" type="button" title="Rateio" id="btn-rateio">Rateio</button>  ';
        }
        retorno += '</div>';
        return retorno;
    };

    consultaClasse();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaClasse();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtClasseGerencial').val('');
    });

    async function consultaClasse() {
        try {
            $.LoadingOverlay("show");
            let response;
            let regiao = pegaChave('#txtClasseGerencial') != '' ? ` AND CODIGO = '${pegaChave('#txtClasseGerencial')}'` : '';

            let empId = await usaFatApp() == 'true' ? ` AND EMP_ID = '${getCookie('emp_id')}'` : '';
            response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO", "LANCA_RATEIO"], "where": ["1=1 ${regiao}${empId}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadClasseGerencial == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadClasseGerencial: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaClasseGerencial').DataTable({
                destroy: true,
                lengthChange: true,
                searching: true,
                paging: true,
                scrollX: true,
                scrollY: '350px',
                autoWidth: true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    data: "CODIGO",
                    title: "Código"
                },
                {
                    data: "DESCRICAO",
                    title: "Descrição"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data, row);
                    }
                }]
            });

            $('#tabelaClasseGerencial_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaClasseGerencial_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaClasseGerencial").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso de cadastro de Classe Gerencial', '', '', 999, false, false, dados);
            });

            $('#tabelaClasseGerencial').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadClasseGerencial).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
        }

    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaClasseGerencial').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadClasseGerencial ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["CODIGO"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadClasseGerencial: novasColunas }));

            $('#tabelaClasseGerencial').DataTable().columns().visible(true);

            $('#tabelaClasseGerencial').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaClasseGerencial').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaClasseGerencial').DataTable().row($(this).parents('tr')).data();
            window.location.href = `classegerencial/${data.CODIGO}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }

    });

    $('#tabelaClasseGerencial').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaClasseGerencial').DataTable().row($(this)).data();
            window.location.href = `classegerencial/${data.CODIGO}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }

    });


    $('#tabelaClasseGerencial').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaClasseGerencial").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/classegerencial?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#tabelaClasseGerencial').on('click', '#btn-rateio', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $("#tabelaClasseGerencial").DataTable().row($(this).parents("tr")).data();
            abreModalRateio(data.CODIGO);
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    function abreModalRateio(codigo) {
        try {
            $('#txtCodigoRateio').val(codigo);
            $('#txtTipoRateio').val('C');
            $('#modal-rateio').modal('show');
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }
});